/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.FailedStateEvent;
import com.sun.patchpro.util.FailedStateException;
import com.sun.patchpro.util.FailedStateListener;
import com.sun.patchpro.util.InvalidStartingStateException;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.MalformedStateException;
import com.sun.patchpro.util.NextStateEvent;
import com.sun.patchpro.util.NextStateListener;
import com.sun.patchpro.util.NoSuchStateException;
import com.sun.patchpro.util.State;
import java.util.Enumeration;
import java.util.Stack;

public abstract class StateMachine
implements NextStateListener,
FailedStateListener {
    public PatchProLog log;
    private LocalizedMessages msgcat;
    private PatchProProperties properties;
    private boolean stateTableIsValid = false;
    private int intermediateEndState = -1;
    private int currentStateNo = -1;
    private Enumeration nextStateEnumeration = null;
    protected int[] nextStateArray;
    protected State[] stateTable = null;
    private Stack nextStateEvents = new Stack();
    private Stack failedStateEvents = new Stack();
    private boolean running = false;

    public StateMachine() {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
    }

    protected State[] buildStateTable() {
        State[] stateArray = new State[]{};
        return stateArray;
    }

    public void initialize() {
        if (!this.stateTableIsValid) {
            this.stateTable = this.buildStateTable();
            this.stateTableIsValid = true;
        }
        int n = 0;
        while (n < this.stateTable.length) {
            this.stateTable[n].initialize();
            ++n;
        }
    }

    private synchronized void setRunning() {
        if (this.running) {
            this.log.println(this, 7, "setRunning(): Failed. Already running.");
            new Exception().printStackTrace();
            throw new InvalidStartingStateException("StateMachine.start(): No start is possible. Machine is running.");
        }
        this.running = true;
        this.log.println(this, 7, "setRunning()");
    }

    private synchronized void setDone() {
        this.running = false;
        this.log.println(this, 7, "setDone()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws PatchProException {
        this.setRunning();
        if (!this.stateTableIsValid) {
            this.stateTable = this.buildStateTable();
            this.stateTableIsValid = true;
        }
        this.initialize();
        try {
            this.start(true, 0);
            Object var2_1 = null;
            this.setDone();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.setDone();
            throw throwable;
        }
    }

    public void start(int n, int n2) throws PatchProException {
        this.start(false, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(boolean bl, int n, int n2) throws PatchProException {
        if (!bl) {
            this.setRunning();
        }
        if (!this.stateTableIsValid) {
            this.stateTable = this.buildStateTable();
            this.stateTableIsValid = true;
        }
        if (n2 >= this.stateTable.length) {
            throw new MalformedStateException("StateMachine.start(): Specified end state is not in the state table.");
        }
        this.intermediateEndState = n2;
        try {
            this.start(true, n);
            Object var5_4 = null;
            this.intermediateEndState = -1;
            this.setDone();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.intermediateEndState = -1;
            this.setDone();
            throw throwable;
        }
    }

    public void start(int n) throws PatchProException {
        this.start(false, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void start(boolean var1_1, int var2_2) throws PatchProException {
        try {
            block35: {
                if (!var1_1) {
                    this.setRunning();
                }
                this.log.println(this, 7, "start(...) w/ start state = " + var2_2 + " and end state = " + this.intermediateEndState + ".");
                var4_3 = null;
                var5_4 = false;
                if (!this.stateTableIsValid) {
                    this.stateTable = this.buildStateTable();
                    this.stateTableIsValid = true;
                }
                try {
                    var6_5 = this.stateTable[var2_2].isEntryPoint();
                }
                catch (Exception var7_6) {
                    throw new MalformedStateException("StateMachine.start(): Specified start state is not in the state table.");
                }
                if (!var6_5) {
                    throw new InvalidStartingStateException("StateMachine.start(): Invalid starting state.");
                }
                this.nextStateArray = new int[]{var2_2};
                try {
                    block12: while (true) {
                        if (var5_4) {
                            this.log.println(this, 7, "StateMachine is officially done.");
                            break;
                        }
                        var7_7 = null;
                        var8_10 = 0;
                        while (true) {
                            if (var8_10 >= this.nextStateArray.length) {
                                this.nextStateArray = new int[0];
                                ** try [egrp 3[TRYBLOCK] [1 : 420->429)] { 
lbl29:
                                // 1 sources

                                break;
                            }
                            this.currentStateNo = this.nextStateArray[var8_10];
                            var3_9 = this.stateTable[this.currentStateNo];
                            this.log.println(this, 7, "Starting " + this.currentStateNo + " with state state " + var3_9.getStateState());
                            if (var3_9.reserveState()) {
                                var3_9.addNextStateListener(this);
                                var3_9.addFailedStateListener(this);
                                var3_9.setStateNumber(this.currentStateNo);
                                var7_7 = new Thread(var3_9);
                                var7_7.start();
                                this.log.println(this, 7, "StateMachine: Started state " + this.currentStateNo);
                            } else {
                                if (!var3_9.isSynchronized()) {
                                    this.log.println(this, 4, "StateMachine.run: State " + var3_9.getStateNumber() + " was invoked a second time but it" + " is not synchronized.");
                                    throw new FailedStateException("Reentering unsynchronized state " + var3_9.getStateNumber());
                                }
                                this.log.println(this, 7, "StateMachine.run: State " + var3_9.getStateNumber() + " is synchronized.");
                            }
                            ++var8_10;
                        }
                        {
                            Thread.sleep(150L);
                        }
lbl49:
                        // 1 sources

                        catch (InterruptedException var9_13) {
                            // empty catch block
                        }
                        if (var4_3 != null) {
                            var4_3.setNextStateProcessed(true);
                            var4_3 = null;
                        }
                        if (!this.failedStateEvents.empty()) {
                            var9_12 = (FailedStateEvent)this.failedStateEvents.pop();
                            var10_14 = (State)var9_12.getSource();
                            var11_15 = var10_14.getThrowable();
                            if (var11_15 instanceof RuntimeException) {
                                throw (RuntimeException)var11_15;
                            }
                            if (var11_15 instanceof Error) {
                                throw (Error)var11_15;
                            }
                            if (var11_15 instanceof PatchProException) {
                                throw (PatchProException)var11_15;
                            }
                            var12_16 = var11_15.toString();
                            throw new FailedStateException(this.msgcat.getMessage("statebadthrowable", new String[]{var12_16}, "State failed with unexpected Throwable " + var12_16 + ".  Refer to the log file for " + "more details."), (Throwable)var11_15);
                        }
                        var9_12 = this.nextStateArray;
                        // MONITORENTER : this.nextStateArray
                        this.nextStateArray = new int[0];
                        if (!this.nextStateEvents.empty()) {
                            var11_15 = (NextStateEvent)this.nextStateEvents.pop();
                            var10_14 = (State)var11_15.getSource();
                            if (!var5_4) {
                                if (var10_14.isTerminal() || var10_14.getStateNumber() == this.intermediateEndState && var10_14.getStateState() == 2) {
                                    var5_4 = true;
                                    this.log.println(this, 7, "reached the end state.");
                                }
                                try {
                                    this.log.println(this, 7, "reading state " + var10_14.getStateNumber());
                                    if (!var10_14.isTerminal()) {
                                        this.log.println(this, 7, "State " + var10_14.getStateNumber() + " is not terminal.");
                                        this.nextStateArray = var10_14.getNextState();
                                        var4_3 = var10_14;
                                        this.log.println(this, 7, "nextStates = ");
                                        var12_17 = 0;
                                        break block35;
                                    }
                                    this.log.println(this, 7, "State " + var10_14.getStateNumber() + " is terminal.");
                                    this.nextStateArray = new int[0];
                                }
                                catch (NoSuchStateException var12_18) {
                                    this.log.printStackTrace(this, 4, var12_18);
                                    this.log.println(this, 4, "StateMachine.run: State " + var10_14.getStateNumber() + " indicated a next state but" + " could not produce one.");
                                    this.nextStateArray = new int[0];
                                }
                            } else {
                                this.log.println(this, 4, "StateMachine.run: State " + var10_14.getStateNumber() + " indicated a next state but the" + " terminal state has completed.");
                                this.nextStateArray = new int[0];
                            }
                        }
lbl95:
                        // 6 sources

                        continue block12;
                        break;
                    }
                }
                catch (Error var7_8) {
                    var8_11 = new String("StateMachine.start(): " + var7_8.getMessage());
                    this.log.printStackTrace(this, 4, var7_8);
                    throw new FailedStateException(var8_11);
                }
                var15_19 = null;
                if (var1_1 != false) return;
                this.setDone();
                return;
            }
            if (true) ** GOTO lbl118
        }
        catch (Throwable var14_21) {
            var15_20 = null;
            if (var1_1 != false) throw var14_21;
            this.setDone();
            throw var14_21;
        }
        do {
            this.log.println(this, 7, "  " + this.nextStateArray[var12_17]);
            ++var12_17;
lbl118:
            // 2 sources

        } while (var12_17 < this.nextStateArray.length);
        ** while (true)
    }

    public Object getActionResult(int n) {
        if (n > this.stateTable.length) {
            throw new NoSuchStateException("No such state.");
        }
        return this.stateTable[n].getActionResult();
    }

    public boolean isNextStateProcessed(int n) throws NoSuchStateException {
        if (n > this.stateTable.length) {
            throw new NoSuchStateException("No such state.");
        }
        return this.stateTable[n].isNextStateProcessed();
    }

    public synchronized boolean allDone(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            try {
                if (!this.isNextStateProcessed(nArray[n])) {
                    return false;
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                this.log.println(this, 4, "StateMachine.allDone: State " + nArray[n] + " doesn't exist.");
            }
            ++n;
        }
        return true;
    }

    public int getStateResult(int n) throws NoSuchStateException {
        if (n > this.stateTable.length) {
            throw new NoSuchStateException("No such state.");
        }
        return this.stateTable[n].getStateState();
    }

    public synchronized void processNextState(NextStateEvent nextStateEvent) {
        this.nextStateEvents.push(nextStateEvent);
        ((State)nextStateEvent.getSource()).removeFailedStateListener(this);
        ((State)nextStateEvent.getSource()).removeNextStateListener(this);
    }

    public synchronized void processFailedState(FailedStateEvent failedStateEvent) {
        this.failedStateEvents.push(failedStateEvent);
        ((State)failedStateEvent.getSource()).removeFailedStateListener(this);
        ((State)failedStateEvent.getSource()).removeNextStateListener(this);
    }
}

