/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.diskmgr.client.DiskGraphic;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.SlicePropDialog;
import com.sun.admin.diskmgr.client.SliceSizePanel;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskMgrException;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DiskGraphicBtnPanel
extends JPanel {
    public static final int HELP_CACHE_SIZE = 2;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    private VDiskMgr theApp;
    private SlicePropDialog dialog;
    private DiskGraphic diskGraphic;
    private SliceSizePanel sliceSizePanel;
    public GridBagConstraints gbc;
    protected JButton previewButton;
    protected JButton resetButton;

    public DiskGraphicBtnPanel(VDiskMgr vDiskMgr, VOptionPane vOptionPane) {
        this.theApp = vDiskMgr;
        this.dialog = (SlicePropDialog)vOptionPane;
        ResourceBundle resourceBundle = vDiskMgr.getResourceBundle();
        this.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(resourceBundle, "GraphicPreview");
        this.previewButton = new JButton(actionString.getString());
        this.previewButton.setMnemonic(actionString.getMnemonic());
        this.infoPanel = new GenInfoPanel(vOptionPane);
        this.helpCache = new Vector(2);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "diskpart_preview");
        vDiskMgr.addHelpListener(this.helpListener, this.previewButton);
        ButtonListener buttonListener = new ButtonListener();
        this.previewButton.addActionListener(buttonListener);
        this.previewButton.setEnabled(false);
        Constraints.constrain((Container)this, (Component)this.previewButton, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        actionString = new ActionString(resourceBundle, "GraphicReset");
        this.resetButton = new JButton(actionString.getString());
        this.resetButton.setMnemonic(actionString.getMnemonic());
        this.resetButton.setEnabled(false);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "diskpart_revert");
        vDiskMgr.addHelpListener(this.helpListener, this.resetButton);
        this.resetButton.addActionListener(buttonListener);
        Constraints.constrain((Container)this, (Component)this.resetButton, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)0, (int)6, (int)6);
        JPanel jPanel = new JPanel();
        Constraints.constrain((Container)this, (Component)jPanel, (int)2, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
    }

    private void doPreview() {
        if (this.sliceSizePanel == null) {
            this.sliceSizePanel = this.dialog.getSliceSizePanel();
            this.diskGraphic = this.dialog.getDiskGraphic();
        }
        if (this.sliceSizePanel.isValid()) {
            int n = this.sliceSizePanel.getStartCyl();
            int n2 = this.sliceSizePanel.getEndCyl();
            this.diskGraphic.preview(n, n2);
            this.setPreviewEnabled(false);
            this.setResetEnabled(true);
        } else {
            DiskMgrException diskMgrException = new DiskMgrException("EXM_DM_GUI_PREVIEW");
            this.theApp.reportErrorException((Exception)((Object)diskMgrException), this.dialog.getParentFrame());
        }
    }

    private void doReset() {
        this.setResetEnabled(false);
        this.setPreviewEnabled(false);
        this.sliceSizePanel.initFields();
        this.diskGraphic.reset();
    }

    public void setPreviewEnabled(boolean bl) {
        this.previewButton.setEnabled(bl);
    }

    public void setResetEnabled(boolean bl) {
        this.resetButton.setEnabled(bl);
    }

    private class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DiskGraphicBtnPanel.this.previewButton) {
                DiskGraphicBtnPanel.this.doPreview();
            } else if (actionEvent.getSource() == DiskGraphicBtnPanel.this.resetButton) {
                DiskGraphicBtnPanel.this.doReset();
            }
        }
    }
}

