/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncMgr;

import com.sun.pdasync.SyncUtils.BufferedBytes;
import com.sun.pdasync.SyncUtils.ObjCopy;
import com.sun.pdasync.SyncUtils.ObjDump;
import com.sun.pdasync.SyncUtils.SizeOf;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.util.Calendar;
import java.util.Date;

public class CDTDateTime
implements Cloneable,
ObjCopy,
ObjDump,
SizeOf {
    public short m_Year_u;
    public byte m_Month_u;
    public byte m_Day_u;
    public byte m_Hour_u;
    public byte m_Minute_u;
    public byte m_Seconds_u;
    public byte m_Unused_u;
    public static final int sizeOf = 8;

    public long DTConvertFromHHDate() {
        if (this.m_Year_u == 0 || this.m_Year_u == 1904 && this.m_Month_u == 1 && this.m_Day_u == 1) {
            return 0L;
        }
        if ((this.m_Year_u & 0xFFFF) <= 1970 && (this.m_Year_u & 0xFFFF) > 3000) {
            return 0L;
        }
        if ((this.m_Day_u & 0xFF) < 0 && (this.m_Day_u & 0xFF) >= 31) {
            return 0L;
        }
        if ((this.m_Month_u & 0xFF) < 0 && (this.m_Month_u & 0xFF) >= 12) {
            return 0L;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, this.m_Year_u);
        cal.set(2, this.m_Month_u);
        cal.set(5, this.m_Day_u);
        cal.set(10, this.m_Hour_u);
        cal.set(12, this.m_Minute_u);
        cal.set(13, this.m_Seconds_u);
        return cal.getTime().getTime();
    }

    public void DTConvertToHHDate(int hhDate) {
        this.DTConvertToHHDate(SyncUtils.secondToMillisec((int)hhDate));
    }

    public void DTConvertToHHDate(long hhDate) {
        Date jDate = new Date(hhDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(jDate);
        this.m_Year_u = (short)cal.get(1);
        this.m_Month_u = (byte)(cal.get(2) + 1);
        this.m_Day_u = (byte)cal.get(5);
        this.m_Hour_u = (byte)cal.get(11);
        this.m_Minute_u = (byte)cal.get(12);
        this.m_Seconds_u = (byte)cal.get(13);
    }

    public Object clone() {
        CDTDateTime obj = new CDTDateTime();
        obj.m_Year_u = this.m_Year_u;
        obj.m_Month_u = this.m_Month_u;
        obj.m_Day_u = this.m_Day_u;
        obj.m_Hour_u = this.m_Hour_u;
        obj.m_Minute_u = this.m_Minute_u;
        obj.m_Seconds_u = this.m_Seconds_u;
        obj.m_Unused_u = this.m_Unused_u;
        return obj;
    }

    public String dump() {
        return "<m_Year_u: " + this.m_Year_u + "> <m_Month_u: " + this.m_Month_u + "> <m_Day_u: " + this.m_Day_u + "> <m_Hour_u: " + this.m_Hour_u + "> <m_Minute_u: " + this.m_Minute_u + "> <m_Seconds_u: " + this.m_Seconds_u + "> <m_Unused_u: " + this.m_Unused_u + ">" + "\n";
    }

    public String dumpFormatted() {
        return this.dumpFormatted(0);
    }

    public String dumpFormatted(int numTabs) {
        String tabs = SyncUtils.makeTabsString((int)numTabs);
        return String.valueOf(tabs) + "CDTDateTime\n" + tabs + "  {\n" + tabs + "    m_Year_u:    " + this.m_Year_u + "\n" + tabs + "    m_Month_u:   " + this.m_Month_u + "\n" + tabs + "    m_Day_u:     " + this.m_Day_u + "\n" + tabs + "    m_Hour_u:    " + this.m_Hour_u + "\n" + tabs + "    m_Minute_u:  " + this.m_Minute_u + "\n" + tabs + "    m_Seconds_u: " + this.m_Seconds_u + "\n" + tabs + "    m_Unused_u:  " + this.m_Unused_u + "\n" + tabs + "  }\n";
    }

    public void getObjAt(BufferedBytes pBuff) {
        boolean flipYear = true;
        try {
            this.m_Year_u = flipYear ? SyncUtils.dtPilotToHostWord((short)pBuff.getShort()) : pBuff.getShort();
            pBuff.increment(2);
            this.m_Month_u = pBuff.getByte();
            pBuff.increment(1);
            this.m_Day_u = pBuff.getByte();
            pBuff.increment(1);
            this.m_Hour_u = pBuff.getByte();
            pBuff.increment(1);
            this.m_Minute_u = pBuff.getByte();
            pBuff.increment(1);
            this.m_Seconds_u = pBuff.getByte();
            pBuff.increment(1);
            this.m_Unused_u = pBuff.getByte();
            pBuff.increment(1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public static void main(String[] args) {
        CDTDateTime time = new CDTDateTime();
        System.out.println(time.dump());
        System.out.println(time.dumpFormatted());
        System.out.println(time.dumpFormatted(1));
    }

    public void setObjAt(BufferedBytes pBuff) {
        pBuff.copyShortBytes(this.m_Year_u);
        pBuff.setByte(pBuff.index(), this.m_Month_u);
        pBuff.increment();
        pBuff.setByte(pBuff.index(), this.m_Day_u);
        pBuff.increment();
        pBuff.setByte(pBuff.index(), this.m_Hour_u);
        pBuff.increment();
        pBuff.setByte(pBuff.index(), this.m_Minute_u);
        pBuff.increment();
        pBuff.setByte(pBuff.index(), this.m_Seconds_u);
        pBuff.increment();
        pBuff.setByte(pBuff.index(), (byte)0);
        pBuff.increment();
    }

    public Object setObjFields(CDTDateTime obj) {
        obj.m_Year_u = this.m_Year_u;
        obj.m_Month_u = this.m_Month_u;
        obj.m_Day_u = this.m_Day_u;
        obj.m_Hour_u = this.m_Hour_u;
        obj.m_Minute_u = this.m_Minute_u;
        obj.m_Seconds_u = this.m_Seconds_u;
        obj.m_Unused_u = this.m_Unused_u;
        return obj;
    }

    public int sizeOf() {
        return 8;
    }
}

