/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Transport;

import com.sun.pdasync.CommPort.CommPortConst;
import com.sun.pdasync.CommPort.SerialPortCommunicator;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncUtils.BufferedBytes;
import com.sun.pdasync.SyncUtils.SyncUtils;
import com.sun.pdasync.Transport.CMPINITPACKET;
import com.sun.pdasync.Transport.CTransportBase;
import com.sun.pdasync.Transport.PADDPACKET;
import com.sun.pdasync.Transport.WFRAMEPACKET;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.GregorianCalendar;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;
import javax.swing.Timer;

public class CTransportPAD
extends CTransportBase
implements ActionListener {
    protected static SerialPortCommunicator m_pSerialPort = null;
    public static final int MAX_FRAME_RECV_TIMEOUT_SEC = 2;
    public static final int WAIT_ACK_SLOW = 5;
    public static final int SEND_RETRY_SLOW = 12;
    public static final int MAXRECV_TIMEOUT_SLOW = 90;
    static final int IDS_REGISTRY_MODEMCOMPORT = 1;
    static final int IDS_REGISTRY_DIRECTCOMPORT = 2;
    static final int IDS_REGISTRY_COMDEFAULT = 3;
    static final int IDS_REGISTRY_DIRECTBAUDRATE = 4;
    static final int IDS_REGISTRY_MODEMBAUDRATE = 5;
    static final int IDS_REGISTRY_MODEMINIT = 6;
    static final int IDS_MODEM_HAYES = 7;
    static final int IDS_ERRMSG_COMCONFIG = 8;
    static final int IDS_PORT_SPEED = 9;
    static final int IDS_LOGMSG_PAD_CONNECT = 10;
    static final int IDS_DIRECT_BAUD_RATE = 11;
    static final int IDS_MODEM_BAUD_RATE = 12;
    static final int IDS_ERR_SENDING_WAKEUP = 13;
    static final int IDS_DISCONN_INVALID_PORT = 14;
    static final int IDS_DISCONN_BLOCK_ACTION = 15;
    static final int IDS_ERR_PNRP_INIT = 16;
    static final int IDS_LOGMSG_TCP_CONNECT = 17;
    static final int IDS_TCP_VERIFY_HOST = 18;
    static final int IDS_TCP_CONTACT_HOST = 19;
    static final int IDS_TCP_HOST_CONNECTED = 20;
    static final int IDS_ERR_CONN_CONFIG = 21;
    static final int IDS_ERR_SOCKET = 22;
    static final int IDS_TCP_SENDING_WAKEUP = 23;
    static final int IDS_TCP_RECV_ABORT = 24;
    static final int IDS_TCP_EXCHANGE_PREFS = 25;
    static final int IDS_TCP_HANDSHAKE_COMPLETE = 26;
    static final int IDS_TCP_WAITFOR_WAKEUP = 27;
    static final int IDS_TCP_WAKEUP_RECEIVED = 28;
    static final int IDS_TCP_NOT_AVAILABLE = 29;
    public static final byte SIG_1 = -66;
    public static final byte SIG_2 = -17;
    public static final byte SIG_3 = -19;
    public static final int NUM_CRC_BYTES = 2;
    public static final int WAIT_ACK_FAST = 4;
    public static final int SEND_RETRY_FAST = 8;
    public static final int MAXRECV_TIMEOUT_FAST = 30;
    public static final int WAKEUP_RESP_SEND_RETRY = 6;
    boolean m_fModem;
    String m_csLastErrString;
    String m_csConnectString;
    byte[] m_csModemInitString;
    int m_dwUserSyncBaud;
    boolean m_fPortValid;
    public short m_padState;
    int m_nBlockingCount;
    boolean m_fTwoWayTickle;
    Timer timer;
    CMPINITPACKET m_wakeUpPacket;
    private static BufferedBytes dataBuffer = new BufferedBytes();
    private static BufferedBytes offsetBuffer = new BufferedBytes();
    byte[] m_CurrPortName = new byte[32];
    short m_CommVersion;
    int m_MaxBaudRate;
    short m_MaxFrameSize;
    PADDPACKET m_InPadd;
    PADDPACKET m_OutPadd;
    WFRAMEPACKET m_OutFrame;
    WFRAMEPACKET m_InFrame;
    short m_MaxPaddSize;
    long m_DefRecvTimeout;
    long m_MaxRecvTimeout;
    short m_FrameTimeout;
    short m_WaitForAck;
    short m_SendRetries;
    public static final int prvRecvConnTestIntervalSecs = 10;
    public static final int PAD_STATE_CONNECTED = 32768;
    public static final int PAD_STATE_LISTENNING = 16384;
    public static final int PAD_STATE_TRYING_TO_CONNECT = 8192;
    public static final int PAD_STATE_GOT_WAKEUP = 4096;
    public static final int PAD_STATE_READING_WAKEUP = 2048;
    public static final int PAD_STATE_INITIAL = 0;
    public static final int PAD_TICKLE_INTERVAL_SEC = 7000;
    public static final int PAD_MODEM_AUTO_RESET_INTERVAL_SEC = 1800;
    public static final int PAD_MODEM_ERROR_RESET_INTERVAL_SEC = 60;
    public static final int PAD_MAX_DATA_BLOCK_SIZE = 65535;
    public static final int MDM_RSP_WAIT_MILLISEC = 310;
    public static final int MDM_COMMAND_MODE_GUARD_MILLISEC = 1600;
    public static final int MDM_RESET_RSP_WAIT_MILLISEC = 3100;
    static final int prvMaxFIFOFlushMilliSec = 100;

    public CTransportPAD(boolean fModem) {
        this(fModem, SyncUtils.getMaxBaud());
    }

    public CTransportPAD(boolean fModem, int reqestedBaud) {
        super(fModem ? Integer.MIN_VALUE : 0x40000000);
        this.m_wakeUpPacket = new CMPINITPACKET();
        this.m_OutFrame = new WFRAMEPACKET();
        this.m_InFrame = new WFRAMEPACKET();
        this.m_WaitForAck = (short)5;
        this.m_SendRetries = (short)12;
        this.m_InPadd = new PADDPACKET();
        this.m_OutPadd = new PADDPACKET();
        this.m_fModem = fModem;
        this.m_dwUserSyncBaud = reqestedBaud;
        if (this.m_dwUserSyncBaud == 0) {
            this.m_dwUserSyncBaud = SyncUtils.getMaxBaud();
        }
        this.m_fPortValid = false;
        this.m_padState = 0;
        this.m_nBlockingCount = 0;
        this.m_fTwoWayTickle = false;
        this.timer = new Timer(7000, this);
        this.timer.stop();
        this.m_MaxPaddSize = (short)1024;
        this.m_MaxFrameSize = (short)(4 + this.m_MaxPaddSize);
        this.m_MaxRecvTimeout = 90L;
        this.m_DefRecvTimeout = 90L;
        this.m_FrameTimeout = (short)200;
        this.CreateFrameBuffers();
    }

    long AutoAnswerOff(boolean fReset) {
        return 0L;
    }

    long AutoAnswerOn(byte[] szInit, boolean fReset) {
        return 0L;
    }

    private long ConfigPortSpeed(int dwBaud) {
        long err = 0L;
        if (m_pSerialPort == null) {
            return 8199L;
        }
        int t = dwBaud;
        boolean fHardHand = t > 19200;
        try {
            err = m_pSerialPort.ConfigPortStats(dwBaud, (byte)8, (byte)1, (byte)0, fHardHand);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.out.println("Could not configure port to speed " + dwBaud);
        }
        if (err != 0L) {
            err = 8199L;
        } else {
            this.UtilWaitMilliSeconds(100);
        }
        return err;
    }

    public long ConnectToHost(boolean fLocalOrigin, CTransportBase.HostInfoType hostInfoP) {
        return 0L;
    }

    long CreateFrameBuffers() {
        return 0L;
    }

    void DbgFrameBuffs() {
    }

    void DbgInitFrameBuffs() {
    }

    long DestroyFrameBuffers() {
        return 0L;
    }

    public long Disconnect() {
        if (!this.m_fPortValid) {
            return 8199L;
        }
        this.timer.stop();
        if (this.m_nBlockingCount != 0) {
            return 8201L;
        }
        if (m_pSerialPort == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.m_fModem) {
            this.AutoAnswerOn(this.m_csModemInitString, false);
        } else {
            this.ConfigPortSpeed(9600);
        }
        this.m_padState = (short)(this.m_padState & 0xFFFF7FFF);
        return 0L;
    }

    public long EstablishConnection() {
        long err = 0L;
        int t = this.m_padState & 0x1000;
        if (t == 0) {
            return 8199L;
        }
        if (this.m_nBlockingCount > 0) {
            return 8201L;
        }
        t = this.m_padState & 0xFFFFEFFF;
        this.m_padState = (short)t;
        t = this.m_padState | 0x2000;
        this.m_padState = (short)t;
        int dwBaud = this.m_dwUserSyncBaud == 0 ? SyncUtils.getMaxBaud() : this.m_dwUserSyncBaud;
        boolean dwVersion = false;
        int dwMaxPcBaud = SyncUtils.getMaxBaud();
        dwBaud = Math.min(dwMaxPcBaud, Math.min(dwBaud, this.m_wakeUpPacket.m_BaudRate));
        err = this.SendWakeUpResp(dwBaud, false, true);
        if (err == 0L) {
            this.ConfigPortSpeed(dwBaud);
        }
        t = this.m_padState & 0xFFFFDFFF;
        this.m_padState = (short)t;
        if (err == 0L) {
            t = this.m_padState | 0x8000;
            this.m_padState = (short)t;
            this.timer.start();
            if (this.m_wakeUpPacket.m_bVerMajor == 1 && this.m_wakeUpPacket.m_bVerMinor >= 1) {
                this.m_WaitForAck = (short)4;
                this.m_SendRetries = (short)8;
                this.m_DefRecvTimeout = 30L;
                this.m_fTwoWayTickle = true;
            } else {
                this.m_WaitForAck = (short)5;
                this.m_SendRetries = (short)12;
                this.m_DefRecvTimeout = 90L;
                this.m_fTwoWayTickle = false;
            }
            this.m_MaxRecvTimeout = this.m_DefRecvTimeout;
        } else {
            this.Disconnect();
        }
        return err;
    }

    public long MakePlatformSerialPort(String pPortName) {
        long err = CommPortConst.serErrNoError;
        if (m_pSerialPort != null) {
            err = m_pSerialPort.ClosePort();
            m_pSerialPort = null;
        }
        if ((m_pSerialPort = new SerialPortCommunicator(pPortName)) != null) {
            try {
                err = m_pSerialPort.OpenPort();
            }
            catch (PortInUseException e) {
                Logger.doLogging((String)e.toString(), (boolean)true);
                err = 8199L;
                return err;
            }
            if (err != CommPortConst.serErrNoError) {
                m_pSerialPort = null;
            }
        }
        if (m_pSerialPort == null || err != CommPortConst.serErrNoError) {
            err = 8199L;
        }
        this.m_fPortValid = true;
        return err;
    }

    public int MaxBlockSize() {
        int t = 65535;
        return t;
    }

    public long PollConnection() {
        long err = 8197L;
        if ((this.m_padState & 0x4000) == 0) {
            return 8199L;
        }
        if (this.m_nBlockingCount != 0) {
            return 8201L;
        }
        this.m_padState = (short)(this.m_padState & 0xFFFFEFFF);
        try {
            if (m_pSerialPort.ReadBytePresent()) {
                this.m_WaitForAck = (short)5;
                this.m_SendRetries = (short)6;
                this.m_MaxRecvTimeout = 90L;
                this.m_DefRecvTimeout = 90L;
                this.m_fTwoWayTickle = false;
                this.m_padState = (short)(this.m_padState | 0x2800);
                err = this.RecvWakeUp(this.m_wakeUpPacket);
                if (err != 0L) {
                    err = 8197L;
                } else {
                    this.m_padState = (short)(this.m_padState | 0x1000);
                }
                this.m_padState = (short)(this.m_padState & 0xFFFFD7FF);
            }
        }
        catch (IOException iOException) {}
        return err;
    }

    long ReadFramePacket(WFRAMEPACKET pFrame, short tOut) {
        long[] actual = new long[]{0L};
        short oldCrc = 0;
        short crc = 0;
        short toRead = 0;
        long err = 0L;
        if ((this.m_padState & 0xA000) == 0) {
            return 8197L;
        }
        ++this.m_nBlockingCount;
        long miliTime = tOut / 100;
        long diffTime = 0L;
        long startTime = System.currentTimeMillis();
        boolean secondStage = false;
        boolean firstStage = false;
        byte[] buff = new byte[1];
        while (err == 0L) {
            secondStage = false;
            firstStage = false;
            while (true) {
                if (!secondStage && !firstStage && diffTime >= miliTime) {
                    err = 8193L;
                    break;
                }
                err = m_pSerialPort.ReadSingleByte(buff);
                byte singleByte = buff[0];
                if (err == 0L) {
                    if (secondStage && singleByte == -19) break;
                    if (firstStage && singleByte == -17) {
                        secondStage = true;
                        firstStage = false;
                    } else if (singleByte == -66) {
                        firstStage = true;
                        secondStage = false;
                    } else {
                        secondStage = false;
                        firstStage = false;
                        this.UtilBlockingHook();
                    }
                } else {
                    secondStage = false;
                    firstStage = false;
                    this.UtilBlockingHook();
                }
                long stopTime = System.currentTimeMillis();
                diffTime = (stopTime - startTime) / 1000L;
            }
            this.UtilBlockingHook();
            if (err != 0L) {
                err = 8193L;
                break;
            }
            pFrame.m_Signature[0] = -66;
            pFrame.m_Signature[1] = -17;
            pFrame.m_Signature[2] = -19;
            toRead = (short)(10 - pFrame.m_Signature.length);
            byte[] tmpPtr = new byte[toRead & 0xFFFF];
            err = m_pSerialPort.ReadBytes(tmpPtr, (long)toRead, actual);
            if (err != 0L || actual[0] != (long)toRead) {
                err = 0L;
                continue;
            }
            dataBuffer.setBuffer(new byte[10]);
            pFrame.setObjAt(dataBuffer);
            dataBuffer.setIndex(pFrame.m_Signature.length);
            dataBuffer.copyBytes(tmpPtr);
            dataBuffer.setIndex(0);
            pFrame.getObjAt(dataBuffer);
            int ckSumLen = 9;
            dataBuffer.setIndex(0);
            byte recvCkSum = this.calcChecksum8(dataBuffer, ckSumLen);
            if (recvCkSum != pFrame.m_Checksum) continue;
            actual[0] = 0L;
            toRead = SyncUtils.dtPilotToHostWord((short)pFrame.m_DataSize);
            if (toRead > this.m_MaxFrameSize) continue;
            pFrame.m_Data = new byte[(toRead & 0xFFFF) + 2];
            err = m_pSerialPort.ReadBytes(pFrame.m_Data, (long)(toRead + 2), actual);
            if (err != 0L || actual[0] != (long)(toRead + 2)) {
                err = 0L;
                continue;
            }
            dataBuffer.setBuffer(pFrame.m_Data);
            dataBuffer.setIndex((int)pFrame.m_DataSize);
            oldCrc = dataBuffer.getShort();
            short crcLen = (short)(10 + pFrame.m_DataSize);
            dataBuffer.setBuffer(new byte[10 + (pFrame.m_DataSize & 0xFFFF) + 2]);
            pFrame.setObjAt(dataBuffer);
            dataBuffer.setIndex(0);
            crc = this.calcCrc16(dataBuffer, crcLen, 0);
            oldCrc = SyncUtils.dtPilotToHostWord((short)oldCrc);
            if (oldCrc != crc || pFrame.m_Type != 2) continue;
            pFrame.m_DataSize = toRead;
            if (dataBuffer.getByte(0) == 8) {
                this.m_padState = (short)(this.m_padState & 0xFFFF7FFF);
                err = 8197L;
                break;
            }
            err = 0L;
            break;
        }
        --this.m_nBlockingCount;
        return err;
    }

    long ReceivePaddAck(byte[] rInDest, byte[] rInTransId, PADDPACKET paddIn) {
        long err = this.ReadFramePacket(this.m_InFrame, this.m_FrameTimeout);
        if (err == 0L) {
            rInDest[0] = this.m_InFrame.m_Destination;
            rInTransId[0] = this.m_InFrame.m_TransId;
            dataBuffer.setBuffer(this.m_InFrame.m_Data);
            paddIn.getObjAt(dataBuffer);
            paddIn.m_DataSize = SyncUtils.dtPilotToHostWord((short)paddIn.m_DataSize);
        }
        return err;
    }

    long ReceiveSinglePadd(byte[] rInDest, byte[] rInTransId, PADDPACKET paddIn, int[] rDataSize) {
        long err = 0L;
        GregorianCalendar currCal = new GregorianCalendar();
        GregorianCalendar startCal = new GregorianCalendar();
        boolean bDataFound = false;
        long diffSecs = 0L;
        long lastConnTestSecs = 0L;
        ++this.m_nBlockingCount;
        long startTime = System.currentTimeMillis();
        while (true) {
            if ((err = this.ReadFramePacket(this.m_InFrame, this.m_FrameTimeout)) == 0L) {
                if (this.m_InFrame.m_Type == 2) {
                    rInDest[0] = this.m_InFrame.m_Destination;
                    rInTransId[0] = this.m_InFrame.m_TransId;
                    dataBuffer.setBuffer(this.m_InFrame.m_Data);
                    paddIn.getObjAt(dataBuffer);
                    rDataSize[0] = this.m_InFrame.m_DataSize - 4;
                    paddIn.m_DataSize = SyncUtils.dtPilotToHostWord((short)paddIn.m_DataSize);
                    if (paddIn.m_Data == null || paddIn.m_Data.length < paddIn.m_DataSize) {
                        paddIn.m_Data = new byte[paddIn.m_DataSize & 0xFFFF];
                        try {
                            int i = 0;
                            while (i < (paddIn.m_DataSize & 0xFFFF)) {
                                paddIn.m_Data[i] = this.m_InFrame.m_Data[4 + i];
                                ++i;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    }
                    if (paddIn.m_Type == 1) {
                        this.SendSimplePadd((byte)2, rInTransId[0], paddIn.m_Flags, paddIn.m_DataSize);
                        bDataFound = true;
                        break;
                    }
                    if (paddIn.m_Type == 4) {
                        startTime = System.currentTimeMillis();
                    }
                }
            } else if ((this.m_padState & 0x800) > 0) break;
            if (err == 8197L) break;
            this.UtilBlockingHook();
            diffSecs = (System.currentTimeMillis() - startTime) / 1000L;
            if (diffSecs >= this.m_MaxRecvTimeout) break;
            if ((this.m_padState & 0x800) != 0 || diffSecs - lastConnTestSecs < 10L) continue;
            lastConnTestSecs = diffSecs;
            err = this.SendPaddTickle();
            if (err == 8197L) break;
        }
        if (bDataFound) {
            err = 0L;
        } else {
            this.m_padState = (short)(this.m_padState & 0xFFFF7FFF);
            err = 8197L;
        }
        --this.m_nBlockingCount;
        return err;
    }

    public long ReceiveTransactionResp(BufferedBytes lpResp, int[] rRespSize, byte[] rMatchTransId) {
        long err = 0L;
        byte[] InDest = new byte[1];
        byte[] InTransId = new byte[1];
        boolean bAllPaddsIn = false;
        boolean bMultiPacks = false;
        boolean bValidSequence = false;
        int[] wPaddDSize = new int[1];
        int dwTotal = 0;
        int lastOffset = 0;
        rRespSize[0] = 0;
        long nTOutOverride = this.SetRecvTOutOverride(0L);
        this.m_MaxRecvTimeout = nTOutOverride > this.m_DefRecvTimeout ? nTOutOverride : this.m_DefRecvTimeout;
        while (!bAllPaddsIn && err == 0L) {
            int sizeToCopy = 0;
            offsetBuffer.setBuffer(null);
            err = this.ReceiveSinglePadd(InDest, InTransId, this.m_InPadd, wPaddDSize);
            if (err != 0L || InTransId[0] != rMatchTransId[0] && (dwTotal != 0 || rMatchTransId[0] != 0)) continue;
            if (bMultiPacks && (this.m_InPadd.m_Flags & 0xFFFFFF80) == 0) {
                bValidSequence = (this.m_InPadd.m_DataSize & 0xFFFF) == lastOffset;
            }
            if ((this.m_InPadd.m_Flags & 0xFFFFFF80) != 0 && lastOffset == 0) {
                if (lpResp.bytes == null) {
                    dwTotal = this.m_InPadd.m_DataSize & 0xFFFF;
                    rMatchTransId[0] = InTransId[0];
                    bValidSequence = true;
                    lpResp.setBuffer(this.UtilGetRcvBuf(dwTotal));
                    if (lpResp.bytes != null) {
                        offsetBuffer.setBuffer(lpResp.bytes);
                    }
                }
                if ((this.m_InPadd.m_Flags & 0x40) == 0 || dwTotal > this.m_MaxPaddSize) {
                    bMultiPacks = true;
                }
            } else if (lpResp.bytes != null && bValidSequence) {
                offsetBuffer.setBuffer(lpResp.bytes);
                offsetBuffer.setIndex(lastOffset);
            }
            if ((sizeToCopy = wPaddDSize[0]) > this.m_MaxPaddSize) {
                sizeToCopy = this.m_MaxPaddSize;
            }
            if (rRespSize[0] + sizeToCopy > dwTotal) {
                sizeToCopy = dwTotal - rRespSize[0];
            }
            if (!bValidSequence) continue;
            if (CTransportPAD.offsetBuffer.bytes != null && sizeToCopy > 0) {
                offsetBuffer.copyBytes(this.m_InPadd.m_Data, sizeToCopy);
            }
            rRespSize[0] = rRespSize[0] + sizeToCopy;
            lastOffset += sizeToCopy;
            if ((this.m_InPadd.m_Flags & 0x40) == 0 && rRespSize[0] < dwTotal) continue;
            bAllPaddsIn = true;
        }
        if (err != 0L && lpResp.bytes != null) {
            lpResp.bytes = null;
            rRespSize[0] = 0;
        } else if (err == 0L && lpResp == null) {
            err = 8194L;
            rRespSize[0] = 0;
        }
        return err;
    }

    public long RecvDataBlock(short[] pwTID, BufferedBytes ppData, int[] pdwSize) {
        long err = -1L;
        byte[] bTID = new byte[1];
        BufferedBytes lpResp = new BufferedBytes(new byte[1]);
        int[] dwSize = new int[1];
        this.timer.stop();
        if (this.m_nBlockingCount != 0) {
            err = 8201L;
        } else {
            bTID[0] = 0;
            dwSize[0] = 0;
            lpResp = null;
            err = this.ReceiveTransactionResp(lpResp, dwSize, bTID);
            pwTID[0] = bTID[0];
            ppData.setBuffer(lpResp.bytes);
        }
        this.timer.start();
        return err;
    }

    long RecvWakeUp(CMPINITPACKET pWakeUp) {
        byte[] inDest = new byte[1];
        byte[] inSeqNum = new byte[1];
        int[] wPaddSize = new int[1];
        long err = this.ReceiveSinglePadd(inDest, inSeqNum, this.m_InPadd, wPaddSize);
        if (err == 0L) {
            err = 8197L;
            if (this.m_InPadd.m_DataSize == 10) {
                dataBuffer.setBuffer(this.m_InPadd.m_Data);
                pWakeUp.getObjAt(dataBuffer);
                if (pWakeUp.m_Type == 1) {
                    pWakeUp.m_BaudRate = SyncUtils.dtPilotToHostDWord((int)pWakeUp.m_BaudRate);
                    err = 0L;
                }
            }
        }
        return err;
    }

    public long Reset() {
        long err = 0L;
        if (this.m_nBlockingCount != 0) {
            return 8201L;
        }
        this.m_fPortValid = false;
        if (this.m_fModem && this.m_dwUserSyncBaud == 0) {
            this.m_dwUserSyncBaud = SyncUtils.getMaxBaud();
        }
        this.m_fPortValid = true;
        err = 0L;
        return err;
    }

    public long SendCommand(byte[] pCmd, int dwCmdSize, BufferedBytes ppRsp, int[] pdwRspSize) {
        long err;
        byte[] bTID = new byte[1];
        BufferedBytes lpResp = new BufferedBytes();
        int[] dwSize = new int[1];
        if (dwCmdSize > 65535) {
            return 8202L;
        }
        this.timer.stop();
        if (this.m_nBlockingCount != 0) {
            err = 8201L;
        } else {
            bTID[0] = this.UtilNewTransId();
            dwSize[0] = 0;
            byte t = 3;
            short s = (short)dwCmdSize;
            err = this.SendTransaction(t, pCmd, s, bTID[0]);
            if (err == 0L) {
                err = this.ReceiveTransactionResp(lpResp, dwSize, bTID);
            }
            ppRsp.bytes = lpResp.bytes;
            pdwRspSize[0] = dwSize[0];
        }
        this.timer.start();
        return err;
    }

    public long SendDataBlock(short wTID, BufferedBytes pData, int dwSize) {
        long err = -1L;
        if (dwSize > 65535) {
            return 8202L;
        }
        this.timer.stop();
        if (this.m_nBlockingCount != 0) {
            err = 8201L;
        } else {
            byte t = 3;
            short s = (short)dwSize;
            byte r = (byte)wTID;
            err = this.SendTransaction(t, pData.bytes, s, r);
        }
        this.timer.start();
        return err;
    }

    private long SendPaddTickle() {
        byte t = 0;
        short s = 0;
        long err = this.SendSimplePadd((byte)4, this.m_LastTransId, t, s);
        return err;
    }

    private long SendSimplePadd(byte paddType, byte TransId, byte flags, short size) {
        long err = 0L;
        this.m_OutFrame.m_Destination = (byte)3;
        this.m_OutFrame.m_Source = (byte)3;
        this.m_OutFrame.m_DataSize = (short)4;
        this.m_OutFrame.m_TransId = TransId;
        PADDPACKET pPadd = new PADDPACKET();
        pPadd.m_Type = paddType;
        pPadd.m_Flags = flags;
        pPadd.m_DataSize = SyncUtils.dtHostToPilotWord((short)size);
        if (this.m_OutFrame.m_Data == null || this.m_OutFrame.m_Data.length < 4) {
            this.m_OutFrame.m_Data = new byte[4];
        }
        dataBuffer.setBuffer(this.m_OutFrame.m_Data);
        pPadd.setObjAt(dataBuffer);
        err = this.WriteFramePacket(this.m_OutFrame);
        return err;
    }

    private long SendSinglePadd(byte dest, PADDPACKET paddOut, short paddDataSize, byte TransId) {
        long err = 0L;
        byte[] inSeqNum = new byte[1];
        byte[] inDest = new byte[1];
        long startTime = 0L;
        GregorianCalendar currCal = new GregorianCalendar();
        GregorianCalendar startCal = new GregorianCalendar();
        double diffSecs = 0.0;
        boolean beenAcked = false;
        PADDPACKET paddInHdr = new PADDPACKET();
        ++this.m_nBlockingCount;
        this.m_OutFrame.m_DataSize = (short)(4 + paddDataSize);
        this.m_OutFrame.m_Destination = dest;
        this.m_OutFrame.m_Source = (byte)3;
        this.m_OutFrame.m_TransId = TransId;
        this.m_OutFrame.m_Data = new byte[4 + (paddDataSize & 0xFFFF)];
        dataBuffer.setBuffer(this.m_OutFrame.m_Data);
        paddOut.setObjAt(dataBuffer);
        int retries = this.m_SendRetries;
        diffSecs = this.m_WaitForAck + 1;
        while (retries > 0) {
            if (diffSecs >= (double)this.m_WaitForAck) {
                this.m_OutFrame.m_DataSize = (short)(4 + paddDataSize);
                --retries;
                err = this.WriteFramePacket(this.m_OutFrame);
                if (err == 8197L) break;
                startTime = System.currentTimeMillis();
            }
            this.UtilBlockingHook();
            err = this.ReceivePaddAck(inDest, inSeqNum, paddInHdr);
            if (err == 0L) {
                if (inSeqNum[0] == TransId) {
                    if (paddInHdr.m_Type == 2 && paddInHdr.m_DataSize == paddOut.m_DataSize) {
                        beenAcked = true;
                        if ((paddInHdr.m_Flags & 0x20) == 0) break;
                        Logger.doDebugLogging((String)"SendSinglePadd(S) RecvAck() ERROR = MEMORY", (int)2, (boolean)true);
                        err = 8195L;
                        break;
                    }
                    if (paddInHdr.m_Type == 1) {
                        beenAcked = true;
                        break;
                    }
                    if (paddInHdr.m_Type == 4) {
                        startTime = System.currentTimeMillis();
                    }
                }
            } else if (err == 8197L) break;
            diffSecs = (System.currentTimeMillis() - startTime) / 1000L;
        }
        if (!beenAcked && err != 8197L) {
            if ((paddOut.m_Flags & 0x40) != 0 && !this.m_fTwoWayTickle) {
                err = 0L;
            } else {
                this.m_padState = (short)(this.m_padState & 0xFFFF7FFF);
                err = 8197L;
            }
        }
        --this.m_nBlockingCount;
        return err;
    }

    long SendToModem(byte[] pszCmd) {
        return 0L;
    }

    public long SendTransaction(byte dest, byte[] pData, short dSize, byte tid) {
        long err = 0L;
        int nTotalBytes = 0;
        short sizeToSend = 0;
        int nBytesSent = 0;
        this.m_OutPadd.m_Flags = (byte)-64;
        this.m_OutPadd.m_Type = 1;
        nBytesSent = 0;
        nTotalBytes = dSize & 0xFFFF;
        while (nBytesSent < nTotalBytes) {
            byte t;
            if (nTotalBytes - nBytesSent > this.m_MaxPaddSize) {
                sizeToSend = this.m_MaxPaddSize;
                this.m_OutPadd.m_Flags = t = (byte)(this.m_OutPadd.m_Flags & 0xFFFFFFBF);
            } else {
                sizeToSend = (short)(nTotalBytes - nBytesSent);
                if (nBytesSent > 0) {
                    this.m_OutPadd.m_Flags = (byte)64;
                }
            }
            t = (byte)(this.m_OutPadd.m_Flags & 0xFFFFFF80);
            this.m_OutPadd.m_DataSize = t != 0 ? SyncUtils.dtHostToPilotWord((short)((short)nTotalBytes)) : SyncUtils.dtHostToPilotWord((short)((short)nBytesSent));
            if (this.m_OutPadd.m_Data == null || this.m_OutPadd.m_Data.length < sizeToSend) {
                this.m_OutPadd.m_Data = new byte[sizeToSend & 0xFFFF];
            }
            dataBuffer.setBuffer(this.m_OutPadd.m_Data);
            dataBuffer.copyBytesStartAt(pData, nBytesSent);
            err = this.SendSinglePadd(dest, this.m_OutPadd, sizeToSend, tid);
            if (err != 0L) {
                Logger.doDebugLogging((String)("SendTransaction() SendSinglePadd ERROR " + err), (int)2, (boolean)true);
                break;
            }
            nBytesSent += sizeToSend;
            this.m_OutPadd.m_Type = 1;
            this.m_OutPadd.m_Flags = 0;
        }
        return err;
    }

    private long SendWakeUpResp(int dwBaud, boolean bAcceptBaud, boolean bAcceptVer) {
        CMPINITPACKET WakeUpResp = new CMPINITPACKET();
        long err = 0L;
        WakeUpResp.m_Type = (byte)3;
        WakeUpResp.m_Flags = (byte)-128;
        WakeUpResp.m_bVerMajor = 1;
        WakeUpResp.m_bVerMinor = 1;
        if (bAcceptVer) {
            if (!bAcceptBaud && dwBaud > 0) {
                WakeUpResp.m_Type = (byte)2;
                WakeUpResp.m_Flags = (byte)-128;
                WakeUpResp.m_BaudRate = SyncUtils.dtHostToPilotDWord((int)dwBaud);
            } else if (bAcceptBaud) {
                WakeUpResp.m_Type = (byte)2;
                WakeUpResp.m_Flags = 0;
            }
        }
        dataBuffer.setBuffer(new byte[10]);
        WakeUpResp.setObjAt(dataBuffer);
        err = this.SendTransaction((byte)3, CTransportPAD.dataBuffer.bytes, (short)10, this.UtilNewTransId());
        return err;
    }

    public long SetRecvTOutOverride(long nSec) {
        long nOldValue = 0L;
        nOldValue = this.m_nRecvTOutOverrideSec;
        this.m_nRecvTOutOverrideSec = nSec;
        return nOldValue;
    }

    public void SetUserSyncBaud(int userSyncBaud) {
        this.m_dwUserSyncBaud = userSyncBaud;
        if (this.m_dwUserSyncBaud == 0) {
            this.m_dwUserSyncBaud = SyncUtils.getMaxBaud();
        }
    }

    public long StartListen() {
        long err = 0L;
        int t = 0xA000 & this.m_padState;
        if (t != 0 || !this.m_fPortValid) {
            return 8199L;
        }
        if (this.m_nBlockingCount != 0) {
            return 8201L;
        }
        this.m_padState = (short)(this.m_padState | 0x4000);
        if (this.m_fModem && (err = this.ConfigPortSpeed(this.m_dwUserSyncBaud)) != 0L) {
            err = this.AutoAnswerOn(this.m_csModemInitString, true);
        }
        return err;
    }

    public long StopListen() {
        int t = this.m_padState & 0x4000;
        if (t == 0) {
            return 8199L;
        }
        if (this.m_fModem) {
            this.AutoAnswerOff(false);
        }
        t = this.m_padState & 0xFFFFBFFF;
        this.m_padState = (short)t;
        return 0L;
    }

    void TickleTimer() {
        int t = this.m_padState & 0x8000;
        this.m_padState = (short)t;
        if (t == 0 || this.m_nBlockingCount != 0) {
            return;
        }
        this.SendPaddTickle();
    }

    long WaitForModemResponse(int dwWaitMilliSec) {
        return 0L;
    }

    private long WriteFramePacket(WFRAMEPACKET pFrame) {
        byte checkSum;
        long err = 0L;
        if ((this.m_padState & 0xA000) == 0) {
            return 8197L;
        }
        ++this.m_nBlockingCount;
        pFrame.m_Type = (byte)2;
        pFrame.m_Signature[0] = -66;
        pFrame.m_Signature[1] = -17;
        pFrame.m_Signature[2] = -19;
        int shipSize = pFrame.m_DataSize + 10;
        pFrame.m_DataSize = SyncUtils.dtHostToPilotWord((short)pFrame.m_DataSize);
        int ckSumLen = 9;
        byte[] buff = new byte[1200];
        dataBuffer.setBuffer(buff);
        pFrame.setObjAt(dataBuffer);
        dataBuffer.setIndex(0);
        pFrame.m_Checksum = checkSum = this.calcChecksum8(dataBuffer, ckSumLen);
        dataBuffer.setByte(9, pFrame.m_Checksum);
        short crc = this.calcCrc16(dataBuffer, shipSize, 0);
        dataBuffer.setIndex(10 + pFrame.m_DataSize);
        dataBuffer.copyShortBytes(crc);
        long[] numWritten = new long[]{0L};
        err = m_pSerialPort.WriteBytes(CTransportPAD.dataBuffer.bytes, (long)(shipSize + 2), numWritten);
        if (numWritten[0] == (long)(shipSize + 2)) {
            err = 0L;
        }
        if (err == CommPortConst.serErrSendTimedOut) {
            this.m_padState = (short)(this.m_padState & 0xFFFF7FFF);
            err = 8197L;
        } else {
            err = 0L;
        }
        --this.m_nBlockingCount;
        return err;
    }

    public void actionPerformed(ActionEvent e) {
        this.TickleTimer();
    }

    public SerialPortCommunicator getSerialPort() {
        return m_pSerialPort;
    }

    public void stopTheTimer() {
        this.timer.stop();
    }
}

