/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.rmic2;

import com.sun.management.viperimpl.rmic2.Main;
import com.sun.management.viperimpl.rmic2.Names;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.RemoteClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class Generator
implements Constants {
    private BatchEnvironment env;
    private RemoteClass remoteClass;
    private int version;
    private RemoteClass.Method[] remoteMethods;
    private Identifier remoteClassName;
    private Identifier agentClassName;
    private Identifier containerClassName;
    private Identifier interfaceClassName;
    private String[] methodFieldNames;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;
    private ClassDefinition defRuntimeException;

    private Generator(BatchEnvironment batchEnvironment, RemoteClass remoteClass, int n) throws ClassNotFound {
        this.env = batchEnvironment;
        this.remoteClass = remoteClass;
        this.version = n;
        this.remoteMethods = remoteClass.getRemoteMethods();
        this.remoteClassName = remoteClass.getName();
        this.agentClassName = Names.agentFor(this.remoteClassName);
        this.containerClassName = Names.containerFor(this.remoteClassName);
        this.interfaceClassName = Names.interfaceFor(this.remoteClassName);
        this.methodFieldNames = Generator.nameMethodFields(this.remoteMethods);
        this.defException = batchEnvironment.getClassDeclaration(sun.tools.java.Constants.idJavaLangException).getClassDefinition((Environment)batchEnvironment);
        this.defRemoteException = batchEnvironment.getClassDeclaration(Constants.idRemoteException).getClassDefinition((Environment)batchEnvironment);
        this.defRuntimeException = batchEnvironment.getClassDeclaration(sun.tools.java.Constants.idJavaLangRuntimeException).getClassDefinition((Environment)batchEnvironment);
    }

    private String formatMethod(String string) {
        int n = string.indexOf(40);
        int n2 = string.substring(0, n).lastIndexOf(32);
        return String.valueOf(String.valueOf(this.remoteClassName.getTopName())) + "." + string.substring(n2 + 1);
    }

    public static void generate(BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file, int n) {
        IndentingWriter indentingWriter;
        IndentingWriter indentingWriter2;
        Generator generator;
        RemoteClass remoteClass = RemoteClass.forClass((BatchEnvironment)batchEnvironment, (ClassDefinition)classDefinition);
        if (remoteClass == null) {
            return;
        }
        try {
            generator = new Generator(batchEnvironment, remoteClass, n);
        }
        catch (ClassNotFound classNotFound) {
            batchEnvironment.error(0L, "rmic.class.not.found", (Object)classNotFound.name);
            return;
        }
        Identifier identifier = Names.agentFor(classDefinition.getName());
        File file2 = Generator.getFileForClass(identifier, file, ".java");
        batchEnvironment.addGeneratedFile(file2);
        try {
            indentingWriter2 = new IndentingWriter((Writer)new OutputStreamWriter(new FileOutputStream(file2)));
            generator.writeAgent(indentingWriter2);
            indentingWriter2.close();
            if (batchEnvironment.verbose()) {
                batchEnvironment.output(Main.getText("rmic.wrote", file2.getPath()));
            }
            batchEnvironment.parseFile(new ClassFile(file2));
        }
        catch (IOException iOException) {
            batchEnvironment.error(0L, "cant.write", (Object)file2.toString());
            return;
        }
        indentingWriter2 = Names.interfaceFor(classDefinition.getName());
        File file3 = Generator.getFileForClass((Identifier)indentingWriter2, file, ".java");
        batchEnvironment.addGeneratedFile(file3);
        try {
            indentingWriter = new IndentingWriter((Writer)new OutputStreamWriter(new FileOutputStream(file3)));
            generator.writeInterface(indentingWriter);
            indentingWriter.close();
            if (batchEnvironment.verbose()) {
                batchEnvironment.output(Main.getText("rmic.wrote", file3.getPath()));
            }
            batchEnvironment.parseFile(new ClassFile(file3));
        }
        catch (IOException iOException) {
            batchEnvironment.error(0L, "cant.write", (Object)file3.toString());
            return;
        }
        indentingWriter = Names.containerFor(classDefinition.getName());
        File file4 = Generator.getFileForClass((Identifier)indentingWriter, file, ".java");
        if (n == 1 || n == 2) {
            batchEnvironment.addGeneratedFile(file4);
            try {
                IndentingWriter indentingWriter3 = new IndentingWriter((Writer)new OutputStreamWriter(new FileOutputStream(file4)));
                generator.writeContainer(indentingWriter3);
                indentingWriter3.close();
                if (batchEnvironment.verbose()) {
                    batchEnvironment.output(Main.getText("rmic.wrote", file4.getPath()));
                }
                batchEnvironment.parseFile(new ClassFile(file4));
            }
            catch (IOException iOException) {
                batchEnvironment.error(0L, "cant.write", (Object)file4.toString());
                return;
            }
        } else {
            File file5 = Generator.getFileForClass((Identifier)indentingWriter, file, ".class");
            file4.delete();
            file5.delete();
        }
    }

    private static String generateNameFromType(Type type) {
        int n = type.getTypeCode();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return type.toString();
            }
            case 9: {
                return "arrayOf_" + Generator.generateNameFromType(type.getElementType());
            }
            case 10: {
                return Names.mangleClass(type.getClassName().getName()).toString();
            }
        }
        throw new Error("unexpected type code: " + n);
    }

    private static File getFileForClass(Identifier identifier, File file, String string) {
        Identifier identifier2 = Names.mangleClass(identifier);
        String string2 = identifier2.getQualifier().toString().replace('.', File.separatorChar);
        String string3 = String.valueOf(String.valueOf(identifier2.getName())) + string;
        if (file != null) {
            File file2 = new File(file, string2);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            return new File(file2, string3);
        }
        return new File(System.getProperty("user.dir"), string3);
    }

    private static String[] nameMethodFields(RemoteClass.Method[] methodArray) {
        String[] stringArray = new String[methodArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = "$method_" + methodArray[n].getName() + "_" + n;
            ++n;
        }
        return stringArray;
    }

    private static String[] nameParameters(Type[] typeArray) {
        String[] stringArray = new String[typeArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = "$param_" + Generator.generateNameFromType(typeArray[n]) + "_" + (n + 1);
            ++n;
        }
        return stringArray;
    }

    private static String unwrapArgumentCode(Type type, String string) {
        int n = type.getTypeCode();
        switch (n) {
            case 0: {
                return "((java.lang.Boolean) " + string + ").booleanValue()";
            }
            case 1: {
                return "((java.lang.Byte) " + string + ").byteValue()";
            }
            case 2: {
                return "((java.lang.Character) " + string + ").charValue()";
            }
            case 3: {
                return "((java.lang.Short) " + string + ").shortValue()";
            }
            case 4: {
                return "((java.lang.Integer) " + string + ").intValue()";
            }
            case 5: {
                return "((java.lang.Long) " + string + ").longValue()";
            }
            case 6: {
                return "((java.lang.Float) " + string + ").floatValue()";
            }
            case 7: {
                return "((java.lang.Double) " + string + ").doubleValue()";
            }
            case 9: 
            case 10: {
                return "((" + type + ") " + string + ")";
            }
        }
        throw new Error("unexpected type code: " + n);
    }

    private static String wrapArgumentCode(Type type, String string) {
        int n = type.getTypeCode();
        switch (n) {
            case 0: {
                return "new java.lang.Boolean(" + string + ")";
            }
            case 1: {
                return "new java.lang.Byte(" + string + ")";
            }
            case 2: {
                return "new java.lang.Character(" + string + ")";
            }
            case 3: {
                return "new java.lang.Short(" + string + ")";
            }
            case 4: {
                return "new java.lang.Integer(" + string + ")";
            }
            case 5: {
                return "new java.lang.Long(" + string + ")";
            }
            case 6: {
                return "new java.lang.Float(" + string + ")";
            }
            case 7: {
                return "new java.lang.Double(" + string + ")";
            }
            case 9: 
            case 10: {
                return string;
            }
        }
        throw new Error("unexpected type code: " + n);
    }

    private void writeAgent(IndentingWriter indentingWriter) throws IOException {
        int n;
        indentingWriter.pln("// Agent class generated by viper rmic1.2, do not edit.");
        indentingWriter.pln();
        if (this.remoteClassName.isQualified()) {
            indentingWriter.pln("package " + this.remoteClassName.getQualifier() + ";");
            indentingWriter.pln();
        }
        indentingWriter.plnI("public final class " + Names.mangleClass(this.agentClassName.getName()));
        indentingWriter.pln("extends com.sun.management.viperimpl.ServiceAgent");
        ClassDefinition[] classDefinitionArray = this.remoteClass.getRemoteInterfaces();
        if (classDefinitionArray.length > 0) {
            indentingWriter.p("implements ");
            n = 0;
            while (n < classDefinitionArray.length) {
                if (n > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(classDefinitionArray[n].getName().toString());
                ++n;
            }
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("{");
        this.writeAgentConstructors(indentingWriter);
        indentingWriter.pln();
        if (this.remoteMethods.length > 0) {
            indentingWriter.pln("// methods from remote interfaces");
            n = 0;
            while (n < this.remoteMethods.length) {
                indentingWriter.pln();
                this.writeAgentMethod(indentingWriter, n);
                ++n;
            }
        }
        indentingWriter.pOln("}");
    }

    private void writeAgentConstructors(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("// constructors");
        indentingWriter.plnI("public " + Names.mangleClass(this.agentClassName.getName()) + "() {");
        indentingWriter.pln("super();");
        indentingWriter.pOln("}");
    }

    private void writeAgentMethod(IndentingWriter indentingWriter, int n) throws IOException {
        int n2;
        int n3;
        RemoteClass.Method method = this.remoteMethods[n];
        Identifier identifier = method.getName();
        Type type = method.getType();
        Type[] typeArray = type.getArgumentTypes();
        String[] stringArray = Generator.nameParameters(typeArray);
        Type type2 = type.getReturnType();
        ClassDeclaration[] classDeclarationArray = method.getExceptions();
        indentingWriter.pln("// attach security token to " + type.typeString(identifier.toString(), true, false));
        indentingWriter.p("public " + type2 + " " + identifier + "(");
        int n4 = 0;
        while (n4 < typeArray.length) {
            if (n4 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(String.valueOf(String.valueOf(typeArray[n4])) + " " + stringArray[n4]);
            ++n4;
        }
        indentingWriter.plnI(")");
        boolean bl = true;
        String[] stringArray2 = new String[]{"java.lang.Exception", "com.sun.management.viper.VException", "com.sun.management.viper.services.AuthenticationException", "com.sun.management.viper.services.AuthenticationMessageException"};
        if (classDeclarationArray.length > 0) {
            indentingWriter.p("throws ");
            n3 = 0;
            while (n3 < classDeclarationArray.length) {
                if (n3 > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(classDeclarationArray[n3].getName().toString());
                n2 = 0;
                while (n2 < stringArray2.length) {
                    if (classDeclarationArray[n3].getName().toString().equals(stringArray2[n2])) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                ++n3;
            }
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("{");
        if (bl) {
            indentingWriter.plnI("try {");
        }
        indentingWriter.p("Object [] paramArray = { ");
        n3 = 0;
        while (n3 < typeArray.length) {
            if (n3 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(Generator.wrapArgumentCode(typeArray[n3], stringArray[n3]));
            ++n3;
        }
        indentingWriter.pln(" };");
        if (!type2.isType(11)) {
            indentingWriter.p("return ");
        }
        indentingWriter.p("((" + Names.mangleClass(this.interfaceClassName.getName()) + ")containerStub)." + identifier + "(getMessageToken(paramArray)");
        n2 = 0;
        while (n2 < typeArray.length) {
            indentingWriter.p(", ");
            indentingWriter.p(stringArray[n2]);
            ++n2;
        }
        indentingWriter.pln(");");
        if (bl) {
            indentingWriter.pOlnI("} catch (com.sun.management.viper.services.AuthenticationException e) {");
            indentingWriter.pln("throw new java.rmi.RemoteException(e.getLocalizedMessage(java.util.Locale.getDefault()), e);");
            indentingWriter.pOln("}");
        }
        indentingWriter.pOln("}");
    }

    private void writeContainer(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("// Container class generated by viper rmic1.2, do not edit.");
        indentingWriter.pln();
        if (this.remoteClassName.isQualified()) {
            indentingWriter.pln("package " + this.remoteClassName.getQualifier() + ";");
            indentingWriter.pln();
        }
        indentingWriter.plnI("public final class " + Names.mangleClass(this.containerClassName.getName()));
        indentingWriter.pln("extends com.sun.management.viperimpl.UnicastContainer");
        ClassDefinition[] classDefinitionArray = this.remoteClass.getRemoteInterfaces();
        if (classDefinitionArray.length > 0) {
            indentingWriter.pln("implements " + Names.mangleClass(this.interfaceClassName.getName()));
        }
        indentingWriter.pOlnI("{");
        this.writeOperationsArray(indentingWriter);
        indentingWriter.pln();
        if (this.version == 2 || this.version == 3) {
            indentingWriter.pln("private static final long serialVersionUID = 2;");
            indentingWriter.pln();
        }
        this.writeContainerConstructors(indentingWriter);
        indentingWriter.pln();
        if (this.remoteMethods.length > 0) {
            indentingWriter.pln("// methods from remote interfaces");
            int n = 0;
            while (n < this.remoteMethods.length) {
                indentingWriter.pln();
                this.writeContainerMethod(indentingWriter, n);
                ++n;
            }
        }
        indentingWriter.pOln("}");
    }

    private void writeContainerConstructors(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("// local reference to service bean object so doPrivileged() uses");
        indentingWriter.pln(String.valueOf(String.valueOf(this.remoteClassName.getName())) + " servicebean = null;");
        indentingWriter.pln();
        indentingWriter.pln("// constructors");
        indentingWriter.plnI("public " + Names.mangleClass(this.containerClassName.getName()) + "() throws java.rmi.RemoteException {");
        indentingWriter.plnI("super();");
        indentingWriter.pOlnI("try {");
        indentingWriter.p("bean = (com.sun.management.viper.ServiceProvider)java.beans.Beans.instantiate(getClass().getClassLoader(), ");
        indentingWriter.pln("\"" + this.remoteClassName.getTopName() + "\");");
        indentingWriter.pln("servicebean = (" + this.remoteClassName.getName() + ") bean;");
        indentingWriter.pOlnI("} catch( Exception be ) {");
        indentingWriter.pln("be.printStackTrace();");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeContainerMethod(IndentingWriter indentingWriter, int n) throws IOException {
        RemoteClass.Method method = this.remoteMethods[n];
        Identifier identifier = method.getName();
        Type type = method.getType();
        Type[] typeArray = type.getArgumentTypes();
        String[] stringArray = Generator.nameParameters(typeArray);
        Type type2 = type.getReturnType();
        ClassDeclaration[] classDeclarationArray = method.getExceptions();
        indentingWriter.pOlnI("// secured implementation of " + type.typeString(identifier.toString(), true, false));
        indentingWriter.p("public " + type2 + " " + identifier + "(com.sun.management.viperimpl.services.authentication.SecurityToken $extra_param_1");
        int n2 = 0;
        while (n2 < typeArray.length) {
            indentingWriter.p(", final ");
            indentingWriter.p(String.valueOf(String.valueOf(typeArray[n2])) + " " + stringArray[n2]);
            ++n2;
        }
        indentingWriter.plnI(")");
        indentingWriter.p("throws com.sun.management.viper.services.AuthenticationException");
        int n3 = 0;
        while (n3 < classDeclarationArray.length) {
            indentingWriter.p(", ");
            indentingWriter.p(classDeclarationArray[n3].getName().toString());
            ++n3;
        }
        indentingWriter.pln();
        indentingWriter.pOlnI("{");
        indentingWriter.p("Object [] paramArray = { ");
        int n4 = 0;
        while (n4 < typeArray.length) {
            if (n4 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(Generator.wrapArgumentCode(typeArray[n4], stringArray[n4]));
            ++n4;
        }
        indentingWriter.pln(" };");
        indentingWriter.pln("java.security.AccessControlContext $acc_object_1 = getContext($extra_param_1, paramArray);");
        indentingWriter.plnI("try {");
        indentingWriter.pln("Object $result_object_1 = java.security.AccessController.doPrivileged(");
        indentingWriter.plnI("new java.security.PrivilegedExceptionAction() {");
        indentingWriter.p("public Object run() throws ");
        int n5 = 0;
        while (n5 < classDeclarationArray.length) {
            if (n5 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(classDeclarationArray[n5].getName().toString());
            ++n5;
        }
        indentingWriter.pln();
        indentingWriter.plnI("{");
        String string = "servicebean." + identifier + "(";
        int n6 = 0;
        while (n6 < typeArray.length) {
            if (n6 > 0) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + stringArray[n6];
            ++n6;
        }
        string = String.valueOf(string) + ")";
        if (type2.isType(11)) {
            indentingWriter.p(string);
            indentingWriter.pln(";");
            indentingWriter.pln("return null;");
        } else {
            indentingWriter.p("return ");
            indentingWriter.p(Generator.wrapArgumentCode(type2, string));
            indentingWriter.pln(";");
        }
        indentingWriter.pOln("}");
        indentingWriter.pOln("}, $acc_object_1);");
        if (!type2.isType(11)) {
            indentingWriter.p("return ");
            indentingWriter.p(Generator.unwrapArgumentCode(type2, "$result_object_1"));
            indentingWriter.pln(";");
        }
        indentingWriter.pOlnI("} catch (java.security.PrivilegedActionException e) {");
        int n7 = 0;
        while (n7 < classDeclarationArray.length) {
            indentingWriter.pln("if (e.getException() instanceof " + classDeclarationArray[n7].getName() + ")");
            indentingWriter.pln("\tthrow (" + classDeclarationArray[n7].getName() + ") e.getException();");
            ++n7;
        }
        indentingWriter.pln();
        indentingWriter.pln("throw new java.rmi.ServerException(\"Runtime exception\", e.getException());");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeInterface(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("// Remote interface of Container generated by viper rmic1.2, do not edit.");
        indentingWriter.pln();
        if (this.remoteClassName.isQualified()) {
            indentingWriter.pln("package " + this.remoteClassName.getQualifier() + ";");
            indentingWriter.pln();
        }
        indentingWriter.plnI("public interface " + Names.mangleClass(this.interfaceClassName.getName()));
        indentingWriter.pln("extends java.rmi.Remote");
        indentingWriter.pOlnI("{");
        if (this.remoteMethods.length > 0) {
            indentingWriter.pln("// secured methods from remote interfaces");
            int n = 0;
            while (n < this.remoteMethods.length) {
                indentingWriter.pln();
                this.writeInterfaceMethod(indentingWriter, n);
                ++n;
            }
        }
        indentingWriter.pOln("}");
    }

    private void writeInterfaceHash(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("private static final long interfaceHash = " + this.remoteClass.getInterfaceHash() + "L;");
    }

    private void writeInterfaceMethod(IndentingWriter indentingWriter, int n) throws IOException {
        RemoteClass.Method method = this.remoteMethods[n];
        Identifier identifier = method.getName();
        Type type = method.getType();
        Type[] typeArray = type.getArgumentTypes();
        String[] stringArray = Generator.nameParameters(typeArray);
        Type type2 = type.getReturnType();
        ClassDeclaration[] classDeclarationArray = method.getExceptions();
        indentingWriter.pln("// secured version of " + type.typeString(identifier.toString(), true, false));
        indentingWriter.p("public " + type2 + " " + identifier + "(com.sun.management.viperimpl.services.authentication.SecurityToken  $extra_param_1");
        int n2 = 0;
        while (n2 < typeArray.length) {
            indentingWriter.p(", ");
            indentingWriter.p(String.valueOf(String.valueOf(typeArray[n2])) + " " + stringArray[n2]);
            ++n2;
        }
        indentingWriter.p(")");
        indentingWriter.plnI(" ");
        indentingWriter.p("throws com.sun.management.viper.services.AuthenticationException");
        if (classDeclarationArray.length > 0) {
            int n3 = 0;
            while (n3 < classDeclarationArray.length) {
                indentingWriter.p(", ");
                indentingWriter.p(classDeclarationArray[n3].getName().toString());
                ++n3;
            }
        }
        indentingWriter.pOln(";");
    }

    private static void writeMarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        int n = type.getTypeCode();
        switch (n) {
            case 0: {
                indentingWriter.p(String.valueOf(string) + ".writeBoolean(" + string2 + ")");
                break;
            }
            case 1: {
                indentingWriter.p(String.valueOf(string) + ".writeByte(" + string2 + ")");
                break;
            }
            case 2: {
                indentingWriter.p(String.valueOf(string) + ".writeChar(" + string2 + ")");
                break;
            }
            case 3: {
                indentingWriter.p(String.valueOf(string) + ".writeShort(" + string2 + ")");
                break;
            }
            case 4: {
                indentingWriter.p(String.valueOf(string) + ".writeInt(" + string2 + ")");
                break;
            }
            case 5: {
                indentingWriter.p(String.valueOf(string) + ".writeLong(" + string2 + ")");
                break;
            }
            case 6: {
                indentingWriter.p(String.valueOf(string) + ".writeFloat(" + string2 + ")");
                break;
            }
            case 7: {
                indentingWriter.p(String.valueOf(string) + ".writeDouble(" + string2 + ")");
                break;
            }
            case 9: 
            case 10: {
                indentingWriter.p(String.valueOf(string) + ".writeObject(" + string2 + ")");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
    }

    private static void writeMarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        if (typeArray.length != stringArray.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        int n = 0;
        while (n < typeArray.length) {
            Generator.writeMarshalArgument(indentingWriter, string, typeArray[n], stringArray[n]);
            indentingWriter.pln(";");
            ++n;
        }
    }

    private void writeMethodFieldDeclarations(IndentingWriter indentingWriter) throws IOException {
        int n = 0;
        while (n < this.methodFieldNames.length) {
            indentingWriter.pln("private static java.lang.reflect.Method " + this.methodFieldNames[n] + ";");
            ++n;
        }
    }

    private void writeMethodFieldInitializers(IndentingWriter indentingWriter) throws IOException {
        int n = 0;
        while (n < this.methodFieldNames.length) {
            indentingWriter.p(String.valueOf(this.methodFieldNames[n]) + " = ");
            RemoteClass.Method method = this.remoteMethods[n];
            MemberDefinition memberDefinition = method.getMemberDefinition();
            Identifier identifier = method.getName();
            Type type = method.getType();
            Type[] typeArray = type.getArgumentTypes();
            indentingWriter.p(String.valueOf(String.valueOf(memberDefinition.getClassDefinition().getName())) + ".class.getMethod(\"" + identifier + "\", new java.lang.Class[] {");
            int n2 = 0;
            while (n2 < typeArray.length) {
                if (n2 > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(String.valueOf(String.valueOf(typeArray[n2])) + ".class");
                ++n2;
            }
            indentingWriter.pln("});");
            ++n;
        }
    }

    private void writeOperationsArray(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.plnI("private static final java.lang.String[] operations = {");
        int n = 0;
        while (n < this.remoteMethods.length) {
            if (n > 0) {
                indentingWriter.pln(",");
            }
            indentingWriter.p("\"" + this.formatMethod(this.remoteMethods[n].getOperationString()) + "\"");
            ++n;
        }
        indentingWriter.pln();
        indentingWriter.pOln("};");
        indentingWriter.pln();
        indentingWriter.plnI("public java.lang.String[] getRemoteOperations() {");
        indentingWriter.pln("return operations;");
        indentingWriter.pOln("}");
    }

    private static boolean writeUnmarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        boolean bl = false;
        if (string2 != null) {
            indentingWriter.p(String.valueOf(string2) + " = ");
        }
        int n = type.getTypeCode();
        switch (type.getTypeCode()) {
            case 0: {
                indentingWriter.p(String.valueOf(string) + ".readBoolean()");
                break;
            }
            case 1: {
                indentingWriter.p(String.valueOf(string) + ".readByte()");
                break;
            }
            case 2: {
                indentingWriter.p(String.valueOf(string) + ".readChar()");
                break;
            }
            case 3: {
                indentingWriter.p(String.valueOf(string) + ".readShort()");
                break;
            }
            case 4: {
                indentingWriter.p(String.valueOf(string) + ".readInt()");
                break;
            }
            case 5: {
                indentingWriter.p(String.valueOf(string) + ".readLong()");
                break;
            }
            case 6: {
                indentingWriter.p(String.valueOf(string) + ".readFloat()");
                break;
            }
            case 7: {
                indentingWriter.p(String.valueOf(string) + ".readDouble()");
                break;
            }
            case 9: 
            case 10: {
                indentingWriter.p("(" + type + ") " + string + ".readObject()");
                bl = true;
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
        return bl;
    }

    private static boolean writeUnmarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        if (typeArray.length != stringArray.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        boolean bl = false;
        int n = 0;
        while (n < typeArray.length) {
            if (Generator.writeUnmarshalArgument(indentingWriter, string, typeArray[n], stringArray[n])) {
                bl = true;
            }
            indentingWriter.pln(";");
            ++n;
        }
        return bl;
    }
}

