/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.BeanNotFoundException;
import com.sun.management.viper.Service;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viper.ServiceInfrastructure;
import com.sun.management.viper.ServiceProxy;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VPermission;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationMessageException;
import com.sun.management.viper.services.Authorization;
import com.sun.management.viper.services.AuthorizationException;
import com.sun.management.viper.services.Log;
import com.sun.management.viper.services.ServiceList;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ConnectionInfo;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.ServiceAgent;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.Viper;
import com.sun.management.viperimpl.ViperImplVersion;
import com.sun.management.viperimpl.server.ServiceACManager;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.server.repository.RepositoryException;
import com.sun.management.viperimpl.server.repository.RepositoryService;
import com.sun.management.viperimpl.services.LogRecord;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.NoSecureSessionException;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationService;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ViperImpl
extends UnicastRemoteObject
implements Viper,
ServiceInfrastructure {
    private Vector result = new Vector(10, 10);
    private Vector error = new Vector(10, 10);
    private static Log log = null;
    private static Authorization congress = null;
    private static RepositoryService rep = null;
    private static String[] cores = new String[]{ServiceList.LOG, ServiceList.AUTHORIZATION};
    private Properties config = null;
    private Hashtable beanUsageTable = new Hashtable();
    private VCallerImpl serviceRole = null;
    private ServiceACManager sacManager = null;
    private static Vector logBuffer = new Vector();
    private String msg = null;
    public final int SMC_BEAN_COMPONENT = 0;
    public final int SMC_EXE_COMPONENT = 1;
    private Hashtable localLoadedServices = new Hashtable();

    public ViperImpl(Properties properties) throws RemoteException, VException {
        this.config = properties;
        this.init(properties);
    }

    private static void appendLogBuffer(String string, String string2, int n, String string3, String string4, String[] stringArray, String string5, String string6) {
        logBuffer.add(new LogRecord(string, string2, n, string3, string4, stringArray, string5, string6));
    }

    public SecurityToken authRequest(String string, SecurityToken securityToken) throws RemoteException, VException {
        return AuthenticationService.authRequest(string, securityToken);
    }

    private void buildServices() throws VException {
        Debug.trace((String)"ViperImpl", (int)Debug.INFORMATION, (String)"*****  Building Core Services ******", null);
        rep = new RepositoryService(cores, this, this.sacManager);
        log = (Log)rep.getCoreService(ServiceList.LOG);
        ViperImpl.flushLogBuffer();
        congress = (Authorization)rep.getCoreService(ServiceList.AUTHORIZATION);
    }

    protected void checkPermission(VIdentity vIdentity, VPermission vPermission) throws RemoteException, AuthorizationException {
        if (congress == null) {
            throw new AuthorizationException("Authorization Service not installed.");
        }
        congress.checkPermission((Principal)vIdentity, vPermission);
    }

    protected ServerSecurityContext checkSecureConnection(SecurityToken securityToken) throws AuthenticationException {
        ServerSecurityContext serverSecurityContext = AuthenticationService.lookupSecurityContext(securityToken);
        if (serverSecurityContext == null || serverSecurityContext.getAuthState() != 4) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Attempt to call method when secure session not established or expired", null);
            throw new NoSecureSessionException();
        }
        return serverSecurityContext;
    }

    protected void checkToken(SecurityToken securityToken, Object[] objectArray) throws AuthenticationException {
        if (!(securityToken instanceof MessageSecurityToken)) {
            throw new AuthenticationMessageException();
        }
        ServerSecurityContext serverSecurityContext = this.checkSecureConnection(securityToken);
        serverSecurityContext.verifyMessageToken((MessageSecurityToken)securityToken, objectArray);
    }

    public ConnectionInfo[] connectionList(SecurityToken securityToken) throws RemoteException, VException {
        this.checkToken(securityToken, null);
        return this.getCurrentConnectionList();
    }

    public void derefService(String string, SecurityToken securityToken) throws RemoteException, VException {
        Object[] objectArray = new Object[]{string};
        this.checkToken(securityToken, objectArray);
        ConnectionInfo connectionInfo = this.findConnectionInfo(securityToken);
        connectionInfo.removeService(string);
    }

    public void derefTool(String string, SecurityToken securityToken) throws RemoteException, VException {
        Object[] objectArray = new Object[]{string};
        this.checkToken(securityToken, objectArray);
        ConnectionInfo connectionInfo = this.findConnectionInfo(securityToken);
        connectionInfo.removeTool(string);
    }

    private ConnectionInfo findConnectionInfo(SecurityToken securityToken) throws AuthenticationException {
        ConnectionInfo connectionInfo = (ConnectionInfo)this.beanUsageTable.get(new Long(securityToken.getSecurityId()));
        if (connectionInfo == null) {
            ServerSecurityContext serverSecurityContext = this.checkSecureConnection(securityToken);
            connectionInfo = new ConnectionInfo(this.getCallerId(securityToken), serverSecurityContext.getStartTime());
            this.beanUsageTable.put(new Long(securityToken.getSecurityId()), connectionInfo);
        }
        return connectionInfo;
    }

    private static void flushLogBuffer() {
        int n = 0;
        while (n < logBuffer.size()) {
            LogRecord logRecord = (LogRecord)logBuffer.elementAt(n);
            ViperImpl.writeLog(logRecord.sourceKey, logRecord.category, logRecord.severity, logRecord.sumKey, logRecord.detKey, logRecord.fargs, logRecord.resource, logRecord.data);
            ++n;
        }
        logBuffer.clear();
    }

    protected VCallerImpl getCallerId(SecurityToken securityToken) throws AuthenticationException {
        ServerSecurityContext serverSecurityContext = this.checkSecureConnection(securityToken);
        AuthenticationPrincipal authenticationPrincipal = serverSecurityContext.getAuthPrincipal();
        String string = "unknown";
        try {
            string = RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {}
        VCallerImpl vCallerImpl = new VCallerImpl(authenticationPrincipal, string, securityToken);
        vCallerImpl.setUid(serverSecurityContext.getUid());
        vCallerImpl.setGid(serverSecurityContext.getGid());
        vCallerImpl.setShell(serverSecurityContext.getShell());
        vCallerImpl.setHome(serverSecurityContext.getHome());
        return vCallerImpl;
    }

    public VCallerImpl getCallerImpl(SecurityToken securityToken) throws RemoteException, VException {
        this.checkToken(securityToken, null);
        return this.getCallerId(securityToken);
    }

    public URL getCodebase() throws RemoteException, VException {
        StringTokenizer stringTokenizer;
        String string = System.getProperty("java.rmi.server.codebase");
        if (string != null && (stringTokenizer = new StringTokenizer(string)).countTokens() > 0) {
            string = stringTokenizer.nextToken();
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new VException("Server codebase was not set correctly.");
        }
    }

    ConnectionInfo[] getCurrentConnectionList() throws RemoteException, VException {
        Object object;
        Hashtable<Object, ConnectionInfo> hashtable = new Hashtable<Object, ConnectionInfo>();
        Enumeration enumeration = this.beanUsageTable.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ConnectionInfo connectionInfo = (ConnectionInfo)this.beanUsageTable.get(object);
            try {
                this.checkSecureConnection(connectionInfo.getUserId().getToken());
                hashtable.put(object, connectionInfo);
            }
            catch (AuthenticationException authenticationException) {}
        }
        this.beanUsageTable = hashtable;
        object = hashtable.values();
        return object.toArray((ConnectionInfo[])new ConnectionInfo[0]);
    }

    public Object getExternalClient(String string, Object[] objectArray) throws Exception {
        return null;
    }

    public ExternalClientProviderInfoImpl[] getExternalClientProviderInfoImpl(String string, SecurityToken securityToken) throws RemoteException, VException {
        Object[] objectArray = new Object[]{string};
        this.checkToken(securityToken, objectArray);
        return rep.getExternalClientProviderInfo(string);
    }

    public VIdentity getIdentity() {
        return this.serviceRole;
    }

    public Service getServiceByName(String string) throws VException {
        return this.getServiceByName(string, false);
    }

    public Service getServiceByName(String string, boolean bl) throws VException {
        if (string == null) {
            String[] stringArray = new String[]{"null"};
            throw new BeanNotFoundException("ServiceNotFound", (Object)stringArray);
        }
        ServiceAgent serviceAgent = rep.getServiceAgent(string, this.serviceRole, null);
        if (serviceAgent != null) {
            if (bl) {
                serviceAgent.setDelegationConext(this.sacManager);
            } else {
                serviceAgent.setContext(this.sacManager);
            }
        } else {
            String[] stringArray = new String[]{string};
            throw new BeanNotFoundException("ServiceNotFound", (Object)stringArray);
        }
        this.localLoadedServices.put(serviceAgent, string);
        return serviceAgent;
    }

    public ServiceInfo getServiceInfo(String string) throws VException {
        return rep.getServiceInfo(string)[0];
    }

    public ServiceInfoImpl[] getServiceInfoImpl(String string, SecurityToken securityToken) throws RemoteException, VException {
        Object[] objectArray = new Object[]{string};
        this.checkToken(securityToken, objectArray);
        String string2 = this.getCallerId(securityToken).getName();
        return rep.getServiceInfo(string);
    }

    public Vector getServiceInfoImplList(SecurityToken securityToken) throws RemoteException, VException {
        this.checkToken(securityToken, null);
        String string = this.getCallerId(securityToken).getName();
        return rep.getServiceInfoList();
    }

    public ServiceAgent getServiceObject(String string, SecurityToken securityToken) throws RemoteException, VException {
        ServiceAgent serviceAgent = null;
        Object[] objectArray = new Object[]{string};
        this.checkToken(securityToken, objectArray);
        if (string == null) {
            return null;
        }
        VCallerImpl vCallerImpl = this.getCallerId(securityToken);
        if (rep == null) {
            this.msg = "Repository didn't initialized";
            Debug.trace((String)"ViperImpl", (int)Debug.ERROR, (String)this.msg, null);
            throw new RepositoryException(this.msg);
        }
        serviceAgent = rep.getServiceAgent(string, vCallerImpl, null);
        this.msg = "Service agent " + serviceAgent + " created";
        Debug.trace((String)"ViperImpl", (int)Debug.INFORMATION, (String)this.msg, null);
        ConnectionInfo connectionInfo = this.findConnectionInfo(securityToken);
        connectionInfo.addService(string);
        return serviceAgent;
    }

    protected VCallerImpl getServiceRole() {
        return this.serviceRole;
    }

    public Tool getToolByName(String string) throws VException {
        return null;
    }

    public ToolInfo getToolInfo(String string) throws VException {
        return rep.getToolInfo(string);
    }

    public ToolInfoImpl getToolInfoImpl(String string) throws RemoteException, VException {
        return rep.getToolInfo(string);
    }

    public Vector getToolInfoImplList() throws RemoteException, VException {
        return rep.getToolInfoList();
    }

    public URL getToolURL(String string, SecurityToken securityToken) throws RemoteException, VException {
        Object[] objectArray = new Object[]{string};
        this.checkToken(securityToken, objectArray);
        URL uRL = this.getCodebase();
        if (uRL == null) {
            throw new VException("Server codebase not setup");
        }
        if (rep == null) {
            throw new RepositoryException("Repository is not avaiable");
        }
        String string2 = rep.getToolJarName(string);
        if (string2 == null) {
            throw new BeanNotFoundException("ToolNotFound", (Object)string);
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new VException("Server codebase URL format error:" + malformedURLException.getMessage());
        }
        return uRL2;
    }

    public String getViperImplVersion() throws RemoteException {
        return ViperImplVersion.getFullVersion();
    }

    private void init(Properties properties) throws VException {
        this.msg = "In ViperImpl init";
        Debug.trace((String)"ViperImpl", (int)Debug.INFORMATION, (String)this.msg, null);
        String string = AuthenticationLibrary.getProcessOwnerName();
        if (string == null) {
            this.serviceRole = null;
        } else {
            try {
                this.serviceRole = new VCallerImpl(string, "Viper Service", "localhost", "localhost", null);
                int n = Integer.parseInt(AuthenticationLibrary.getUid(string));
                int n2 = Integer.parseInt(AuthenticationLibrary.getGid(string));
                this.serviceRole.setUid(n);
                this.serviceRole.setGid(n2);
                this.serviceRole.setShell(AuthenticationLibrary.getShell(string));
                this.serviceRole.setHome(AuthenticationLibrary.getHomedir(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new VException("Can't retrieve current process uid or gid.");
            }
        }
        this.sacManager = new ServiceACManager(this);
        this.buildServices();
        AuthenticationService.init(properties, log);
    }

    void onExit() {
        rep.unload();
    }

    public void refServiceProxy(String string, SecurityToken securityToken) throws RemoteException, VException {
        Object[] objectArray = new Object[]{string};
        this.checkToken(securityToken, objectArray);
        ConnectionInfo connectionInfo = this.findConnectionInfo(securityToken);
        connectionInfo.addService(string);
    }

    public void refTool(String string, SecurityToken securityToken) throws RemoteException, VException {
        Object[] objectArray = new Object[]{string};
        this.checkToken(securityToken, objectArray);
        ConnectionInfo connectionInfo = this.findConnectionInfo(securityToken);
        connectionInfo.addTool(string);
    }

    public void releaseService(Service service) throws VException {
        if (service != null) {
            Object object;
            if (service instanceof ServiceProxy) {
                try {
                    object = (ServiceProxy)service;
                    object.stop();
                    object.destroy();
                }
                catch (Throwable throwable) {}
            }
            object = (String)this.localLoadedServices.remove(service);
        }
    }

    public void restartServer(int n, SecurityToken securityToken) throws RemoteException, VException {
        Object[] objectArray = new Object[]{new Integer(n)};
        this.checkToken(securityToken, objectArray);
        ViperServer.exitServer((VIdentity)this.getCallerId(securityToken), 0);
    }

    public void stopServer(SecurityToken securityToken) throws RemoteException, VException {
        this.checkToken(securityToken, null);
        ViperServer.exitServer((VIdentity)this.getCallerId(securityToken), 0);
    }

    static void writeBufferedLog(String string, String string2, int n, String string3, String string4, String[] stringArray, String string5, String string6) {
        ViperImpl.appendLogBuffer(string, string2, n, string3, string4, stringArray, string5, string6);
        if (log != null) {
            ViperImpl.flushLogBuffer();
        }
    }

    private static void writeLog(String string, String string2, int n, String string3, String string4, String[] stringArray, String string5, String string6) {
        if (log == null) {
            return;
        }
        try {
            log.writeLog(string, string2, n, string3, string4, stringArray, string5, string6);
        }
        catch (RemoteException remoteException) {
            Debug.trace((String)"Server", (int)Debug.ERROR, (String)"exception from log service", (Throwable)remoteException);
        }
        catch (Throwable throwable) {
            Debug.trace((String)"Server", (int)Debug.ERROR, (String)"exception from log service", (Throwable)throwable);
        }
    }
}

