/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.VException;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.services.Log;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationLoginException;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.CloseSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.NoSecureSessionException;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.RetryLimitExceededException;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityContext;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityFactory;
import com.sun.management.viperimpl.util.Timer;
import com.sun.management.viperimpl.util.TimerTask;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class AuthenticationService {
    private static final String AUTH_PACKAGE = (class$com$sun$management$viperimpl$services$authentication$server$AuthenticationService != null ? class$com$sun$management$viperimpl$services$authentication$server$AuthenticationService : (class$com$sun$management$viperimpl$services$authentication$server$AuthenticationService = AuthenticationService.class$("com.sun.management.viperimpl.services.authentication.server.AuthenticationService"))).getPackage().getName();
    private static final String AUTH_FACTORY_CLASSNAME = "ServerSecurityFactory";
    private static final String AUTH_SERVICE_RESOURCES = "AuthenticationServiceResources";
    private static final long AUTH_FAILURE_DELAY = 2000L;
    private static int dfltType;
    private static Hashtable factTable;
    private static Hashtable sessTable;
    private static Log logsvc;
    private static long htbtPeriod;
    private static int maxRetries;
    private static long penalty_ms;
    private static Vector failedAttempts;
    static /* synthetic */ Class class$com$sun$management$viperimpl$services$authentication$server$AuthenticationService;

    private static synchronized void addSecurityContext(long l, ServerSecurityContext serverSecurityContext) {
        if (l != 0L) {
            Long l2 = new Long(l);
            sessTable.put(l2, serverSecurityContext);
        }
    }

    private static void auditRetryLimitExceeded(String string, String string2) {
        try {
            AuthenticationLibrary.auditLogin(string, string, -3, 0L);
        }
        catch (Exception exception) {}
        String[] stringArray = new String[]{string, string2};
        AuthenticationService.writeLog(400, "LMS_LoginFailed", "LMD_RetryLimitExceeded", stringArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecurityToken authRequest(String string, SecurityToken securityToken) throws AuthenticationException {
        void var2_7;
        Object var2_2 = null;
        if (string == null) throw new AuthenticationException("Invalid remote request type");
        if (string.equals("negotiate")) {
            ResponseSecurityToken responseSecurityToken = AuthenticationService.negotiate(securityToken);
            return var2_7;
        } else if (string.equals("authenticate")) {
            ConfirmSecurityToken confirmSecurityToken = AuthenticationService.authenticate(securityToken);
            return var2_7;
        } else if (string.equals("heartbeat")) {
            SecurityToken securityToken2 = AuthenticationService.heartbeat(securityToken);
            return var2_7;
        } else {
            if (!string.equals("close")) throw new AuthenticationException("Invalid remote request type");
            SecurityToken securityToken3 = AuthenticationService.close(securityToken);
        }
        return var2_7;
    }

    private static ConfirmSecurityToken authenticate(SecurityToken securityToken) throws AuthenticationException {
        ConfirmSecurityToken confirmSecurityToken;
        AuthenticatorSecurityToken authenticatorSecurityToken;
        try {
            authenticatorSecurityToken = (AuthenticatorSecurityToken)securityToken;
        }
        catch (Exception exception) {
            throw new AuthenticationException("Invalid input security token type");
        }
        long l = authenticatorSecurityToken.getSecurityId();
        ServerSecurityContext serverSecurityContext = AuthenticationService.findSecurityContext(l);
        if (serverSecurityContext == null) {
            String[] stringArray = new String[]{new Long(l).toString()};
            AuthenticationService.writeLog(400, "LMS_SessionOpened", "LMD_BadSecondStep", stringArray);
            throw new NoSecureSessionException();
        }
        try {
            confirmSecurityToken = serverSecurityContext.verifyAuthenticatorToken(authenticatorSecurityToken);
        }
        catch (AuthenticationLoginException authenticationLoginException) {
            AuthenticationService.checkRetriesOnFail(serverSecurityContext);
            throw authenticationLoginException;
        }
        catch (AuthenticationException authenticationException) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Unexpected error verifying authenticator: " + authenticationException.getMessage()), (Throwable)authenticationException);
            AuthenticationService.checkRetriesOnFail(serverSecurityContext);
            throw new AuthenticationException("Error authenticating user", (Exception)((Object)authenticationException));
        }
        serverSecurityContext.setHeartbeatTime();
        String string = serverSecurityContext.getAuthPrincipal().getUserName();
        if (serverSecurityContext.getAuthPrincipal().getRoleName() != null) {
            string = String.valueOf(string) + " (in role " + serverSecurityContext.getAuthPrincipal().getRoleName() + ")";
        }
        AuthenticationService.writeLog(serverSecurityContext, 100, "LMS_SessionOpened", "LMD_LoginSuccessful", null);
        return confirmSecurityToken;
    }

    private static void checkRetriesOnFail(ServerSecurityContext serverSecurityContext) throws RetryLimitExceededException {
        long l = 2000L;
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        AttemptRecord attemptRecord = null;
        int n = failedAttempts.size() - 1;
        while (n >= 0) {
            AttemptRecord attemptRecord2 = (AttemptRecord)failedAttempts.elementAt(n);
            if (l2 - attemptRecord2.lastFailedAt > 600000L) {
                failedAttempts.remove(n);
            } else if (attemptRecord2.clientVMID.equals(serverSecurityContext.getClientVMID())) {
                attemptRecord = attemptRecord2;
            }
            --n;
        }
        if (attemptRecord == null) {
            attemptRecord = new AttemptRecord(serverSecurityContext.getClientVMID());
            failedAttempts.add(attemptRecord);
        }
        attemptRecord.lastFailedAt = l2;
        ++attemptRecord.failCounter;
        if (attemptRecord.failCounter == maxRetries) {
            AuthenticationService.auditRetryLimitExceeded(serverSecurityContext.getClientHost(), serverSecurityContext.getClientVMID());
            bl = true;
        } else if (attemptRecord.failCounter > maxRetries) {
            bl = true;
            l += penalty_ms;
        }
        AuthenticationService.removeSecurityContext(serverSecurityContext.getSecurityId());
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {}
        if (bl) {
            throw new RetryLimitExceededException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static SecurityToken close(SecurityToken securityToken) throws AuthenticationException {
        int n;
        long l;
        ServerSecurityContext serverSecurityContext = null;
        if (securityToken != null) {
            l = securityToken.getSecurityId();
            n = securityToken.getAuthType();
            serverSecurityContext = AuthenticationService.findSecurityContext(l);
        } else {
            l = 0L;
            n = AuthenticationFlavor.getDefaultAuthType();
        }
        if (serverSecurityContext != null) {
            AuthenticationService.writeLog(serverSecurityContext, 100, "LMS_SessionClosed", "LMD_LogoutSuccessful", null);
            AuthenticationService.removeSecurityContext(l);
        }
        CloseSecurityToken closeSecurityToken = new CloseSecurityToken(n, l);
        return closeSecurityToken;
    }

    private static synchronized ServerSecurityContext createSecurityContext(int n) throws AuthenticationException {
        ServerSecurityFactory serverSecurityFactory = (ServerSecurityFactory)factTable.get(new Integer(n));
        if (serverSecurityFactory == null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Request to create security context for non-existent flavor" + n), null);
            throw new AuthenticationException("Request to create security context for non-existent authentication type ", (Object)new Integer(n));
        }
        ServerSecurityContext serverSecurityContext = serverSecurityFactory.getServerSecurityContext();
        if (serverSecurityContext != null) {
            serverSecurityContext.setLogService(logsvc);
        }
        return serverSecurityContext;
    }

    private static synchronized ServerSecurityContext findSecurityContext(long l) {
        ServerSecurityContext serverSecurityContext = null;
        if (l != 0L) {
            Long l2 = new Long(l);
            serverSecurityContext = (ServerSecurityContext)sessTable.get(l2);
        }
        return serverSecurityContext;
    }

    private static synchronized long genSecurityId() throws AuthenticationException {
        long l = System.currentTimeMillis();
        if (!sessTable.isEmpty()) {
            int n = 0;
            while (n < 5) {
                if (!sessTable.contains(new Long(l))) break;
                ++l;
                ++n;
            }
            if (n == 5) {
                throw new AuthenticationException("EXM_NID");
            }
        }
        return l;
    }

    public static ServerSecurityContext getSecurityContext() throws AuthenticationException {
        return AuthenticationService.createSecurityContext(dfltType);
    }

    public static ServerSecurityContext getSecurityContext(AuthenticationFlavor authenticationFlavor) throws AuthenticationException {
        return AuthenticationService.createSecurityContext(authenticationFlavor.getAuthType());
    }

    private static SecurityToken heartbeat(SecurityToken securityToken) throws AuthenticationException {
        long l;
        ServerSecurityContext serverSecurityContext;
        if (securityToken != null && (serverSecurityContext = AuthenticationService.findSecurityContext(l = securityToken.getSecurityId())) != null) {
            serverSecurityContext.setHeartbeatTime();
        }
        return null;
    }

    public static void init(Properties properties, Log log) throws AuthenticationException {
        String string;
        ServerSecurityFactory serverSecurityFactory;
        logsvc = log;
        String[] stringArray = AuthenticationFlavor.getAuthFlavors();
        if (stringArray.length < 1) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"No authentication flavors configured", null);
            throw new AuthenticationException("NoFlavorConfiged");
        }
        String string2 = String.valueOf(AUTH_PACKAGE) + ".";
        factTable = new Hashtable();
        int n = 0;
        while (n < stringArray.length) {
            String string3 = String.valueOf(string2) + stringArray[n] + AUTH_FACTORY_CLASSNAME;
            try {
                Class<?> clazz = Class.forName(string3);
                serverSecurityFactory = (ServerSecurityFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Cannot create new instance of security factory " + string3), (Throwable)exception);
                throw new AuthenticationException("Cannot create new instance of security factory ", (Object)string3, exception);
            }
            serverSecurityFactory.init(properties);
            factTable.put(new Integer(n), serverSecurityFactory);
            ++n;
        }
        int n2 = -1;
        if (properties != null && (string = properties.getProperty("auth.flavor.default")) != null) {
            n2 = AuthenticationFlavor.checkAuthFlavor((String)string);
        }
        if (n2 < 0) {
            n2 = AuthenticationFlavor.getDefaultAuthType();
        }
        if ((serverSecurityFactory = (ServerSecurityFactory)factTable.get(new Integer(n2))) == null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"No default authentication flavor is configured", null);
            throw new AuthenticationException("No default authentication flavor is configured");
        }
        dfltType = n2;
        String string4 = null;
        if (properties != null) {
            string4 = properties.getProperty("auth.retry.max");
        }
        if (string4 == null) {
            string4 = "5";
        }
        try {
            maxRetries = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            maxRetries = 5;
        }
        string4 = null;
        if (properties != null) {
            string4 = properties.getProperty("auth.retry.delay");
        }
        if (string4 == null) {
            string4 = "30";
        }
        try {
            penalty_ms = Long.parseLong(string4) * 1000L;
        }
        catch (NumberFormatException numberFormatException) {
            penalty_ms = 30000L;
        }
        string4 = null;
        if (properties != null) {
            string4 = properties.getProperty("auth.heartbeat.period");
        }
        if (string4 == null) {
            string4 = "900";
        }
        try {
            htbtPeriod = Long.parseLong(string4) * 1000L;
        }
        catch (NumberFormatException numberFormatException) {
            htbtPeriod = 900000L;
        }
        failedAttempts = new Vector();
        sessTable = new Hashtable();
        if (htbtPeriod >= 0L) {
            Timer timer = new Timer(true);
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    long l = System.currentTimeMillis();
                    Enumeration enumeration = sessTable.elements();
                    while (enumeration.hasMoreElements()) {
                        ServerSecurityContext serverSecurityContext = (ServerSecurityContext)enumeration.nextElement();
                        if (l - serverSecurityContext.getHeartbeatTime() < 2L * htbtPeriod) continue;
                        Long l2 = new Long(serverSecurityContext.getSecurityId());
                        sessTable.remove(l2);
                        AuthenticationService.writeLog(serverSecurityContext, 300, "LMS_SessionClosed", "LMD_SessionTimeout", null);
                    }
                }
            };
            timer.schedule(timerTask, htbtPeriod, htbtPeriod / 10L);
        }
    }

    public static ServerSecurityContext lookupSecurityContext(SecurityToken securityToken) throws AuthenticationException {
        long l = securityToken.getSecurityId();
        return AuthenticationService.findSecurityContext(l);
    }

    private static ResponseSecurityToken negotiate(SecurityToken securityToken) throws AuthenticationException {
        RequestSecurityToken requestSecurityToken;
        try {
            requestSecurityToken = (RequestSecurityToken)securityToken;
        }
        catch (Exception exception) {
            throw new AuthenticationException("Invalid input security token type");
        }
        String string = "";
        String string2 = "";
        AuthenticationPrincipal authenticationPrincipal = requestSecurityToken.getAuthPrincipal();
        if (authenticationPrincipal != null) {
            string = authenticationPrincipal.getUserName();
            if (authenticationPrincipal.getRoleName() != null) {
                string = String.valueOf(string) + " (in role " + authenticationPrincipal.getRoleName() + ")";
            }
        }
        string2 = requestSecurityToken.getClientHost();
        int n = requestSecurityToken.getVersionNumber();
        if (n != 1) {
            String string3 = new Integer(n).toString();
            String string4 = new Integer(1).toString();
            String[] stringArray = new String[]{string, string2, string3, string4};
            AuthenticationService.writeLog(400, "LMS_SvcError", "LMD_VersionMismatch", stringArray);
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Incompatible token version numbers: " + string3 + " " + string4), null);
            throw new AuthenticationException("Incompatible token version numbers", (Object)string3, (Object)string4);
        }
        boolean bl = false;
        ServerSecurityContext serverSecurityContext = null;
        AuthenticationFlavor authenticationFlavor = requestSecurityToken.getAuthFlavor();
        try {
            serverSecurityContext = AuthenticationService.getSecurityContext(authenticationFlavor);
            bl = serverSecurityContext.verifyAuthFlavor(authenticationFlavor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        if (!bl) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Incompatible authentication flavors", null);
            throw new AuthenticationException("Incompatible flavors");
        }
        long l = 0L;
        try {
            l = AuthenticationService.genSecurityId();
        }
        catch (VException vException) {
            AuthenticationService.writeLog(serverSecurityContext, 400, "LMS_SvcError", "LMD_NoSessionId", null);
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Session connect: Unable to generate sesion identifier", (Throwable)vException);
            throw new AuthenticationException("Cannot generate session identifier");
        }
        serverSecurityContext.setSecurityId(l);
        serverSecurityContext.setClientVersion(n);
        serverSecurityContext.setClientVMID(requestSecurityToken.getClientVMID());
        ResponseSecurityToken responseSecurityToken = null;
        try {
            responseSecurityToken = serverSecurityContext.verifyRequestToken(requestSecurityToken);
        }
        catch (AuthenticationException authenticationException) {
            AuthenticationService.checkRetriesOnFail(serverSecurityContext);
            throw authenticationException;
        }
        catch (VException vException) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Session connect: Exception verifying request: " + vException.getMessage()), (Throwable)vException);
            throw new AuthenticationException("Unexpected error verifying response", (Exception)((Object)vException));
        }
        AuthenticationService.addSecurityContext(l, serverSecurityContext);
        return responseSecurityToken;
    }

    private static synchronized void removeSecurityContext(long l) {
        if (l != 0L) {
            Long l2 = new Long(l);
            sessTable.remove(l2);
        }
    }

    private static void writeLog(int n, String string, String string2, String[] stringArray) {
        block2: {
            if (logsvc == null) break block2;
            try {
                logsvc.writeLog("LMS_AuthSvcName", "security", n, string, string2, stringArray, String.valueOf(AUTH_PACKAGE) + "." + AUTH_SERVICE_RESOURCES, null);
            }
            catch (Exception exception) {}
        }
    }

    private static void writeLog(ServerSecurityContext serverSecurityContext, int n, String string, String string2, String string3) {
        String[] stringArray;
        if (serverSecurityContext == null) {
            return;
        }
        String string4 = null;
        AuthenticationPrincipal authenticationPrincipal = serverSecurityContext.getAuthPrincipal();
        if (authenticationPrincipal != null) {
            string4 = authenticationPrincipal.getUserName();
            if (authenticationPrincipal.getRoleName() != null) {
                string4 = String.valueOf(string4) + " (in role " + authenticationPrincipal.getRoleName() + ")";
            }
        }
        String string5 = serverSecurityContext.getClientHost();
        long l = serverSecurityContext.getSecurityId();
        if (string3 == null) {
            stringArray = new String[3];
        } else {
            stringArray = new String[4];
            stringArray[3] = string3;
        }
        stringArray[0] = string4;
        stringArray[1] = string5;
        stringArray[2] = Long.toString(l);
        AuthenticationService.writeLog(n, string, string2, stringArray);
    }

    private static class AttemptRecord {
        static final long LIFE_TIME = 600000L;
        String clientVMID;
        int failCounter;
        long lastFailedAt;

        AttemptRecord(String string) {
            this.clientVMID = string;
            this.failCounter = 0;
            this.lastFailedAt = 0L;
        }
    }
}

