/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.CalendarSync;

import com.sun.pdasync.Conduits.CalendarSync.ApptDBRecordFlags;
import com.sun.pdasync.Conduits.CalendarSync.ExtraRecordFlags;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import palm.conduit.AbstractRecord;

public class CalendarSyncRecord
extends AbstractRecord {
    private int apptId = 0;
    private Date startDate = null;
    private Date endDate = null;
    private boolean isUntimed = false;
    private boolean isAlarmed = false;
    private int alarmAdvanceTime = 0;
    private int alarmAdvanceUnit = 0;
    private boolean isRepeating = false;
    private int repeatType = 0;
    private Date repeatEndDate = null;
    private int repeatFrequency = 1;
    private int repeatOn = 0;
    private int repeatStartWeek = 0;
    private int exceptionsNum = 0;
    private Vector dateExceptions = new Vector();
    private String description = null;
    private String note = null;
    public static final int REPEAT_TYPE_NO_REPEAT = 0;
    public static final int REPEAT_TYPE_DAILY = 1;
    public static final int REPEAT_TYPE_WEEKLY = 2;
    public static final int REPEAT_TYPE_MONTHLY_BY_DAY = 3;
    public static final int REPEAT_TYPE_MONTHLY_BY_DATE = 4;
    public static final int REPEAT_TYPE_YEARLY_BY_DATE = 5;
    public static final int REPEAT_TYPE_YEARLY_BY_DAY = 6;
    private static final String[] repeatTypeText = new String[]{"NoRepeat", "Daily", "Weekly", "MonthlyByDay", "MonthlyByDate", "YearlyByDate", "YearlyByDay"};
    public static final int DAY_SUNDAY = 0;
    public static final int DAY_MONDAY = 1;
    public static final int DAY_TUESDAY = 2;
    public static final int DAY_WEDNESDAY = 3;
    public static final int DAY_THURSDAY = 4;
    public static final int DAY_FRIDAY = 5;
    public static final int DAY_SATURDAY = 6;
    private static final String[] dayText = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    public static final int WEEK_FIRST = 0;
    public static final int WEEK_SECOND = 1;
    public static final int WEEK_THIRD = 2;
    public static final int WEEK_FORTH = 3;
    public static final int WEEK_LAST = 4;
    private static final String[] weekText = new String[]{"First", "Second", "Third", "Forth", "Last"};
    public static final int MONTH_JANUARY = 0;
    public static final int MONTH_FEBRUARY = 1;
    public static final int MONTH_MARCH = 2;
    public static final int MONTH_APRIL = 3;
    public static final int MONTH_MAY = 4;
    public static final int MONTH_JUNE = 5;
    public static final int MONTH_JULY = 6;
    public static final int MONTH_AUGUST = 7;
    public static final int MONTH_SEPTEMBER = 8;
    public static final int MONTH_OCTOBER = 9;
    public static final int MONTH_NOVEMBER = 10;
    public static final int MONTH_DECEMBER = 11;
    private static final String[] monthText = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final int ALARM_UNIT_MINUTES = 0;
    public static final int ALARM_UNIT_HOURS = 1;
    public static final int ALARM_UNIT_DAYS = 2;
    private static final String[] alarmUnitText = new String[]{"Minutes", "Hours", "Days"};

    public void CalendarSyncRecord(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public void addDateException(Date dateException) {
        this.dateExceptions.addElement(dateException);
    }

    public void addRepeatOnDay(int day) {
        this.repeatOn |= 1 << day;
    }

    public int getAlarmAdvanceTime() {
        return this.alarmAdvanceTime;
    }

    public int getAlarmAdvanceUnit() {
        return this.alarmAdvanceUnit;
    }

    public static String getAlarmUnitText(int i) {
        return alarmUnitText[i];
    }

    public int getApptId() {
        return this.apptId;
    }

    public Vector getDateExceptions() {
        return this.dateExceptions;
    }

    public static String getDayText(int i) {
        return dayText[i];
    }

    public String getDescription() {
        return this.description;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean getIsAlarmed() {
        return this.isAlarmed;
    }

    public boolean getIsRepeating() {
        return this.isRepeating;
    }

    public boolean getIsUntimed() {
        return this.isUntimed;
    }

    public static String getMonthText(int i) {
        return monthText[i];
    }

    public String getNote() {
        return this.note;
    }

    public Date getRepeatEndDate() {
        return this.repeatEndDate;
    }

    public int getRepeatFrequency() {
        return this.repeatFrequency;
    }

    public int[] getRepeatOn() {
        int tmpRepeatOn = this.repeatOn;
        int[] tmp = new int[7];
        int count = 0;
        int i = 0;
        while (i < 7) {
            if ((tmpRepeatOn & 1) == 1) {
                tmp[count++] = i;
            }
            tmpRepeatOn >>= 1;
            ++i;
        }
        int[] retval = new int[count];
        System.arraycopy(tmp, 0, retval, 0, count);
        return retval;
    }

    public int getRepeatOnDay() {
        return this.repeatOn % 7;
    }

    String[] getRepeatOnText() {
        int[] days = this.getRepeatOn();
        String[] daysText = new String[days.length];
        int i = 0;
        while (i < daysText.length) {
            daysText[i] = dayText[days[i]];
            ++i;
        }
        return daysText;
    }

    public int getRepeatOnWeek() {
        return this.repeatOn / 7;
    }

    public int getRepeatStartWeek() {
        return this.repeatStartWeek;
    }

    public int getRepeatType() {
        return this.repeatType;
    }

    public static String getRepeatTypeText(int i) {
        return repeatTypeText[i];
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public static String getWeekText(int i) {
        return weekText[i];
    }

    public void readBUData(DataInputStream in) throws IOException {
        ExtraRecordFlags flags = new ExtraRecordFlags();
        this.apptId = in.readInt();
        this.setId(in.readInt());
        flags.readData(in);
        if (flags.priv) {
            this.setIsPrivate(true);
        }
        this.readData(in);
    }

    public Date readBUDate(DataInputStream in) throws IOException {
        Date buDate = new Date();
        buDate.setTime(in.readLong());
        return buDate;
    }

    public void readCbkData(DataInputStream in) throws IOException {
        ExtraRecordFlags flags = new ExtraRecordFlags();
        this.setId(in.readInt());
        flags.readData(in);
        if (flags.priv) {
            this.setIsPrivate(true);
        }
        this.readData(in);
    }

    public void readData(DataInputStream in) throws IOException {
        int end;
        int start;
        ApptDBRecordFlags flags = new ApptDBRecordFlags();
        Calendar cal = Calendar.getInstance();
        short time = in.readShort();
        if (time == -1) {
            this.isUntimed = true;
            start = 0;
            end = 0;
            in.readShort();
        } else {
            this.isUntimed = false;
            start = AbstractRecord.toMinutes((int)time);
            end = AbstractRecord.toMinutes((int)in.readShort());
        }
        this.startDate = AbstractRecord.readDate((DataInputStream)in);
        cal.setTime(this.startDate);
        cal.set(11, start / 60);
        cal.set(12, start % 60);
        this.startDate = cal.getTime();
        this.endDate = new Date(this.startDate.getTime());
        cal.setTime(this.endDate);
        cal.set(11, end / 60);
        cal.set(12, end % 60);
        this.endDate = cal.getTime();
        flags.readData(in);
        in.read();
        if (flags.alarm) {
            this.isAlarmed = true;
            this.alarmAdvanceTime = in.read();
            this.alarmAdvanceUnit = in.read();
        } else {
            this.isAlarmed = false;
            this.alarmAdvanceTime = 0;
            this.alarmAdvanceUnit = 0;
        }
        if (flags.repeat) {
            this.isRepeating = true;
            this.repeatType = in.read();
            in.read();
            this.repeatEndDate = AbstractRecord.readDate((DataInputStream)in);
            this.repeatFrequency = in.read();
            this.repeatOn = in.read();
            this.repeatStartWeek = in.read();
            in.read();
        } else {
            this.repeatType = 0;
            this.repeatEndDate = null;
            this.repeatFrequency = 0;
            this.repeatOn = 0;
            this.repeatStartWeek = 0;
        }
        if (flags.exception) {
            this.exceptionsNum = in.readShort();
            this.dateExceptions = new Vector(this.exceptionsNum);
            int i = 0;
            while (i < this.exceptionsNum) {
                this.dateExceptions.addElement(AbstractRecord.readDate((DataInputStream)in));
                ++i;
            }
        } else {
            this.exceptionsNum = 0;
            this.dateExceptions = new Vector();
        }
        if (flags.description) {
            this.description = AbstractRecord.readCString((DataInputStream)in);
        }
        if (flags.note) {
            this.note = AbstractRecord.readCString((DataInputStream)in);
        }
    }

    public void removeDateException(Date dateException) {
        this.dateExceptions.removeElement(dateException);
    }

    public void removeRepeatOnDay(int day) {
        this.repeatOn &= ~(1 << day);
    }

    public void setAlarmAdvanceTime(int alarmAdvanceTime) {
        this.alarmAdvanceTime = (byte)alarmAdvanceTime;
        this.isAlarmed = true;
    }

    public void setAlarmAdvanceUnit(int alarmAdvanceUnit) {
        this.alarmAdvanceUnit = (byte)alarmAdvanceUnit;
        this.isAlarmed = true;
    }

    public void setApptId(int dtApptId) {
        this.apptId = dtApptId;
    }

    public void setDateExceptions(Vector dateExceptions) {
        this.dateExceptions = dateExceptions;
        if (this.dateExceptions == null) {
            dateExceptions = new Vector();
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setIsAlarmed(boolean isAlarmed) {
        this.isAlarmed = isAlarmed;
    }

    public void setIsRepeating(boolean isRepeating) {
        this.isRepeating = isRepeating;
    }

    public void setIsUntimed(boolean isUntimed) {
        this.isUntimed = isUntimed;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setRepeatEndDate(Date repeatEndDate) {
        this.repeatEndDate = repeatEndDate;
    }

    public void setRepeatFrequency(int repeatFrequency) {
        this.repeatFrequency = repeatFrequency;
    }

    public void setRepeatOn(int[] days) {
        this.repeatOn = 0;
        if (days != null) {
            int count = days.length;
            while (count-- > 0) {
                this.repeatOn |= 1 << days[count];
            }
        }
    }

    public void setRepeatOnDay(int day) {
        int week = this.repeatOn / 7;
        this.repeatOn = week * 7 + day;
    }

    public void setRepeatOnWeek(int week) {
        int day = this.repeatOn % 7;
        this.repeatOn = week * 7 + day;
    }

    public void setRepeatStartWeek(int repeatStartWeek) {
        this.repeatStartWeek = repeatStartWeek;
    }

    public void setRepeatType(int repeatType) {
        this.repeatType = repeatType;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String toFormattedString() {
        int i;
        String repeatOnString = "";
        String exceptions = "";
        switch (this.getRepeatType()) {
            case 2: {
                String[] repeatOnDays = this.getRepeatOnText();
                i = 0;
                while (i < repeatOnDays.length) {
                    repeatOnString = String.valueOf(repeatOnString) + repeatOnDays[i] + " ";
                    ++i;
                }
                break;
            }
            case 3: {
                repeatOnString = String.valueOf(CalendarSyncRecord.getWeekText(this.getRepeatOnWeek())) + " " + CalendarSyncRecord.getDayText(this.getRepeatOnDay());
                break;
            }
            default: {
                repeatOnString = String.valueOf(this.getRepeatType());
            }
        }
        i = 0;
        while (i < this.dateExceptions.size()) {
            exceptions = String.valueOf(exceptions) + "    " + this.dateExceptions.elementAt(i) + "\n";
            ++i;
        }
        return "Date Book record: {\r\n  startDate: " + this.getStartDate() + "\r\n" + "  endDate: " + this.getEndDate() + "\r\n" + "  isUntimed: " + this.getIsUntimed() + "\r\n" + "  isAlarmed: " + this.getIsAlarmed() + "\r\n" + "  alarmAdvanceTime: " + this.getAlarmAdvanceTime() + "\r\n" + "  alarmAdvanceUnit: " + CalendarSyncRecord.getAlarmUnitText(this.getAlarmAdvanceUnit()) + "\r\n" + "  isRepeating: " + this.getIsRepeating() + "\r\n" + "  repeatType: " + CalendarSyncRecord.getRepeatTypeText(this.getRepeatType()) + "\r\n" + "  repeatEndDate: " + this.getRepeatEndDate() + "\r\n" + "  repeatFrequency: " + this.getRepeatFrequency() + "\r\n" + "  repeatOn: " + repeatOnString + "\r\n" + "  repeatStartWeek: " + CalendarSyncRecord.getWeekText(this.getRepeatStartWeek()) + "\r\n" + "  exceptions: \r\n" + exceptions + "  description: " + this.getDescription() + "\r\n" + "  note: " + this.getNote() + "\r\n" + "}\r\n" + super.toFormattedString();
    }

    public String toString() {
        Date theStartDate = this.getStartDate();
        String theSummary = this.getDescription();
        if (theStartDate != null) {
            if (theSummary != null) {
                if (theSummary.length() < 50) {
                    return "Date Book record: " + theStartDate + ", " + theSummary;
                }
                return "Date Book record: " + theStartDate + ", " + theSummary.substring(0, 50) + "...";
            }
            return "Date Book record: " + theStartDate;
        }
        return "Date Book record: " + super.toString();
    }

    public void writeBUData(DataOutputStream out) throws IOException {
        ExtraRecordFlags flags = new ExtraRecordFlags();
        out.writeInt(this.apptId);
        out.writeInt(this.getId());
        flags.priv = this.isPrivate();
        flags.writeData(out);
        this.writeData(out);
    }

    public void writeBUDate(DataOutputStream out, Date buDate) throws IOException {
        out.writeLong(buDate.getTime());
    }

    public void writeCbkData(DataOutputStream out) throws IOException {
        ExtraRecordFlags flags = new ExtraRecordFlags();
        out.writeInt(this.getId());
        flags.priv = this.isPrivate();
        flags.writeData(out);
        this.writeData(out);
    }

    public void writeData(DataOutputStream out) throws IOException {
        ApptDBRecordFlags flags = new ApptDBRecordFlags();
        if (this.isUntimed) {
            out.writeShort(-1);
            out.writeShort(-1);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.startDate);
            int start = cal.get(11) * 60 + cal.get(12);
            cal.setTime(this.endDate);
            int end = cal.get(11) * 60 + cal.get(12);
            out.writeShort(AbstractRecord.fromMinutes((int)start));
            out.writeShort(AbstractRecord.fromMinutes((int)end));
        }
        AbstractRecord.writeDate((DataOutputStream)out, (Date)this.startDate);
        flags.alarm = this.isAlarmed;
        flags.repeat = this.repeatType != 0;
        flags.exception = this.dateExceptions.size() > 0;
        flags.description = this.description != null && !"".equals(this.description);
        flags.note = this.note != null && !"".equals(this.note);
        flags.writeData(out);
        out.write(0);
        if (flags.alarm) {
            out.write(this.alarmAdvanceTime);
            out.write(this.alarmAdvanceUnit);
        }
        if (flags.repeat) {
            out.write(this.repeatType);
            out.write(0);
            AbstractRecord.writeDate((DataOutputStream)out, (Date)this.repeatEndDate);
            out.write(this.repeatFrequency);
            out.write(this.repeatOn);
            out.write(this.repeatStartWeek);
            out.write(0);
        }
        if (flags.exception) {
            out.writeShort(this.dateExceptions.size());
            int i = 0;
            while (i < this.dateExceptions.size()) {
                AbstractRecord.writeDate((DataOutputStream)out, (Date)((Date)this.dateExceptions.elementAt(i)));
                ++i;
            }
        }
        if (flags.description) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)this.description);
        }
        if (flags.note) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)this.note);
        }
    }
}

