/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.management.snmp.SnmpOidRecord;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;

public class SnmpOid
extends SnmpValue {
    protected long[] components = null;
    protected int componentCount = 0;
    static final String name = "Object Identifier";
    private static SnmpOidTable meta = null;
    static final long serialVersionUID = 8956237235607885096L;

    public SnmpOid() {
        this.components = new long[15];
        this.componentCount = 0;
    }

    public SnmpOid(long l) {
        this.components = new long[1];
        this.components[0] = l;
        this.componentCount = this.components.length;
    }

    public SnmpOid(long l, long l2, long l3, long l4) {
        this.components = new long[4];
        this.components[0] = l;
        this.components[1] = l2;
        this.components[2] = l3;
        this.components[3] = l4;
        this.componentCount = this.components.length;
    }

    public SnmpOid(String string) throws IllegalArgumentException {
        String string2 = string;
        if (!string.startsWith(".")) {
            try {
                string2 = this.resolveVarName(string);
            }
            catch (SnmpStatusException snmpStatusException) {
                throw new IllegalArgumentException(snmpStatusException.getMessage());
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".", false);
        this.componentCount = stringTokenizer.countTokens();
        if (this.componentCount == 0) {
            this.components = new long[15];
        } else {
            this.components = new long[this.componentCount];
            try {
                int n = 0;
                while (n < this.componentCount) {
                    try {
                        this.components[n] = Long.parseLong(stringTokenizer.nextToken());
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string);
            }
        }
    }

    public SnmpOid(long[] lArray) {
        this.components = (long[])lArray.clone();
        this.componentCount = this.components.length;
    }

    public void addToOid(String string) throws SnmpStatusException {
        SnmpOid snmpOid = new SnmpOid(string);
        this.append(snmpOid);
    }

    public void addToOid(long[] lArray) throws SnmpStatusException {
        SnmpOid snmpOid = new SnmpOid(lArray);
        this.append(snmpOid);
    }

    public void append(long l) {
        this.enlargeIfNeeded(1);
        this.components[this.componentCount] = l;
        ++this.componentCount;
    }

    public void append(SnmpOid snmpOid) {
        this.enlargeIfNeeded(snmpOid.componentCount);
        int n = 0;
        while (n < snmpOid.componentCount) {
            this.components[this.componentCount + n] = snmpOid.components[n];
            ++n;
        }
        this.componentCount += snmpOid.componentCount;
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        snmpOid2.append(snmpOid.getLength());
        snmpOid2.append(snmpOid);
    }

    public Object clone() {
        try {
            SnmpOid snmpOid = (SnmpOid)super.clone();
            snmpOid.components = new long[this.componentCount];
            System.arraycopy(this.components, 0, snmpOid.components, 0, this.componentCount);
            return snmpOid;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int compareTo(SnmpOid snmpOid) {
        int n = 0;
        int n2 = 0;
        int n3 = Math.min(this.componentCount, snmpOid.componentCount);
        long[] lArray = snmpOid.components;
        n2 = 0;
        while (n2 < n3) {
            if (this.components[n2] != lArray[n2]) break;
            ++n2;
        }
        n = n2 == this.componentCount && n2 == snmpOid.componentCount ? 0 : (n2 == this.componentCount ? -1 : (n2 == snmpOid.componentCount ? 1 : (this.components[n2] < lArray[n2] ? -1 : 1)));
        return n;
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    private void enlargeIfNeeded(int n) {
        int n2 = this.components.length;
        while (this.componentCount + n > n2) {
            n2 *= 2;
        }
        if (n2 > this.components.length) {
            long[] lArray = new long[n2];
            int n3 = 0;
            while (n3 < this.components.length) {
                lArray[n3] = this.components[n3];
                ++n3;
            }
            this.components = lArray;
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SnmpOid) {
            SnmpOid snmpOid = (SnmpOid)object;
            if (snmpOid.componentCount == this.componentCount) {
                int n = 0;
                long[] lArray = snmpOid.components;
                while (n < this.componentCount && this.components[n] == lArray[n]) {
                    ++n;
                }
                bl = n == this.componentCount;
            }
        }
        return bl;
    }

    public int getLength() {
        return this.componentCount;
    }

    public final long getOidArc(int n) throws SnmpStatusException {
        try {
            return this.components[n];
        }
        catch (Exception exception) {
            throw new SnmpStatusException(6);
        }
    }

    public static SnmpOidTable getSnmpOidTable() {
        return meta;
    }

    public String getTypeName() {
        return name;
    }

    private String handleLong(String string, int n) throws NumberFormatException, SnmpStatusException {
        String string2 = n > 0 ? string.substring(0, n) : string;
        Long.parseLong(string2);
        return string;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void insert(int n) {
        this.insert((long)n);
    }

    public void insert(long l) {
        this.enlargeIfNeeded(1);
        int n = this.componentCount - 1;
        while (n >= 0) {
            this.components[n + 1] = this.components[n];
            --n;
        }
        this.components[0] = l;
        ++this.componentCount;
    }

    public boolean isValid() {
        return this.componentCount >= 2 && this.components[0] >= 0L && this.components[0] < 3L && this.components[1] >= 0L && this.components[1] < 40L;
    }

    public long[] longValue() {
        long[] lArray = new long[this.componentCount];
        int n = 0;
        while (n < this.componentCount) {
            lArray[n] = this.components[n];
            ++n;
        }
        return lArray;
    }

    public final long[] longValue(boolean bl) {
        if (bl) {
            return this.longValue();
        }
        return this.components;
    }

    public static int nextOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            int n2;
            if (lArray[n] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            if ((n += (n2 = (int)lArray[n++])) <= lArray.length) {
                return n;
            }
            throw new SnmpStatusException(2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public String resolveVarName(String string) throws SnmpStatusException {
        int n = string.indexOf(46);
        try {
            return this.handleLong(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            if (meta == null) {
                throw new SnmpStatusException(2);
            }
            if (n <= 0) {
                SnmpOidRecord snmpOidRecord = meta.resolveVarName(string);
                return snmpOidRecord.getOid();
            }
            SnmpOidRecord snmpOidRecord = meta.resolveVarName(string.substring(0, n));
            return String.valueOf(snmpOidRecord.getOid()) + string.substring(n);
        }
    }

    public static void setSnmpOidTable(SnmpOidTable snmpOidTable) {
        meta = snmpOidTable;
    }

    public Boolean toBoolean() {
        if (this.componentCount != 1 && this.components[0] != 1L && this.components[0] != 2L) {
            throw new IllegalArgumentException();
        }
        return new Boolean(this.components[0] == 1L);
    }

    public Byte[] toByte() {
        Byte[] byteArray = new Byte[this.componentCount];
        int n = 0;
        while (n < this.componentCount) {
            if (this.components[0] > 255L) {
                throw new IllegalArgumentException();
            }
            byteArray[n] = new Byte((byte)this.components[n]);
            ++n;
        }
        return byteArray;
    }

    public Integer toInteger() {
        if (this.componentCount != 1 || this.components[0] > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return new Integer((int)this.components[0]);
    }

    public Long toLong() {
        if (this.componentCount != 1) {
            throw new IllegalArgumentException();
        }
        return new Long(this.components[0]);
    }

    public String toOctetString() {
        return new String(this.tobyte());
    }

    public SnmpOid toOid() {
        long[] lArray = new long[this.componentCount];
        int n = 0;
        while (n < this.componentCount) {
            lArray[n] = this.components[n];
            ++n;
        }
        return new SnmpOid(lArray);
    }

    public static SnmpOid toOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            if (lArray[n] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            int n2 = (int)lArray[n++];
            long[] lArray2 = new long[n2];
            int n3 = 0;
            while (n3 < n2) {
                lArray2[n3] = lArray[n + n3];
                ++n3;
            }
            return new SnmpOid(lArray2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public String toString() {
        String string = "";
        if (this.componentCount >= 1) {
            int n = 0;
            while (n < this.componentCount - 1) {
                string = String.valueOf(string) + this.components[n] + ".";
                ++n;
            }
            string = String.valueOf(string) + this.components[this.componentCount - 1];
        }
        return string;
    }

    private byte[] tobyte() {
        byte[] byArray = new byte[this.componentCount];
        int n = 0;
        while (n < this.componentCount) {
            if (this.components[0] > 255L) {
                throw new IllegalArgumentException();
            }
            byArray[n] = (byte)this.components[n];
            ++n;
        }
        return byArray;
    }
}

