/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.dhcpconfig;

import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.bridge.TableExistsException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.dhcpconfig.DhcpCfgFunction;
import com.sun.dhcpmgr.cli.dhcpconfig.IPAddressList;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.data.ValidationException;
import java.net.InetAddress;
import java.util.Vector;

public class ConfigureDhcp
extends DhcpCfgFunction {
    static final int[] supportedOptions = new int[]{110, 104, 121, 108, 97, 100, 114, 117, 112};

    public ConfigureDhcp() {
        this.validOptions = supportedOptions;
    }

    public int execute() throws IllegalArgumentException {
        Object[] objectArray;
        String string;
        Object[] objectArray2;
        boolean bl = false;
        boolean bl2 = false;
        try {
            objectArray2 = DhcpCliFunction.getSvcMgr().readDefaults();
            if (objectArray2.isRelay()) {
                bl2 = true;
            } else {
                bl = true;
            }
        }
        catch (Throwable throwable) {}
        if (bl) {
            this.printErrMessage(this.getString("config_dhcp_configured_error"));
            return -1;
        }
        if (bl2) {
            this.printErrMessage(this.getString("config_bootp_configured_error"));
            return -1;
        }
        if (this.options.valueOf(114) == null || this.options.valueOf(112) == null) {
            objectArray2 = this.getString("config_null_datastore_error");
            throw new IllegalArgumentException((String)objectArray2);
        }
        try {
            this.setDhcpDatastore(DhcpCliFunction.getSvcMgr().getDataStore(this.options.valueOf(114)));
            this.getDhcpDatastore().setLocation(this.options.valueOf(112));
            this.getDhcpDatastore().setConfig(this.options.valueOf(117));
        }
        catch (Throwable throwable) {}
        if (this.getDhcpDatastore() == null || !this.getDhcpDatastore().isEnabled()) {
            objectArray2 = new Object[]{this.getDhcpDatastore().getResource()};
            this.printErrMessage(this.getString("config_invalid_resource_error"), objectArray2);
            return -1;
        }
        objectArray2 = this.options.valueOf(104);
        String string2 = this.options.valueOf(121);
        if (objectArray2 == null) {
            if (string2 != null) {
                String string3 = this.getString("config_requires_hosts_resource_error");
                throw new IllegalArgumentException(string3);
            }
        } else if (objectArray2.equals("nisplus") || objectArray2.equals("dns")) {
            if (string2 == null) {
                Object[] objectArray3 = new Object[]{objectArray2};
                this.printErrMessage(this.getString("config_requires_hosts_domain_error"), objectArray3);
                return -1;
            }
        } else if (objectArray2.equals("files")) {
            if (string2 != null) {
                Object[] objectArray4 = new Object[]{objectArray2};
                this.printErrMessage(this.getString("config_hosts_domain_ignored_error"), objectArray4);
                return -1;
            }
        } else {
            Object[] objectArray5 = new Object[]{objectArray2};
            this.printErrMessage(this.getString("config_invalid_hosts_resource_error"), objectArray5);
            return -1;
        }
        Integer n = new Integer(86400);
        if (this.options.isSet(108)) {
            try {
                n = new Integer(this.options.valueOf(108));
            }
            catch (Throwable throwable) {
                this.printErrMessage(this.getString("config_lease_error"));
                return -1;
            }
            if (n == 0) {
                this.printErrMessage(this.getString("config_lease_zero_error"));
                return -1;
            }
        }
        boolean bl3 = this.options.isSet(110) ^ true;
        String string4 = this.options.valueOf(100);
        if (string4 == null != ((string = this.options.valueOf(97)) == null)) {
            String string5 = this.getString("config_dns_error");
            throw new IllegalArgumentException(string5);
        }
        IPAddressList iPAddressList = null;
        try {
            if (string4 == null) {
                string4 = DhcpCliFunction.getSvcMgr().getStringOption("DNSdmain", "");
            }
            iPAddressList = string != null ? new IPAddressList(string) : new IPAddressList(DhcpCliFunction.getSvcMgr().getIPOption("DNSserv", ""));
        }
        catch (ValidationException validationException) {
            Object[] objectArray6 = new Object[]{DhcpCliFunction.getMessage(validationException)};
            this.printErrMessage(this.getString("config_dns_server_error"), objectArray6);
            return -1;
        }
        catch (Throwable throwable) {}
        try {
            DhcpCliFunction.getSvcMgr().makeLocation(this.getDhcpDatastore());
        }
        catch (ExistsException existsException) {
        }
        catch (Throwable throwable) {
            Object[] objectArray7 = new Object[]{this.getDhcpDatastore().getLocation()};
            this.printErrMessage(this.getString("config_make_location_error"), objectArray7);
            return -1;
        }
        DhcpdOptions dhcpdOptions = new DhcpdOptions();
        dhcpdOptions.setDaemonEnabled(true);
        dhcpdOptions.setDhcpDatastore(this.getDhcpDatastore());
        if (objectArray2 != null) {
            dhcpdOptions.setHostsResource((String)objectArray2);
        }
        if (string2 != null) {
            dhcpdOptions.setHostsDomain(string2);
        }
        try {
            DhcpCliFunction.getSvcMgr().writeDefaults(dhcpdOptions);
            this.printMessage(this.getString("config_create_conf_progress"));
        }
        catch (Throwable throwable) {
            Object[] objectArray8 = new Object[]{DhcpCliFunction.getMessage(throwable)};
            this.printErrMessage(this.getString("config_writing_conf_error"), objectArray8);
            return -1;
        }
        try {
            DhcpCliFunction.getDhcptabMgr().createDhcptab(this.getDhcpDatastore());
            this.printMessage(this.getString("config_dhcptab_progress"));
        }
        catch (TableExistsException tableExistsException) {
            this.printMessage(this.getString("config_dhcptab_exists_progress"));
        }
        catch (Throwable throwable) {
            Object[] objectArray9 = new Object[]{DhcpCliFunction.getMessage(throwable)};
            this.printErrMessage(this.getString("config_dhcptab_error"), objectArray9);
            return -1;
        }
        try {
            DhcpCliFunction.getDhcptabMgr().createLocaleMacro();
            this.printMessage(this.getString("config_locale_progress"));
        }
        catch (ExistsException existsException) {
        }
        catch (Throwable throwable) {
            Object[] objectArray10 = new Object[]{DhcpCliFunction.getMessage(throwable)};
            this.printErrMessage(this.getString("config_locale_error"), objectArray10);
            return -1;
        }
        String string6 = null;
        try {
            string6 = DhcpCliFunction.getSvcMgr().getShortServerName();
            InetAddress inetAddress = DhcpCliFunction.getSvcMgr().getServerAddress();
            DhcpCliFunction.getDhcptabMgr().createServerMacro(string6, inetAddress, n.intValue(), bl3, string4, (Vector)iPAddressList);
            objectArray = new Object[]{string6};
            this.printMessage(this.getString("config_server_macro_progress"), objectArray);
        }
        catch (Throwable throwable) {
            Object[] objectArray11 = new Object[2];
            objectArray11[1] = string6;
            objectArray11[0] = DhcpCliFunction.getMessage(throwable);
            this.printErrMessage(this.getString("config_server_macro_error"), objectArray11);
            return -1;
        }
        try {
            DhcpCliFunction.getSvcMgr().startup();
            this.printMessage(this.getString("config_startup_progress"));
        }
        catch (Throwable throwable) {
            objectArray = new Object[]{DhcpCliFunction.getMessage(throwable)};
            this.printErrMessage(this.getString("config_startup_error"), objectArray);
            return -1;
        }
        return 0;
    }
}

