/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.Container;
import com.sun.web.core.HttpServletRequestFacade;
import com.sun.web.core.HttpServletResponseFacade;
import com.sun.web.core.ServletConfigImpl;
import com.sun.web.util.StringManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;

class ServletWrapper {
    private StringManager sm = StringManager.getManager("com.sun.web.core");
    private Container container;
    private Class servletClass;
    private String servletClassName;
    private Servlet servlet;
    private long lastAccessed;
    private ServletConfigImpl config;
    private boolean isReloadable = false;
    private File servletClassFile;
    private long classFileLastMod = 0L;

    ServletWrapper(Container container) {
        this.container = container;
        this.config = new ServletConfigImpl(container.getContext());
    }

    void destroy() {
        if (this.servlet != null) {
            this.servlet.destroy();
        }
    }

    void handleRequest(HttpServletRequestFacade httpServletRequestFacade, HttpServletResponseFacade httpServletResponseFacade) throws IOException {
        block15: {
            Object object = this;
            synchronized (object) {
                if (this.servlet == null) {
                    try {
                        this.loadServlet();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        httpServletResponseFacade.sendError(404);
                        Object var4_6 = null;
                        return;
                    }
                    catch (Exception exception) {
                        this.sendInternalServletError(exception, httpServletResponseFacade);
                        Object var4_7 = null;
                        return;
                    }
                }
            }
            try {
                if (this.servlet instanceof SingleThreadModel) {
                    object = this.servlet;
                    synchronized (object) {
                        this.servlet.service(httpServletRequestFacade, httpServletResponseFacade);
                        break block15;
                    }
                }
                this.servlet.service(httpServletRequestFacade, httpServletResponseFacade);
            }
            catch (ServletException servletException) {
                this.sendInternalServletError(servletException, httpServletResponseFacade);
                return;
            }
            catch (SocketException socketException) {
                return;
            }
            catch (Throwable throwable) {
                this.sendInternalServletError(throwable, httpServletResponseFacade);
                return;
            }
        }
    }

    private void loadServlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ServletException {
        if (this.servletClass == null) {
            if (this.servletClassName == null) {
                String string = this.sm.getString("wrapper.load.noclassname");
                throw new IllegalStateException(string);
            }
            this.servletClass = this.container.getLoader().loadServlet(this, this.servletClassName);
        }
        this.servlet = (Servlet)this.servletClass.newInstance();
        this.servlet.init(this.config);
    }

    void printRootCause(ServletException servletException, PrintWriter printWriter) {
        Throwable throwable = servletException.getRootCause();
        if (throwable != null) {
            printWriter.println("<b>Root cause:</b>");
            printWriter.println("<pre>");
            throwable.printStackTrace(printWriter);
            printWriter.println("</pre>");
            if (throwable instanceof ServletException) {
                this.printRootCause((ServletException)throwable, printWriter);
            }
        }
    }

    void sendInternalServletError(Throwable throwable, HttpServletResponseFacade httpServletResponseFacade) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<b>Internal Servlet Error:</b><br>");
        printWriter.println("<pre>");
        throwable.printStackTrace(printWriter);
        printWriter.println("</pre>");
        if (throwable instanceof ServletException) {
            this.printRootCause((ServletException)throwable, printWriter);
        }
        httpServletResponseFacade.sendError(500, stringWriter.toString());
    }

    void setInitArgs(Hashtable hashtable) {
        this.config.setInitArgs(hashtable);
    }

    void setReloadable(boolean bl) {
        this.isReloadable = bl;
    }

    void setServletClass(Class clazz) {
        this.servletClass = clazz;
    }

    void setServletClass(String string) {
        this.servletClassName = string;
    }

    void setServletClassFile(File file) {
        this.servletClassFile = file;
        this.classFileLastMod = file.lastModified();
    }
}

