/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.shell;

import com.sun.web.core.Context;
import com.sun.web.server.HttpServer;
import com.sun.web.server.HttpServerException;
import com.sun.web.shell.AdminImpl;
import com.sun.web.shell.StartupException;
import com.sun.web.util.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class Startup {
    private static final String CONFIG_FILE = "default.cfg";
    private URL configURL;
    private StringManager sm = StringManager.getManager("com.sun.web.shell");
    private String[] args;
    private Properties props = new Properties();
    private boolean useconfig = true;
    private HttpServer server;
    private int port;
    private String hostname;
    private InetAddress inet;

    public Startup(String[] stringArray) throws StartupException {
        this.args = stringArray;
        System.out.println(this.sm.getString("startup.startup.banner"));
        if (this.isArg("-help")) {
            System.out.println(this.sm.getString("startup.startup.help"));
            return;
        }
        if (this.isArg("-noconfig")) {
            this.useconfig = false;
        } else {
            this.loadProps();
        }
        this.determinePort();
        this.determineHostname();
        this.determineInet();
        this.server = new HttpServer(this.port, this.inet, this.hostname);
        String string = this.props.getProperty("server.tempdir");
        if (string != null) {
            this.server.setTempDir(new File(string));
        }
        try {
            Registry registry = LocateRegistry.createRegistry(1109);
            AdminImpl adminImpl = new AdminImpl(this.server);
            registry.bind("admin", adminImpl);
        }
        catch (Exception exception) {
            System.out.println("Can't set up server admin");
            System.out.println(exception.toString());
            System.exit(1);
        }
        this.setDocumentBase();
        this.configureApps();
        try {
            this.server.start();
        }
        catch (HttpServerException httpServerException) {
            System.out.println(httpServerException.getMessage());
        }
    }

    private void configureApps() throws StartupException {
        Vector vector = this.getAppList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            String string2 = this.props.getProperty("server.webapp." + string + ".mapping");
            String string3 = this.props.getProperty("server.webapp." + string + ".docbase");
            if (string2 == null) {
                object = this.sm.getString("startup.configapp.nomapping", string);
                throw new StartupException((String)object);
            }
            if (string3 == null) {
                object = this.sm.getString("starutp.configapp.nodocbase", string);
                throw new StartupException((String)object);
            }
            if (!string3.endsWith("/")) {
                string3 = String.valueOf(string3) + "/";
            }
            object = this.server.createContext(string, string2);
            URL uRL = null;
            try {
                uRL = this.resolveConfigURL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                String string4 = this.sm.getString("startup.configapp.mue", string3);
                throw new StartupException(string4);
            }
            ((Context)object).setDocumentBase(uRL);
            ((Context)object).init();
        }
    }

    private void determineHostname() {
        this.hostname = this.getArg("-hostname");
        if (this.hostname == null && this.useconfig) {
            this.hostname = this.props.getProperty("server.hostname");
        }
    }

    private void determineInet() throws StartupException {
        String string = this.getArg("-inet");
        if (string != null) {
            try {
                this.inet = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                String string2 = this.sm.getString("startup.setinet.uhe1", string);
                throw new StartupException(string2);
            }
        }
        if (this.useconfig) {
            try {
                string = this.props.getProperty("server.inet");
                if (string.length() > 0) {
                    this.inet = InetAddress.getByName(string);
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = this.sm.getString("startup.setinet.uhe2", string);
                throw new StartupException(string3);
            }
        }
    }

    private void determinePort() throws StartupException {
        String string = this.getArg("-port");
        if (string != null) {
            try {
                this.port = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = this.sm.getString("startup.setport.nfe1", string);
                throw new StartupException(string2);
            }
        } else if (this.useconfig) {
            try {
                string = this.props.getProperty("server.port");
                this.port = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = this.sm.getString("startup.setport.nfe2", string);
                throw new StartupException(string3);
            }
            catch (NullPointerException nullPointerException) {
                String string4 = this.sm.getString("startup.setport.npe");
                throw new StartupException(string4);
            }
        } else {
            String string5 = this.sm.getString("startup.setport.noport");
            throw new StartupException(string5);
        }
    }

    private Vector getAppList() {
        Vector<String> vector = new Vector<String>();
        String string = "server.webapp";
        int n = string.length() + 1;
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            try {
                String string3 = string2.substring(n, string2.indexOf(46, n));
                if (vector.contains(string3)) continue;
                vector.addElement(string3);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return vector;
    }

    private String getArg(String string) {
        int n = 0;
        while (n < this.args.length) {
            String string2 = this.args[n];
            if (string2.equals(string)) {
                try {
                    String string3 = this.args[n + 1];
                    return string3;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    private boolean isArg(String string) {
        int n = 0;
        while (n < this.args.length) {
            String string2 = this.args[n];
            if (string2.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void loadProps() throws StartupException {
        Object object;
        Object object2;
        String string = this.getArg("-config");
        if (string == null && !((File)(object2 = new File(string = CONFIG_FILE))).exists()) {
            try {
                object = this.getClass().getResourceAsStream(CONFIG_FILE);
                FileOutputStream fileOutputStream = new FileOutputStream(CONFIG_FILE);
                byte[] byArray = new byte[1024];
                int n = 0;
                do {
                    fileOutputStream.write(byArray, 0, n);
                } while ((n = ((InputStream)object).read(byArray, 0, 1024)) > -1);
                ((InputStream)object).close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new StartupException("massive internal error " + iOException);
            }
        }
        try {
            this.configURL = this.resolveURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            object2 = this.sm.getString("startup.loadprops.mue", string);
            throw new StartupException((String)object2);
        }
        try {
            object2 = this.configURL.openConnection();
            ((URLConnection)object2).connect();
            object = ((URLConnection)object2).getInputStream();
            this.props.load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            object = this.sm.getString("startup.loadprops.ioe", iOException);
            throw new StartupException((String)object);
        }
        object2 = this.sm.getString("startup.loadprops.msg", this.configURL);
        System.out.println((String)object2);
    }

    public static void main(String[] stringArray) {
        try {
            new Startup(stringArray);
        }
        catch (StartupException startupException) {
            System.out.println(startupException.getMessage());
        }
    }

    private URL resolveConfigURL(String string) throws MalformedURLException {
        if (string.indexOf(":/") > -1) {
            return new URL(string);
        }
        if (this.configURL != null) {
            URL uRL = new URL(this.configURL, string);
            return uRL;
        }
        return this.resolveURL(string);
    }

    private URL resolveURL(String string) throws MalformedURLException {
        if (string.indexOf(":/") > -1) {
            return new URL(string);
        }
        if (string.startsWith("/")) {
            return new URL("file", null, string);
        }
        String string2 = System.getProperty("user.dir");
        return new URL("file", null, String.valueOf(string2) + "/" + string);
    }

    private void setDocumentBase() throws StartupException {
        String string = this.getArg("-docbase");
        if (string != null) {
            try {
                URL uRL = this.resolveURL(string);
                this.server.setDocumentBase(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = this.sm.getString("startup.setdocbase.mue1", string);
                throw new StartupException(string2);
            }
        } else if (this.useconfig) {
            try {
                string = this.props.getProperty("server.docbase");
                URL uRL = this.resolveConfigURL(string);
                this.server.setDocumentBase(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                String string3 = this.sm.getString("startup.setdocbase.mue2", string);
                throw new StartupException(string3);
            }
            catch (NullPointerException nullPointerException) {
                String string4 = this.sm.getString("startup.setdocbase.npe");
                throw new StartupException(string4);
            }
        } else {
            String string5 = this.sm.getString("startup.setdocbase.nodocbase");
            throw new StartupException(string5);
        }
    }
}

