/*
 * Copyright 1993-2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_BSM_AUDIT_UEVENTS_H
#define	_BSM_AUDIT_UEVENTS_H

#pragma ident	"@(#)audit_uevents.h	1.7	03/04/11 SMI"

/*
 * User level audit event numbers.
 *
 *     0		Reserved as an invalid event number.
 *     1 - 2047		Reserved for the Solaris Kernel events.
 *  2048 - 32767	Reserved for the Solaris TCB programs.
 * 32768 - 65535	Available for third party TCB applications.
 *
 */

#ifdef	__cplusplus
extern "C" {
#endif

#define	AUE_at_create		6144	/* =ua at-create atjob */
#define	AUE_at_delete		6145	/* =ua at-delete atjob (at or atrm) */
#define	AUE_at_perm		6146	/* =no at-permission */
#define	AUE_cron_invoke		6147	/* =ua cron-invoke */
#define	AUE_crontab_create	6148	/* =ua crontab-crontab created */
#define	AUE_crontab_delete	6149	/* =ua crontab-crontab deleted */
#define	AUE_crontab_perm	6150	/* =no crontab-persmisson */
#define	AUE_inetd_connect	6151	/* =na inetd */
#define	AUE_login		6152	/* =lo login - local */
#define	AUE_logout		6153	/* =lo logout */
#define	AUE_telnet		6154	/* =lo login - telnet */
#define	AUE_rlogin		6155	/* =lo login - rlogin */
#define	AUE_mountd_mount	6156	/* =na mount */
#define	AUE_mountd_umount	6157	/* =na unmount */
#define	AUE_rshd		6158	/* =lo rsh access */
#define	AUE_su			6159	/* =lo su */
#define	AUE_halt_solaris	6160	/* =ss halt(1m) */
#define	AUE_reboot_solaris	6161	/* =ss reboot(1m) */
#define	AUE_rexecd		6162	/* =lo rexecd */
#define	AUE_passwd		6163	/* =lo passwd */
#define	AUE_rexd		6164	/* =lo rexd */
#define	AUE_ftpd		6165	/* =lo ftp access */
#define	AUE_init_solaris	6166	/* =ss init(1m) */
#define	AUE_uadmin_solaris	6167	/* =ss uadmin(1m) */
#define	AUE_shutdown_solaris	6168	/* =ss shutdown(1b) */
#define	AUE_poweroff_solaris	6169	/* =ss poweroff(1m) */
#define	AUE_crontab_mod		6170	/* =ua crontab-modify */
#define	AUE_ftpd_logout		6171	/* =lo ftp logout */
#define	AUE_prof_cmd		6180	/* =ua,as profile command */
#define	AUE_allocate_succ	6200	/* =ot allocate-device success */
#define	AUE_allocate_fail	6201	/* =ot allocate-device failure */
#define	AUE_deallocate_succ	6202	/* =ot deallocate-device success */
#define	AUE_deallocate_fail	6203	/* =ot deallocate-device failure */
#define	AUE_listdevice_succ	6205	/* =ot allocate-list devices success */
#define	AUE_listdevice_fail	6206	/* =ot allocate-list devices failure */
#define	AUE_create_user		6207	/* =ua create user */
#define	AUE_modify_user		6208	/* =ua modify user */
#define	AUE_delete_user		6209	/* =ua delete user */
#define	AUE_disable_user	6210	/* =ua disable user */
#define	AUE_enable_user		6211	/* =ua enable user */
#define	AUE_admin_authenticate	6213	/* =lo admin login */

#ifdef	__cplusplus
}
#endif

#endif	/* _BSM_AUDIT_UEVENTS_H */
