/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.SunOSRmtT4InstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.TelnetSession;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public abstract class SunOSRmtT4DiskDriveInstallerPrtl
extends SunOSRmtT4InstallerPrtl {
    private static final String PASSWORD_FILE_SUFFIX = "pw";
    protected PatchProProperties properties = null;
    private String diskDriveImage = null;
    private String diskFruModel = null;
    private String diskFruVersion = null;

    public SunOSRmtT4DiskDriveInstallerPrtl(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.properties = patchProProperties;
    }

    protected void getDiskDriveFirmwareImages(File file) throws InteractiveSessionException {
        Properties properties = null;
        SoftwarePackage softwarePackage = this.installFirmwarePackage(file);
        properties = softwarePackage.getPkginfo();
        this.manipulator.getHost().addSoftwarePackage(softwarePackage);
        this.setDiskDriveImage(properties.getProperty("SUNW_DISKDRIVE_NAME", null));
        this.setDiskFruModel(properties.getProperty("SUNW_DISK_MODEL", null));
        this.setDiskFruVersion(properties.getProperty("SUNW_DISK_VERSION", null));
    }

    protected Vector getListOfDiskDrives() {
        Enumeration enumeration = null;
        HardwareComponent hardwareComponent = null;
        Vector<String> vector = new Vector<String>();
        enumeration = this.manipulator.getTargetHardware();
        while (enumeration.hasMoreElements()) {
            hardwareComponent = (HardwareComponent)enumeration.nextElement();
            vector.addElement(hardwareComponent.getLocator());
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void applyDiskDriveFirmwareImage(String string) throws InteractiveSessionException {
        String string2 = null;
        String string3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        int n = 0;
        boolean bl = false;
        if (this.getDiskDriveImage() == null) return;
        TelnetSession telnetSession = null;
        try {
            try {
                string2 = this.properties.getProperty("patchpro.userid", "root");
                n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadfw.diskdrive.limit", "600")));
                string3 = this.getPassword(string);
                telnetSession = new TelnetSession();
                telnetSession.connect(string, string2, string3);
                Vector vector = this.getListOfDiskDrives();
                if (vector.size() != 0) {
                    telnetSession.send("cd /\r", 1000);
                    if (!telnetSession.expectedResponse("ls\r", this.getDiskDriveImage(), 5000)) {
                        this.log.println(this, 2, "The disk drive image \"" + this.getDiskDriveImage() + "\" that was uploaded is " + "not present on the storage array.");
                        throw new Exception(this.getDiskDriveImage() + " image was not found." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        if (!telnetSession.expectedResponse("disk download " + vector.elementAt(n2) + " " + this.getDiskDriveImage() + "\r", "pass", n) && telnetSession.getAllSessionMessages().indexOf("fail") != -1) {
                            telnetSession.send("disk version " + vector.elementAt(n2), 10000);
                            if (telnetSession.getSessionMessages().indexOf(this.getDiskFruModel()) == -1 || telnetSession.getSessionMessages().indexOf(this.getDiskFruVersion()) == -1) {
                                this.log.println(this, 2, "Unable to download " + this.getDiskDriveImage() + " image to " + vector.elementAt(n2));
                                throw new Exception(this.getDiskDriveImage() + " image could not be downloaded");
                            }
                        }
                        ++n2;
                    }
                } else {
                    System.out.println("Unable to download firmware to drives ...");
                    if (telnetSession == null) throw new Exception("There should have been at least one drive to update");
                    telnetSession.disconnect();
                    telnetSession = null;
                    throw new Exception("There should have been at least one drive to update");
                }
                telnetSession.disconnect();
                return;
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                throw new InteractiveSessionException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (telnetSession == null) throw throwable;
            telnetSession.disconnect();
            throw throwable;
        }
    }

    protected void setDiskDriveImage(String string) {
        this.diskDriveImage = string;
    }

    protected void setDiskFruModel(String string) {
        this.diskFruModel = string;
    }

    protected void setDiskFruVersion(String string) {
        this.diskFruVersion = string;
    }

    protected String getDiskDriveImage() {
        return this.diskDriveImage;
    }

    protected String getDiskFruModel() {
        return this.diskFruModel;
    }

    protected String getDiskFruVersion() {
        return this.diskFruVersion;
    }
}

