/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.mail.ErrorSendingEmailException;
import com.sun.patchpro.mail.MailerImpl;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.util.LocalizedMessages;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;

public final class StatusEMail {
    protected PatchProLog log;
    private LocalizedMessages msgcat;
    private PatchProProperties properties;
    protected String[] ccList = new String[]{""};
    private String EMAIL_ERROR_RECIPIENT = "patchpro.error.email";
    private String EMAIL_DOWNLOAD_RECIPIENT = "patchpro.download.email";
    private String EMAIL_INSTALL_RECIPIENT = "patchpro.install.email";
    private String EMAIL_ERROR_SUBJECT;
    private String EMAIL_HOST_TITLE;
    private String EMAIL_DESCRIPTION_MSG01;
    private String EMAIL_DESCRIPTION_MSG02;
    private String EMAIL_DESCRIPTION_MSG09;
    private String EMAIL_DESCRIPTION_MSG10;
    private String EMAIL_DESCRIPTION_MSG11;
    private String EMAIL_DESCRIPTION_MSG12;
    private String EMAIL_DESCRIPTION_MSG13;
    private String EMAIL_DESCRIPTION_NONE;
    private String EMAIL_INTRO_UNAVAILABLE;
    private String EMAIL_EXPLANATION_UNAVAILABLE;
    private String EMAIL_INTRO_CORRUPT_DOWNLOAD;
    private String EMAIL_EXPLANATION_CORRUPT_DOWNLOAD;
    private String EMAIL_INTRO_DOWNLOADED;
    private String EMAIL_INTRO_CORRUPT_INSTALL;
    private String EMAIL_EXPLANATION_CORRUPT_INSTALL;
    private String EMAIL_INTRO_BAD_PROPERTIES;
    private String EMAIL_EXPLANATION_BAD_PROPERTIES;
    private String EMAIL_INTRO_FAILING_INSTALL;
    private String EMAIL_EXPLANATION_FAILING_INSTALL;
    private String EMAIL_INTRO_INSTALLED;
    private String EMAIL_INTRO_SEQUESTERED;
    private String EMAIL_EXPLANATION_SEQUESTERED;
    private String EMAIL_EXPLANATION_SEQUESTEREDBAD;
    private String EMAIL_INTRO_DEFERRED;
    private String EMAIL_EXPLANATION_DEFERRED;
    private ReadOnlyHost host;
    protected Locale locale;
    private MailerImpl mailerImpl;

    public StatusEMail(ReadOnlyHost readOnlyHost) {
        this.host = readOnlyHost;
        this.properties = readOnlyHost.getSessionData().getProperties();
        this.log = PatchProLog.getInstance();
        try {
            this.mailerImpl = new MailerImpl();
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.EMAIL_ERROR_SUBJECT = this.msgcat.getMessage("email.error.subject", "PatchPro Notice");
        this.EMAIL_HOST_TITLE = this.msgcat.getMessage("email.host_title", "\n\nFor system ");
        this.EMAIL_DESCRIPTION_MSG01 = this.msgcat.getMessage("email.description_msg01", "System is up-to-date. No changes were required.");
        this.EMAIL_DESCRIPTION_MSG02 = this.msgcat.getMessage("email.description_msg02", "PatchPro completed successfully.");
        this.EMAIL_DESCRIPTION_MSG09 = this.msgcat.getMessage("email.description_msg09", "Thank you,");
        this.EMAIL_DESCRIPTION_MSG10 = this.msgcat.getMessage("email.description_msg10", "PatchPro 2.2");
        this.EMAIL_DESCRIPTION_MSG11 = this.msgcat.getMessage("email.description_msg11", "Errors:");
        this.EMAIL_DESCRIPTION_MSG12 = this.msgcat.getMessage("email.description_msg12", "Problem: ");
        this.EMAIL_DESCRIPTION_MSG13 = this.msgcat.getMessage("email.description_msg13", "Remedy: ");
        this.EMAIL_DESCRIPTION_NONE = this.msgcat.getMessage("email.description_none", "None.");
        this.EMAIL_INTRO_UNAVAILABLE = this.msgcat.getMessage("email.intro.unavailable", "Number of patches not available for download: ");
        this.EMAIL_EXPLANATION_UNAVAILABLE = this.msgcat.getMessage("email.explanation.unavailable", "These patches were not available from the patch server. If that server is on a corporate LAN then it may not be configured to download patches for this kind of system. If that server is at Sun or another external patch provider, please send this list to that provider.");
        this.EMAIL_INTRO_CORRUPT_DOWNLOAD = this.msgcat.getMessage("email.intro.corrupt.download", "Number of patches failing authentication on download: ");
        this.EMAIL_EXPLANATION_CORRUPT_DOWNLOAD = this.msgcat.getMessage("email.explanation.corrupt.download", "These patches were available from the patch server but while downloading were found to be corrupt. These patches are not on your filesystem because they might have been tampered with and might contain a virus.");
        this.EMAIL_INTRO_DOWNLOADED = this.msgcat.getMessage("email.intro.downloaded", "Number of patches downloaded: ");
        this.EMAIL_INTRO_CORRUPT_INSTALL = this.msgcat.getMessage("email.intro.corrupt.install", "Number of patches failing authentication on install: ");
        this.EMAIL_EXPLANATION_CORRUPT_INSTALL = this.msgcat.getMessage("email.explanation.corrupt.install", "These patches are present on the filesystem but they are corrupt. The patches have not been deleted so they should be reviewed carefully. Either the filesystem is corrupt or the patch has been tampered with.");
        this.EMAIL_INTRO_BAD_PROPERTIES = this.msgcat.getMessage("email.intro.bad.properties", "Number of patches that could not be installed due to unexpected properties: ");
        this.EMAIL_EXPLANATION_BAD_PROPERTIES = this.msgcat.getMessage("email.explanation.bad.properties", "Do not install these patches. They represent limited distribution patches that should not have been in the database. Contact your Sun technical representative with this list.");
        this.EMAIL_INTRO_FAILING_INSTALL = this.msgcat.getMessage("email.intro.failing.install", "Number of patches that failed to install due to errors:");
        this.EMAIL_EXPLANATION_FAILING_INSTALL = this.msgcat.getMessage("email.explanation.failing.install", "An attempt was made to automatically install these patches but an error occurred during installation. This could be caused by filesystem space exhaustion, a corrupted filesystem or a corrupt installed package.");
        this.EMAIL_INTRO_INSTALLED = this.msgcat.getMessage("email.intro.installed", "Number of patches installed:");
        this.EMAIL_INTRO_SEQUESTERED = this.msgcat.getMessage("email.intro.sequestered", "Number of patches sequestered:");
        this.EMAIL_EXPLANATION_SEQUESTERED = this.msgcat.getMessage("email.explanation.sequesteredBad", "Install these patches from the sequester directory at your earliest convenience. Remember that the jar command clears all execute bits. We are working on this issue. You will need to execute the chmod u+x * command in the top-level patch directory before installing the patch with the patchadd command. ");
        this.EMAIL_EXPLANATION_SEQUESTEREDBAD = this.msgcat.getMessage("email.explanation.sequestered", "Install or delete these special patches from the sequester directory at your earliest convenience. Some of these patches are listed above  as risky. Look over the README for those patches very carefully and delete them if they are not appropriate. Remember that the jar command clears all execute bits. We are working on this issue. You will need to execute the chmod u+x * command in the top-level patch directory before installing the patch with the patchadd command. ");
        this.EMAIL_INTRO_DEFERRED = this.msgcat.getMessage("email.intro.deferred", "Number of patches deferred:");
        this.EMAIL_EXPLANATION_DEFERRED = this.msgcat.getMessage("email.explanation.deferred", "You may install these patches manually but if you do not, they will be installed through automation at the next scheduled reboot.");
    }

    private void addHostTitle(StringBuffer stringBuffer, ReadOnlyHost readOnlyHost) {
        stringBuffer.append(this.EMAIL_HOST_TITLE + "  " + readOnlyHost.getHostName() + " (" + readOnlyHost.getAddress() + ")\n\n");
    }

    public void sendInstallStatusEMail() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ReadOnlyHost readOnlyHost = null;
        Object var8_7 = null;
        Enumeration enumeration = null;
        Object var12_9 = null;
        Patch patch = null;
        String string = "";
        String string2 = "Failed to validate the digital signature(s).";
        String string3 = "Patch requirement for this patch is not met. ";
        String string4 = "Patch is already present.";
        String string5 = "Not allowed to apply patches as non-root user.";
        String string6 = "Not able to access /usr/sbin/pkgadd.";
        String string7 = "Not enough file system space for patch installation.";
        String string8 = "Failed to install a patch.";
        StringBuffer stringBuffer2 = new StringBuffer();
        readOnlyHost = this.host;
        enumeration = readOnlyHost.getAssociates();
        do {
            SessionData sessionData;
            if (!bl) {
                readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
            }
            if (!(sessionData = readOnlyHost.getSessionData()).getIgnoreStatus()) {
                int n;
                this.addHostTitle(stringBuffer2, readOnlyHost);
                object = sessionData.getPatchProExceptions().iterator();
                if (object.hasNext()) {
                    stringBuffer2.append(this.EMAIL_DESCRIPTION_MSG11).append("\n");
                    while (object.hasNext()) {
                        Throwable throwable = (Throwable)object.next();
                        stringBuffer2.append("\n");
                        stringBuffer2.append(this.EMAIL_DESCRIPTION_MSG12);
                        stringBuffer2.append(throwable.getLocalizedMessage());
                        stringBuffer2.append("\n");
                        if (!(throwable instanceof PatchProException)) continue;
                        stringBuffer2.append(this.EMAIL_DESCRIPTION_MSG13);
                        stringBuffer2.append(((PatchProException)throwable).getLocalizedRemedy());
                        stringBuffer2.append("\n");
                    }
                } else {
                    stringBuffer2.append(this.EMAIL_DESCRIPTION_MSG02);
                    stringBuffer2.append("\n");
                }
                PatchList patchList = sessionData.getPatchesRequired();
                if (patchList.size() == 0) {
                    stringBuffer2.append(this.EMAIL_DESCRIPTION_MSG01).append("\n");
                }
                if ((n = (patchList = sessionData.getPatchesUnavailable()).size()) != 0) {
                    this.log.println(this, 7, "Number of patches not on server = " + n);
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_UNAVAILABLE).append(" ").append(n).append("\n");
                    int n2 = 0;
                    while (n2 < n) {
                        block50: {
                            try {
                                patch = patchList.getPatchAt(n2);
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                this.log.printStackTrace(this, 2, noSuchPatchException);
                                break block50;
                            }
                            string = patch.getPatchID().getPatchID();
                            stringBuffer2.append(string).append(" ");
                        }
                        ++n2;
                    }
                    stringBuffer2.append("\n\n").append(this.EMAIL_EXPLANATION_UNAVAILABLE).append("\n");
                }
                if ((n = (patchList = sessionData.getPatchesCorruptOnDownload()).size()) != 0) {
                    this.log.println(this, 7, "Number of patches failing authentication on download = " + n);
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_CORRUPT_DOWNLOAD).append(" ").append(n).append("\n");
                    int n3 = 0;
                    while (n3 < n) {
                        block51: {
                            try {
                                patch = patchList.getPatchAt(n3);
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                this.log.printStackTrace(this, 2, noSuchPatchException);
                                break block51;
                            }
                            string = patch.getPatchID().getPatchID();
                            stringBuffer2.append(string).append(" ");
                        }
                        ++n3;
                    }
                    stringBuffer2.append("\n\n").append(this.EMAIL_EXPLANATION_CORRUPT_DOWNLOAD).append("\n");
                }
                if ((n = (patchList = sessionData.getPatchesDownloaded()).size()) != 0) {
                    this.log.println(this, 7, "Number of patches downloaded = " + n);
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_DOWNLOADED).append(" ").append(n).append("\n");
                    int n4 = 0;
                    while (n4 < n) {
                        block52: {
                            try {
                                patch = patchList.getPatchAt(n4);
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                this.log.printStackTrace(this, 2, noSuchPatchException);
                                break block52;
                            }
                            string = patch.getPatchID().getPatchID();
                            stringBuffer2.append(string).append(" ");
                        }
                        ++n4;
                    }
                    stringBuffer2.append("\n");
                }
                if ((n = (patchList = sessionData.getPatchesCorruptOnInstall()).size()) != 0) {
                    bl2 = true;
                    this.log.println(this, 7, "Number of patches failing authentication on install = " + n);
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_CORRUPT_INSTALL).append(" ").append(n).append("\n");
                    int n5 = 0;
                    while (n5 < n) {
                        block53: {
                            try {
                                patch = patchList.getPatchAt(n5);
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                this.log.printStackTrace(this, 2, noSuchPatchException);
                                break block53;
                            }
                            string = patch.getPatchID().getPatchID();
                            stringBuffer2.append(string).append(" ");
                        }
                        ++n5;
                    }
                    stringBuffer2.append("\n\n").append(this.EMAIL_EXPLANATION_CORRUPT_INSTALL).append("\n");
                }
                if ((n = (patchList = sessionData.getPatchesWithBadProperties()).size()) != 0) {
                    this.log.println(this, 7, "Number of patches with bad properties = " + n);
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_BAD_PROPERTIES).append(" ").append(n).append("\n");
                    int n6 = 0;
                    while (n6 < n) {
                        block54: {
                            try {
                                patch = patchList.getPatchAt(n6);
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                this.log.printStackTrace(this, 2, noSuchPatchException);
                                break block54;
                            }
                            string = patch.getPatchID().getPatchID();
                            stringBuffer2.append(string).append(" ");
                        }
                        ++n6;
                    }
                    stringBuffer2.append("\n\n").append(this.EMAIL_EXPLANATION_BAD_PROPERTIES).append("\n");
                }
                if ((n = (patchList = sessionData.getPatchesFailingInstall()).size()) != 0) {
                    this.log.println(this, 7, "Number of patches failing install = " + n);
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_FAILING_INSTALL).append(" ").append(n).append("\n");
                    int n7 = 0;
                    while (n7 < n) {
                        block55: {
                            try {
                                patch = patchList.getPatchAt(n7);
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                this.log.printStackTrace(this, 2, noSuchPatchException);
                                break block55;
                            }
                            string = patch.getPatchID().getPatchID();
                            stringBuffer2.append(string).append(" ");
                        }
                        ++n7;
                    }
                    stringBuffer2.append("\n\n").append(this.EMAIL_EXPLANATION_FAILING_INSTALL).append("\n");
                }
                if ((n = (patchList = sessionData.getPatchesInstalled()).size()) != 0) {
                    this.log.println(this, 7, "Number of patches installed = " + n);
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_INSTALLED).append(" ").append(n).append("\n");
                    int n8 = 0;
                    while (n8 < n) {
                        block56: {
                            try {
                                patch = patchList.getPatchAt(n8);
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                this.log.printStackTrace(this, 2, noSuchPatchException);
                                break block56;
                            }
                            string = patch.getPatchID().getPatchID();
                            stringBuffer2.append(string).append(" ");
                        }
                        ++n8;
                    }
                    stringBuffer2.append("\n");
                } else {
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_INSTALLED).append(" ").append(this.EMAIL_DESCRIPTION_NONE);
                }
                patchList = sessionData.getPatchesSequestered();
                n = patchList.size();
                if (n != 0) {
                    this.log.println(this, 7, "Number of patches sequestered = " + n);
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_SEQUESTERED).append(" ").append(n).append("\n");
                    int n9 = 0;
                    while (n9 < n) {
                        block57: {
                            try {
                                patch = patchList.getPatchAt(n9);
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                this.log.printStackTrace(this, 2, noSuchPatchException);
                                break block57;
                            }
                            string = patch.getPatchID().getPatchID();
                            stringBuffer2.append(string).append(" ");
                        }
                        ++n9;
                    }
                    if (bl2) {
                        stringBuffer2.append("\n\n").append(this.EMAIL_EXPLANATION_SEQUESTEREDBAD).append("\n");
                    } else {
                        stringBuffer2.append("\n\n").append(this.EMAIL_EXPLANATION_SEQUESTERED).append("\n");
                    }
                } else {
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_SEQUESTERED).append(" ").append(this.EMAIL_DESCRIPTION_NONE);
                }
                patchList = sessionData.getPatchesDeferred();
                n = patchList.size();
                if (n != 0) {
                    this.log.println(this, 7, "Number of patches deferred = " + n);
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_DEFERRED).append(" ").append(n).append("\n");
                    int n10 = 0;
                    while (n10 < n) {
                        block58: {
                            try {
                                patch = patchList.getPatchAt(n10);
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                this.log.printStackTrace(this, 2, noSuchPatchException);
                                break block58;
                            }
                            string = patch.getPatchID().getPatchID();
                            stringBuffer2.append(string).append(" ");
                        }
                        ++n10;
                    }
                    stringBuffer2.append("\n\n").append(this.EMAIL_EXPLANATION_DEFERRED).append("\n");
                } else {
                    stringBuffer2.append("\n").append(this.EMAIL_INTRO_DEFERRED).append(" ").append(this.EMAIL_DESCRIPTION_NONE);
                }
            }
            bl = false;
        } while (enumeration.hasMoreElements());
        stringBuffer2.append("\n").append(this.EMAIL_DESCRIPTION_MSG09).append("\n").append(this.EMAIL_DESCRIPTION_MSG10);
        object = this.indentEmailMsgLines(stringBuffer2.toString(), " \n", true);
        if (this.properties.getProperty("patchpro.debug", "false").equals("true")) {
            System.out.println("\nE-Mail notification would be...");
            System.out.println((String)object);
            System.out.println("... End E-Mail notification.\n");
        } else {
            this.notifyRecipient(this.EMAIL_ERROR_RECIPIENT, this.ccList, this.EMAIL_ERROR_SUBJECT, (String)object);
        }
    }

    private String indentEmailMsgLines(String string, String string2, boolean bl) {
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n = 0;
        String string4 = "";
        int n2 = 0;
        int n3 = 70;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            n2 = string4.length();
            if ((n += n2) <= n3) {
                string3 = string3 + string4;
                if (!string4.equals("\n")) continue;
                n = 0;
                continue;
            }
            string3 = string4.equals("\n") ? string3 + string4 : string3 + "\n" + string4;
            n = n2;
        }
        return string3;
    }

    public void notifyRecipient(String string, String[] stringArray, String string2, String string3) {
        String string4 = this.properties.getProperty(string);
        try {
            if (string4 != "" && string4 != null) {
                this.mailerImpl.send(string2, stringArray, string4, string3);
            } else {
                this.log.println(this, 4, "e-mail recipient property was not defined.\n");
            }
        }
        catch (ErrorSendingEmailException errorSendingEmailException) {
            this.log.printStackTrace(this, 3, errorSendingEmailException);
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
    }
}

