/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.Messagable;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServerProxyException;
import com.sun.patchpro.server.PatchServiceProvider;
import com.sun.patchpro.util.ConfigException;
import java.io.File;
import java.util.Collection;

public class PatchServerProxy
implements Messagable {
    PatchServiceProvider provider;
    PatchProLog log = PatchProLog.getInstance();

    public PatchServerProxy(PatchProProperties patchProProperties) throws PatchServerProxyException, PatchProException {
        boolean bl = false;
        bl = patchProProperties.getProperty("patchpro.ispatchserver").equals("true");
        String string = bl ? "patchsvr.source.0.url" : "patchpro.patch.source";
        String string2 = patchProProperties.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            String string3 = "patchpro.patch.source not specified.";
            this.log.println(this, 2, string3);
            throw new PatchServerProxyException(string3);
        }
        String string4 = null;
        if (string2.indexOf("file:") == 0) {
            string4 = "com.sun.patchpro.server.FileSystemPatchServiceProvider";
        } else if (string2.indexOf("https:") == 0 || string2.indexOf("http:") == 0) {
            string4 = bl ? "com.sun.patchpro.server.ServerPatchServiceProvider" : "com.sun.patchpro.server.ServerPatchServiceProvider";
        } else {
            String string5 = "Unknown protocol: " + string2;
            this.log.println(this, 2, string5);
            throw new PatchServerProxyException(string5);
        }
        this.log.println(this, 7, "Adaptor is: " + string4);
        try {
            Class<?> clazz = Class.forName(string4);
            this.provider = (PatchServiceProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.printStackTrace(this, 2, classNotFoundException);
            throw new PatchServerProxyException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            this.log.printStackTrace(this, 2, instantiationException);
            throw new PatchServerProxyException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.printStackTrace(this, 2, illegalAccessException);
            throw new PatchServerProxyException(illegalAccessException);
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            throw new PatchServerProxyException(exception);
        }
    }

    public File downloadPatchDB(String string) throws DownloadPatchDBException, NotSupportedException, PatchProException {
        return this.provider.downloadPatchDB(string);
    }

    public File downloadRealizationDetectors(String string) throws DownloadRealizationException, NotSupportedException, PatchProException {
        return this.provider.downloadRealizationDetectors(string);
    }

    public File getDetectorCacheFile(String string) throws ConfigException {
        return this.provider.getDetectorCacheFile(string);
    }

    public void downloadPatches(PatchList patchList, Object object) throws DownloadPatchException, NotSupportedException, PatchProException {
        this.provider.downloadPatches(patchList, object);
    }

    public void downloadPatches(PatchList patchList, Object object, SessionData sessionData) throws DownloadPatchException, NotSupportedException, PatchProException {
        this.provider.downloadPatches(patchList, object, sessionData);
    }

    public PatchBundleInfo[] getDownloadedPatchBundlesInfo(PatchList patchList) throws PatchProException {
        return this.provider.getDownloadedPatchBundlesInfo(patchList);
    }

    public Object getDownloadDestination() {
        return this.provider.getDownloadDestination();
    }

    public void addDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        this.provider.addDownloadPatchListener(downloadPatchListener);
    }

    public void removeDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        this.provider.removeDownloadPatchListener(downloadPatchListener);
    }

    public boolean isCertificateRevoked(String string) throws NotSupportedException {
        return this.provider.isCertificateRevoked(string);
    }

    public Collection getPatchProExceptions() {
        if (this.provider instanceof Messagable) {
            return ((Messagable)((Object)this.provider)).getPatchProExceptions();
        }
        return null;
    }
}

