/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.common.SecureReader;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class DirectoryTableSetup
implements TableSetup {
    protected static final int NUM_OF_DIRSERVICES = 5;
    private static final String grepCmd = "/bin/grep";
    private static final String sedCmd = "/bin/sed";
    private static final String nssFileName = "/etc/nsswitch.conf";
    protected static final String[] dirServiceName = new String[]{"File", "Nis", "Nisplus", "Dns", "Ldap"};

    public Vector getNameServiceSwitchOrder(String string) {
        Vector<String> vector = null;
        String[] stringArray = new String[]{"sh", "-c", "/bin/grep '^" + string + ":' " + nssFileName + " | " + sedCmd + " 's/^" + string + "://'"};
        String[] stringArray2 = CommonTools.CMN_exec(stringArray);
        if (stringArray2.length < 1) {
            return vector;
        }
        stringArray2[0].trim();
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray2[0], " \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2.trim();
            if (string2.equals("files")) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement("file");
            }
            if (string2.equals("nisplus")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("nisplus");
            }
            if (string2.equals("nis")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("nis");
            }
            if (string2.equals("dns")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("dns");
            }
            if (string2.equals("ldap")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("ldap");
            }
            if (string2.indexOf("NOTFOUND = return") == -1) continue;
            return vector;
        }
        return vector;
    }

    public Vector getScopes(String string, int n) {
        Vector vector = null;
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase();
        String string3 = "com.sun.wbem.utility.directorytable." + string2 + "DirectoryTable";
        try {
            TableSetup tableSetup = (TableSetup)Class.forName(string3).newInstance();
            if (tableSetup != null) {
                vector = tableSetup.getScopes(n);
            }
            tableSetup = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return vector;
    }

    public Vector getScopes(int n) {
        Vector vector = null;
        Vector<String> vector2 = null;
        if ((n & 1) == 1) {
            vector2 = this.getNameServiceSwitchOrder("group");
            if (vector2 == null) {
                return vector;
            }
        } else {
            vector2 = new Vector<String>(4);
            vector2.addElement("File");
            vector2.addElement("Nis");
            vector2.addElement("Nisplus");
            vector2.addElement("Dns");
            vector2.addElement("Ldap");
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            String string = (String)vector2.elementAt(n2);
            Vector vector3 = this.getScopes(string = string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase(), n);
            if (vector3 != null) {
                if (vector == null) {
                    vector = new Vector();
                }
                int n3 = 0;
                while (n3 < vector3.size()) {
                    vector.addElement(vector3.elementAt(n3));
                    ++n3;
                }
            }
            ++n2;
        }
        return vector;
    }

    public boolean isValidScope(String string) {
        int n = 0;
        n = string.indexOf(":/");
        if (n == -1 || n < 2) {
            return false;
        }
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1, n).toLowerCase();
        if (string.length() <= n + 2) {
            return false;
        }
        String string3 = string.substring(n + 2);
        String string4 = DirectoryUtility.getContextProperty(string3, "serverName");
        String string5 = DirectoryUtility.getContextProperty(string3, "domainName");
        if (!DirectoryUtility.isLocalServer(string4)) {
            return false;
        }
        Vector vector = this.getScopes(0);
        if (vector.size() == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            String string6;
            String string7 = (String)vector.elementAt(n2);
            n = string7.indexOf(":/");
            if (n != -1 && n >= 2 && (string6 = string7.substring(0, 1).toUpperCase() + string7.substring(1, n).toLowerCase()).equals(string2) && string7.length() > n + 2) {
                String string8 = string7.substring(n + 2);
                if (string6.equals("File")) {
                    return DirectoryUtility.isLocalServer(string5);
                }
                String string9 = DirectoryUtility.getContextProperty(string8, "domainName");
                if (string9.equals(string5)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public void setup() {
        int n = 0;
        while (n < 5) {
            String string = "com.sun.wbem.utility.directorytable." + dirServiceName[n] + "DirectoryTable";
            try {
                TableSetup tableSetup = (TableSetup)Class.forName(string).newInstance();
                if (tableSetup != null) {
                    tableSetup.setup();
                }
                tableSetup = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void refreshSetup() {
        int n = 0;
        while (n < 5) {
            String string = "com.sun.wbem.utility.directorytable." + dirServiceName[n] + "DirectoryTable";
            try {
                TableSetup tableSetup = (TableSetup)Class.forName(string).newInstance();
                if (tableSetup != null) {
                    tableSetup.refreshSetup();
                }
                tableSetup = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        block27: {
            block32: {
                DirectoryTableSetup directoryTableSetup;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    directoryTableSetup = new DirectoryTableSetup();
                                    if (!stringArray[0].equals("initial")) break block26;
                                    directoryTableSetup.setup();
                                    break block27;
                                }
                                if (!stringArray[0].equals("refresh")) break block28;
                                directoryTableSetup.refreshSetup();
                                break block27;
                            }
                            if (!stringArray[0].equals("validate")) break block29;
                            if (directoryTableSetup.isValidScope(stringArray[1])) {
                                System.out.println("Scope is valid");
                            } else {
                                System.out.println("Scope is not valid");
                            }
                            break block27;
                        }
                        if (!stringArray[0].equals("transfer")) break block30;
                        try {
                            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(stringArray[1]);
                            DirectoryTable directoryTable2 = DirectoryTableFactory.getDirectoryTableInstance(stringArray[2]);
                            TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                            tableDefinitions.loadTableDefinitions(stringArray[3]);
                            TableDefinitions tableDefinitions2 = directoryTable2.getTableDefinitionsInstance();
                            tableDefinitions2.loadTableDefinitions(stringArray[3]);
                            try {
                                directoryTable.open(tableDefinitions);
                            }
                            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                                directoryTable.create(tableDefinitions);
                            }
                            try {
                                directoryTable2.open(tableDefinitions2);
                            }
                            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                                directoryTable2.create(tableDefinitions2);
                            }
                            DirectoryRow directoryRow = directoryTable.getAll();
                            if (directoryRow != null) {
                                DirectoryRow directoryRow2 = directoryTable2.getRowInstance(directoryRow.getNumberOfRows());
                                int n = 1;
                                while (n <= directoryRow.getNumberOfRows()) {
                                    System.out.print("Row " + n + ": ");
                                    int n2 = 1;
                                    while (n2 <= directoryRow.getNumberOfColumns()) {
                                        try {
                                            System.out.print(tableDefinitions.getColumnName(n2) + " = " + directoryRow.getColumn(n2, n) + " ");
                                            directoryRow2.putColumn(tableDefinitions2.getColumnNumber(tableDefinitions.getColumnName(n2)), n, directoryRow.getColumn(n2, n));
                                        }
                                        catch (DirectoryTableException directoryTableException) {
                                            // empty catch block
                                        }
                                        ++n2;
                                    }
                                    System.out.println("");
                                    ++n;
                                }
                                directoryTable2.addRow(directoryRow2);
                            }
                            directoryTable.close();
                            directoryTable2.close();
                        }
                        catch (DirectoryTableException directoryTableException) {
                            System.out.println(directoryTableException.getMessage());
                        }
                        break block27;
                    }
                    if (!stringArray[0].equals("dump")) break block31;
                    try {
                        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(stringArray[1]);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions(stringArray[2]);
                        try {
                            directoryTable.open(tableDefinitions);
                        }
                        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                            System.out.println(directoryTableDoesNotExistException.getMessage());
                            return;
                        }
                        DirectoryRow directoryRow = directoryTable.getAll();
                        if (directoryRow != null) {
                            int n = 1;
                            while (n <= directoryRow.getNumberOfRows()) {
                                System.out.print("Row " + n + ": ");
                                int n3 = 1;
                                while (n3 <= directoryRow.getNumberOfColumns()) {
                                    try {
                                        System.out.print(tableDefinitions.getColumnName(n3) + " = " + directoryRow.getColumn(n3, n) + " ");
                                    }
                                    catch (DirectoryTableException directoryTableException) {
                                        // empty catch block
                                    }
                                    ++n3;
                                }
                                System.out.println("");
                                ++n;
                            }
                        }
                        directoryTable.close();
                    }
                    catch (DirectoryTableException directoryTableException) {
                        System.out.println(directoryTableException.getMessage());
                    }
                    break block27;
                }
                if (!stringArray[0].equals("scopes")) break block32;
                System.out.println("Getting list of managable scopes...");
                Vector vector = directoryTableSetup.getScopes(0);
                if (vector == null) break block27;
                int n = 0;
                while (n < vector.size()) {
                    System.out.println("Scope " + (n + 1) + " " + vector.elementAt(n));
                    ++n;
                }
                break block27;
            }
            if (!stringArray[0].equals("storeCred")) break block27;
            String string = "";
            String string2 = "";
            String string3 = "";
            boolean bl = false;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                System.out.print("Administrator DN:");
                string = bufferedReader.readLine();
                while (!bl) {
                    System.out.print("Password:");
                    string2 = SecureReader.readLine(System.in);
                    System.out.println();
                    System.out.print("Password (confirm):");
                    string3 = SecureReader.readLine(System.in);
                    System.out.println();
                    if (string2.compareTo(string3) != 0) continue;
                    bl = true;
                }
                DirectoryTableLibrary.storeCred(string, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

