/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication;

import com.sun.management.viper.services.AuthenticationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Random;

public class DigestSecurityUtil {
    private static final int MAX_PASSWORD_SIZE = 16;
    private static final int DIGEST_SESSION_KEY_SIZE = 20;
    private static Provider prov;
    private static SecureRandom random;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static MessageDigest digester;
    private static Signature signer;
    private static PrivateKey privkey;
    private static PublicKey pubkey;
    private static ByteArrayOutputStream outstr;
    private static PrintWriter prtwrtr;
    private static boolean initialized;
    private static final int RANDOM_KEYSIZE = 20;
    private static final char[] hex;

    public static void initialize(Provider provider, String string, String string2, String string3, int n) throws AuthenticationException {
        if (initialized) {
            return;
        }
        prov = null;
        if (provider != (Provider)null) {
            prov = provider;
        }
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (prov == (Provider)null) {
            string6 = "any";
            try {
                string4 = "EXSS_NDA";
                string5 = string;
                digester = MessageDigest.getInstance(string5, string6);
                string4 = "EXSS_NSA";
                string5 = string2;
                signer = Signature.getInstance(string5, string6);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AuthenticationException(string4, (Object)string6, (Object)string5);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new AuthenticationException("EXSS_SPI", (Object)string6);
            }
        }
        string6 = prov.getName();
        try {
            string4 = "EXSS_NDA";
            string5 = string;
            digester = MessageDigest.getInstance(string5, string6);
            string4 = "EXSS_NSA";
            string5 = string2;
            signer = Signature.getInstance(string5, string6);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthenticationException(string4, (Object)string6, (Object)string5);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new AuthenticationException("EXSS_SPI", (Object)string6);
        }
        try {
            byte[] byArray = DigestSecurityUtil.getSeed();
            random = new SecureRandom(byArray);
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_NRN");
        }
        initialized = true;
    }

    public static synchronized void getRandomBytes(byte[] byArray) throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        random.nextBytes(byArray);
    }

    public static synchronized byte[] getSessionKey() throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        byte[] byArray = new byte[20];
        random.nextBytes(byArray);
        return byArray;
    }

    public static synchronized byte[] getBytes(Object object) throws AuthenticationException {
        byte[] byArray;
        ObjectOutputStream objectOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(1024);
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new AuthenticationException("EXSS_OOS");
        }
        try {
            objectOutputStream.writeObject(object);
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_USO");
        }
        try {
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_NBS");
        }
        try {
            objectOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static synchronized byte[] generateDigest(byte[] byArray, byte[] byArray2, byte[] byArray3) throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        digester.reset();
        if (byArray != null) {
            digester.update(byArray);
        }
        if (byArray2 != null) {
            digester.update(byArray2);
        }
        if (byArray3 != null) {
            digester.update(byArray3);
        }
        byte[] byArray4 = digester.digest();
        return byArray4;
    }

    public static synchronized byte[] generateDigest(Object[] objectArray) throws AuthenticationException {
        byte[] byArray;
        ObjectOutputStream objectOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(2048);
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new AuthenticationException("EXSS_OOS");
        }
        int n = 0;
        while (n < objectArray.length) {
            try {
                objectOutputStream.writeObject(objectArray[n]);
            }
            catch (Exception exception) {
                throw new AuthenticationException("EXSS_USO");
            }
            ++n;
        }
        try {
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_NBS");
        }
        digester.reset();
        digester.update(byArray);
        byte[] byArray2 = digester.digest();
        try {
            objectOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray2;
    }

    public static synchronized boolean compareDigests(byte[] byArray, byte[] byArray2) throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        return MessageDigest.isEqual(byArray, byArray2);
    }

    public static synchronized byte[] signDigest(byte[] byArray) throws AuthenticationException {
        byte[] byArray2 = null;
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        try {
            signer.initSign(privkey);
            signer.update(byArray);
            byArray2 = signer.sign();
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_CSD");
        }
        return byArray2;
    }

    public static synchronized boolean verifyDigest(byte[] byArray, byte[] byArray2, PublicKey publicKey) throws AuthenticationException {
        boolean bl = false;
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        try {
            signer.initVerify(publicKey);
            signer.update(byArray);
            bl = signer.verify(byArray2);
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_CVD");
        }
        return bl;
    }

    public static synchronized byte[] encryptDigest(byte[] byArray, byte[] byArray2) throws AuthenticationException {
        int n = byArray.length;
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            int n5 = n3;
            byArray3[n5] = (byte)(byArray3[n5] ^ byArray2[n3]);
            if (++n4 > n2) {
                n4 = 0;
            }
            ++n3;
        }
        return byArray3;
    }

    public static synchronized byte[] encryptPassword(byte[] byArray, byte[] byArray2) throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        byte[] byArray3 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byte[] byArray4 = new byte[byArray.length];
        random.nextBytes(byArray4);
        int n = 0;
        while (n < byArray2.length) {
            int n2 = n;
            byArray3[n2] = (byte)(byArray3[n2] ^ byArray2[n]);
            ++n;
        }
        int n3 = n++;
        byArray3[n3] = (byte)(byArray3[n3] ^ 0);
        while (n < byArray3.length) {
            int n4 = n;
            byArray3[n4] = (byte)(byArray3[n4] ^ byArray4[n]);
            ++n;
        }
        return byArray3;
    }

    public static synchronized byte[] decryptPassword(byte[] byArray, byte[] byArray2) throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        if (byArray.length != byArray2.length) {
            throw new AuthenticationException("EXSS_BEP");
        }
        byte[] byArray3 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        while (n < n3) {
            int n4 = n;
            byArray3[n4] = (byte)(byArray3[n4] ^ byArray2[n]);
            if (bl && byArray3[n] == 0) {
                bl = false;
                n2 = n;
            }
            ++n;
        }
        if (n2 < 1 || n2 > 16) {
            throw new AuthenticationException("EXSS_BEP");
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray4, 0, n2);
        return byArray4;
    }

    private static synchronized byte[] getSeed() {
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        long l = System.currentTimeMillis();
        Random random = new Random(l);
        random.nextBytes(byArray);
        random.nextBytes(byArray2);
        l = System.currentTimeMillis();
        long l2 = 1L;
        long l3 = 0L;
        int n = 0;
        while (n < 20) {
            l3 = l & l2;
            byArray3[n] = l3 > 0L ? byArray[n] : byArray2[n];
            l2 <<= 1;
            ++n;
        }
        return byArray3;
    }

    private static synchronized String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        initialized = false;
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

