/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.ImplResourceManager;
import com.sun.management.viperimpl.util.security.CertificateInfo;
import com.sun.management.viperimpl.util.security.DialogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import sun.misc.HexDumpEncoder;

public class CertificateDialog {
    private Certificate[] certs = null;
    private int start = 0;
    private int end = 0;
    private Component parentComponent;
    JTree certChainTree = null;
    final JTable certInfoTable = new JTable();
    final JTextArea textArea = new JTextArea();
    Object[] msg;
    Object[] options;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public CertificateDialog(Certificate[] certificateArray, int n, int n2) {
        this(null, certificateArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateDialog(Component component, Certificate[] certificateArray, int n, int n2) {
        try {
            this.certs = certificateArray;
            this.start = n;
            this.end = n2;
            this.parentComponent = component;
            UIManager.getBorder("TableHeader.cellBorder");
            UIManager.getBorder("Table.focusCellHighlightBorder");
            UIManager.getColor("Table.focusCellForeground");
            UIManager.getColor("Table.focusCellBackground");
            JTable jTable = new JTable();
            jTable.getDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = CertificateDialog.class$("java.lang.String")) : class$java$lang$String);
            jTable.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = CertificateDialog.class$("java.lang.Object")) : class$java$lang$Object);
            if (certificateArray.length > n && certificateArray[n] instanceof X509Certificate) {
                Border border = BorderFactory.createEtchedBorder();
                this.certChainTree = this.buildCertChainTree(certificateArray, n, n2);
                this.certChainTree.addTreeSelectionListener(new TreeSelectionListener(){

                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)CertificateDialog.this.certChainTree.getLastSelectedPathComponent();
                        if (defaultMutableTreeNode == null) {
                            return;
                        }
                        CertificateInfo certificateInfo = (CertificateInfo)defaultMutableTreeNode.getUserObject();
                        CertificateDialog.this.showCertificateInfo(certificateInfo.getCertificate());
                    }
                });
                this.showCertificateInfo((X509Certificate)certificateArray[n]);
                this.certInfoTable.setSelectionMode(0);
                ListSelectionModel listSelectionModel = this.certInfoTable.getSelectionModel();
                listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int n = CertificateDialog.this.certInfoTable.getSelectedRow();
                        if (n == -1) {
                            return;
                        }
                        String string = (String)CertificateDialog.this.certInfoTable.getValueAt(n, 1);
                        CertificateDialog.this.textArea.setText(string);
                        CertificateDialog.this.textArea.repaint();
                    }
                });
                this.textArea.setLineWrap(false);
                this.textArea.setEditable(false);
                this.textArea.setRows(10);
                this.textArea.setColumns(40);
                this.certInfoTable.setRowSelectionInterval(6, 6);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                Dimension dimension = this.certInfoTable.getPreferredScrollableViewportSize();
                dimension.setSize(dimension.getWidth(), 120.0);
                this.certInfoTable.setPreferredScrollableViewportSize(dimension);
                JScrollPane jScrollPane = new JScrollPane(this.certInfoTable);
                jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), jScrollPane.getBorder()));
                jPanel.add((Component)jScrollPane, "Center");
                jPanel.add((Component)new JScrollPane(this.textArea), "South");
                jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                dimension = this.certChainTree.getPreferredScrollableViewportSize();
                dimension.setSize(200.0, 100.0);
                jScrollPane = new JScrollPane(this.certChainTree);
                jScrollPane.setPreferredSize(dimension);
                jPanel2.add((Component)jScrollPane, "West");
                jPanel2.add((Component)jPanel, "East");
                this.msg = new Object[]{jPanel2};
                JButton jButton = new JButton(CertificateDialog.getMessage("cert_dialog.close"));
                jButton.setMnemonic(CertificateDialog.getAcceleratorKey("cert_dialog.close"));
                this.options = new Object[]{jButton};
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            throw throwable;
        }
    }

    public void DoModal() {
        DialogFactory.showOptionDialog(this.parentComponent, (Object)this.msg, CertificateDialog.getMessage("cert_dialog.caption"), this.options, this.options[0]);
    }

    private String formatDNString(String string) {
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"' || c == '\'') {
                boolean bl3 = bl2 = !bl2;
            }
            if (c == ',' && !bl2) {
                stringBuffer.append(",\n");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private JTree buildCertChainTree(Certificate[] certificateArray, int n, int n2) {
        Serializable serializable;
        Serializable serializable2 = null;
        Serializable serializable3 = null;
        int n3 = n;
        while (n3 < certificateArray.length && n3 < n2) {
            serializable = new DefaultMutableTreeNode(new CertificateInfo((X509Certificate)certificateArray[n3]));
            if (serializable2 == null) {
                serializable2 = serializable;
                serializable3 = serializable;
            } else {
                serializable3.add((MutableTreeNode)((Object)serializable));
                serializable3 = serializable;
            }
            ++n3;
        }
        serializable = new JTree((TreeNode)((Object)serializable2));
        serializable.getSelectionModel().setSelectionMode(1);
        serializable.putClientProperty("JTree.lineStyle", "Angled");
        return serializable;
    }

    private void showCertificateInfo(X509Certificate x509Certificate) {
        String string = "V" + x509Certificate.getVersion();
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        String string2 = "[" + bigInteger + "]";
        String string3 = "[" + x509Certificate.getSigAlgName() + "]";
        String string4 = this.formatDNString(x509Certificate.getIssuerDN().toString());
        String string5 = "[From: " + x509Certificate.getNotBefore() + ",\n To: " + x509Certificate.getNotAfter() + "]";
        String string6 = this.formatDNString(x509Certificate.getSubjectDN().toString());
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string7 = hexDumpEncoder.encodeBuffer(x509Certificate.getSignature());
        Object[][] objectArray = new Object[][]{{CertificateDialog.getMessage("cert_dialog.field.Version"), string}, {CertificateDialog.getMessage("cert_dialog.field.SerialNumber"), string2}, {CertificateDialog.getMessage("cert_dialog.field.SignatureAlg"), string3}, {CertificateDialog.getMessage("cert_dialog.field.Issuer"), string4}, {CertificateDialog.getMessage("cert_dialog.field.Validity"), string5}, {CertificateDialog.getMessage("cert_dialog.field.Subject"), string6}, {CertificateDialog.getMessage("cert_dialog.field.Signature"), string7}};
        Object[] objectArray2 = new String[]{CertificateDialog.getMessage("cert_dialog.field"), CertificateDialog.getMessage("cert_dialog.value")};
        this.certInfoTable.setModel(new DefaultTableModel(objectArray, objectArray2){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        this.certInfoTable.setRowSelectionInterval(6, 6);
        this.certInfoTable.repaint();
        this.textArea.repaint();
    }

    private static String getMessage(String string) {
        return ImplResourceManager.getString(string);
    }

    private static int getAcceleratorKey(String string) {
        return ImplResourceManager.getAcceleratorKey(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

