/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;

public final class Jdk14Logger
implements Log {
    protected Logger logger = null;

    public Jdk14Logger(String name) {
        this.logger = Logger.getLogger(name);
    }

    private void log(Level level, String msg, Throwable ex) {
        Throwable dummyException = new Throwable();
        StackTraceElement[] locations = dummyException.getStackTrace();
        String cname = "unknown";
        String method = "unknown";
        if (locations != null && locations.length > 2) {
            StackTraceElement caller = locations[2];
            cname = caller.getClassName();
            method = caller.getMethodName();
        }
        if (ex == null) {
            this.logger.logp(level, cname, method, msg);
        } else {
            this.logger.logp(level, cname, method, msg, ex);
        }
    }

    public void debug(Object message) {
        this.log(Level.FINE, message.toString(), null);
    }

    public void debug(Object message, Throwable exception) {
        this.log(Level.FINE, message.toString(), exception);
    }

    public void error(Object message) {
        this.log(Level.SEVERE, message.toString(), null);
    }

    public void error(Object message, Throwable exception) {
        this.log(Level.SEVERE, message.toString(), exception);
    }

    public void fatal(Object message) {
        this.log(Level.SEVERE, message.toString(), null);
    }

    public void fatal(Object message, Throwable exception) {
        this.log(Level.SEVERE, message.toString(), exception);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void info(Object message) {
        this.log(Level.INFO, message.toString(), null);
    }

    public void info(Object message, Throwable exception) {
        this.log(Level.INFO, message.toString(), exception);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void trace(Object message) {
        this.log(Level.FINEST, message.toString(), null);
    }

    public void trace(Object message, Throwable exception) {
        this.log(Level.FINEST, message.toString(), exception);
    }

    public void warn(Object message) {
        this.log(Level.WARNING, message.toString(), null);
    }

    public void warn(Object message, Throwable exception) {
        this.log(Level.WARNING, message.toString(), exception);
    }
}

