/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import java.io.Serializable;

public class SerialPortData
implements Serializable,
Cloneable {
    public static final int NUM_FIELDS = 20;
    String portName = "";
    String portMonTag = "";
    String portMonType = "";
    String serviceTag = "";
    String portFlags = "";
    String identity = "";
    String reserve_1 = "";
    String reserve_2 = "";
    String reserve_3 = "";
    String deviceName = "";
    String ttyFlags = "";
    String countVal = "";
    String serviceCmdLine = "";
    String timeoutVal = "";
    String ttyLabel = "";
    String modules = "";
    String prompt = "";
    String disable = "";
    String terminalType = "";
    String softwareCarrier = "y";
    String comment = "";
    boolean noService = false;
    boolean enable = false;
    boolean deleted = false;
    String oldPortMonTag = "";
    String oldServiceTag = "";

    public SerialPortData(String string) {
        this.portName = string;
    }

    public void setDefaults(String string) {
        this.setEnable(false);
        this.ttyLabel = "9600";
        this.terminalType = "tvi925";
        this.setTTYFlags(false, true, false);
        this.setSoftwareCarrier(false);
        this.prompt = "tty" + string + " login:";
        this.comment = "";
        this.setPortFlags(true);
        this.setDisableFlag();
        this.setServiceTag("tty" + string);
        this.setPortMonTag("zsmon");
        this.portMonType = "ttymon";
        this.setModules("ldterm,ttcompat");
        this.setDeviceName("/dev/term/" + string);
        this.setServiceCmdLine("/usr/bin/login");
        this.setTimeoutVal("30");
    }

    public void fillData(String[] stringArray) {
        this.oldPortMonTag = this.portMonTag = stringArray[0];
        this.portMonType = stringArray[1];
        this.oldServiceTag = this.serviceTag = stringArray[2];
        this.portFlags = stringArray[3];
        this.identity = stringArray[4];
        this.reserve_1 = stringArray[5];
        this.reserve_2 = stringArray[6];
        this.reserve_3 = stringArray[7];
        this.deviceName = stringArray[8];
        this.ttyFlags = stringArray[9];
        this.countVal = stringArray[10];
        this.serviceCmdLine = stringArray[11];
        this.timeoutVal = stringArray[12];
        this.ttyLabel = stringArray[13];
        this.modules = stringArray[14];
        this.prompt = stringArray[15];
        this.disable = stringArray[16];
        this.terminalType = stringArray[17];
        this.softwareCarrier = stringArray[18];
        this.comment = stringArray[19];
        if (this.comment.compareTo("#") == 0) {
            this.comment = "";
        }
        if (this.portFlags.indexOf("x") >= 0) {
            this.setNoService();
        } else {
            this.setService();
            this.setEnable(true);
        }
    }

    public String getPortMonTag() {
        return this.portMonTag;
    }

    public String getOldPortMonTag() {
        return this.oldPortMonTag;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String string) {
        if (string != null) {
            this.portName = string;
        }
    }

    public String getServiceTag() {
        return this.serviceTag;
    }

    public String getOldServiceTag() {
        return this.oldServiceTag;
    }

    public void setOldServiceTag(String string) {
        if (string != null) {
            this.oldServiceTag = string;
        }
    }

    public void setOldPortMonTag(String string) {
        if (string != null) {
            this.oldPortMonTag = string;
        }
    }

    public void setPortMonTag(String string) {
        if (string != null) {
            this.oldPortMonTag = this.portMonTag;
            this.portMonTag = string;
        }
    }

    public void setServiceTag(String string) {
        if (string != null) {
            this.oldServiceTag = this.serviceTag;
            this.serviceTag = string;
        }
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
    }

    public boolean isEnableSet() {
        return this.enable;
    }

    public void setDeleted() {
        this.deleted = true;
    }

    public void setNotDeleted() {
        this.deleted = false;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String string) {
        if (string != null) {
            this.deviceName = string;
        }
    }

    public String getTTYLabel() {
        return this.ttyLabel;
    }

    public void setTTYLabel(String string) {
        if (string != null) {
            this.ttyLabel = string;
        }
    }

    public String getServiceCmdLine() {
        return this.serviceCmdLine;
    }

    public void setServiceCmdLine(String string) {
        if (string != null) {
            String string2;
            String string3 = string.trim();
            this.serviceCmdLine = string3.indexOf(" ") > 0 && string3.indexOf(" ") < string3.length() ? (string2 = "\"" + string3 + "\"") : string3;
        }
    }

    public String getTTYFlags() {
        return this.ttyFlags;
    }

    public void setTTYFlags(boolean bl, boolean bl2, boolean bl3) {
        this.ttyFlags = "";
        if (bl) {
            this.ttyFlags = this.ttyFlags + "I";
        }
        if (bl2) {
            this.ttyFlags = this.ttyFlags + "b";
        }
        if (bl3) {
            this.ttyFlags = this.ttyFlags + "c";
        }
    }

    public boolean isInitializeSet() {
        return this.ttyFlags.indexOf(73) >= 0;
    }

    public void setInitialize(boolean bl) {
        if (bl) {
            if (this.isInitializeSet()) {
                return;
            }
            this.ttyFlags = this.ttyFlags + "I";
        } else {
            if (!this.isInitializeSet()) {
                return;
            }
            int n = this.ttyFlags.indexOf(73);
            String string = this.ttyFlags.substring(0, n);
            if (n < this.ttyFlags.length() - 1) {
                string = string + this.ttyFlags.substring(n + 1);
            }
            this.ttyFlags = string;
        }
    }

    public boolean isBidirectionalSet() {
        return this.ttyFlags.indexOf(98) >= 0;
    }

    public void setBidirectional(boolean bl) {
        if (bl) {
            if (this.isBidirectionalSet()) {
                return;
            }
            this.ttyFlags = this.ttyFlags + "b";
        } else {
            if (!this.isBidirectionalSet()) {
                return;
            }
            int n = this.ttyFlags.indexOf(98);
            String string = this.ttyFlags.substring(0, n);
            if (n < this.ttyFlags.length() - 1) {
                string = string + this.ttyFlags.substring(n + 1);
            }
            this.ttyFlags = string;
        }
    }

    public boolean isConnectOnCarrierSet() {
        return this.ttyFlags.indexOf(99) >= 0;
    }

    public void setConnectOnCarrier(boolean bl) {
        if (bl) {
            if (this.isConnectOnCarrierSet()) {
                return;
            }
            this.ttyFlags = this.ttyFlags + "c";
        } else {
            if (!this.isConnectOnCarrierSet()) {
                return;
            }
            int n = this.ttyFlags.indexOf(99);
            String string = this.ttyFlags.substring(0, n);
            if (n < this.ttyFlags.length() - 1) {
                string = string + this.ttyFlags.substring(n + 1);
            }
            this.ttyFlags = string;
        }
    }

    public String getModules() {
        return this.modules;
    }

    public void setModules(String string) {
        if (string != null) {
            this.modules = string;
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String string) {
        if (string != null) {
            this.prompt = string;
        }
    }

    public String getTimeoutVal() {
        return this.timeoutVal;
    }

    public void setTimeoutVal(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("never")) {
            string = "";
        } else {
            this.timeoutVal = string;
        }
    }

    public String getSoftwareCarrier() {
        return this.softwareCarrier;
    }

    public boolean isSoftwareCarrier() {
        return this.softwareCarrier.equalsIgnoreCase("y");
    }

    public void setSoftwareCarrier(boolean bl) {
        this.softwareCarrier = bl ? "y" : "n";
    }

    public String getTerminalType() {
        return this.terminalType;
    }

    public void setTerminalType(String string) {
        if (string != null) {
            this.terminalType = string;
        }
    }

    public String getIdentity() {
        if (this.identity == null || this.identity.length() == 0) {
            return "root";
        }
        return this.identity;
    }

    public void setIdentity(String string) {
        if (string != null) {
            this.identity = string;
        }
    }

    public String getPortFlags() {
        return this.portFlags;
    }

    public void setPortFlags(boolean bl) {
        if (bl && this.portFlags.indexOf("u") < 0) {
            this.portFlags = this.portFlags + "u";
        }
    }

    public boolean isUTMPSet() {
        return this.portFlags.indexOf("u") < 0;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        if (string != null) {
            this.comment = string;
        }
    }

    public boolean isEqualTo(SerialPortData serialPortData) {
        return this.portName.equalsIgnoreCase(serialPortData.getPortName()) && this.portMonTag.equalsIgnoreCase(serialPortData.getPortMonTag()) && this.serviceTag.equalsIgnoreCase(serialPortData.getServiceTag()) && this.portFlags.equalsIgnoreCase(serialPortData.getPortFlags()) && this.ttyFlags.equalsIgnoreCase(serialPortData.getTTYFlags()) && this.serviceCmdLine.equalsIgnoreCase(serialPortData.getServiceCmdLine()) && this.timeoutVal.equalsIgnoreCase(serialPortData.getTimeoutVal()) && this.ttyLabel.equalsIgnoreCase(serialPortData.getTTYLabel()) && this.modules.equalsIgnoreCase(serialPortData.getModules()) && this.prompt.equalsIgnoreCase(serialPortData.getPrompt()) && this.terminalType.equalsIgnoreCase(serialPortData.getTerminalType()) && this.softwareCarrier.equalsIgnoreCase(serialPortData.getSoftwareCarrier()) && this.comment.equalsIgnoreCase(serialPortData.getComment());
    }

    public void validateModules() throws SerialPortException {
        String string;
        if (this.modules != null && (string = this.modules.trim()).indexOf(" ") > 0) {
            throw new SerialPortException("EXM_DAT_MOD");
        }
    }

    public void validateTerminalType() throws SerialPortException {
    }

    public void validateComment() throws SerialPortException {
    }

    public void validateTTYLabel() throws SerialPortException {
    }

    public void validatePrompt() throws SerialPortException {
    }

    public void validatePortMonitorTag() throws SerialPortException {
        this.portMonTag.trim();
        if (this.portMonTag.length() == 0) {
            throw new SerialPortException("EXM_DAT_PMTAG");
        }
    }

    public void validateTimeout() throws SerialPortException {
    }

    public void validateServiceCmdLine() throws SerialPortException {
        this.serviceCmdLine.trim();
        if (this.serviceCmdLine.length() == 0) {
            throw new SerialPortException("EXM_DAT_SVCCMDLINE");
        }
    }

    public void tweakPortFlags() {
        int n = this.portFlags.indexOf("x");
        if (n < 0) {
            return;
        }
        this.portFlags = n == 0 ? (this.portFlags.length() > 1 ? "u" : "") : "u";
    }

    public void setDisableFlag() {
        if (this.portFlags.indexOf("x") < 0) {
            this.portFlags = this.portFlags + "x";
        }
    }

    public void setNoService() {
        this.noService = true;
    }

    public void setService() {
        this.noService = false;
    }

    public boolean isThereNoService() {
        return this.noService;
    }

    public String toString() {
        String string = "\n\t";
        string = string + "Port Name: " + this.portName + "\n\t";
        string = string + "Port Monitor Tag: " + this.portMonTag + "\n\t";
        string = string + "Port Monitor Type: " + this.portMonType + "\n\t";
        string = string + "Service Tag: " + this.serviceTag + "\n\t";
        string = string + "Port Flags: " + this.portFlags + "\n\t";
        string = string + "Identity: " + this.identity + "\n\t";
        string = string + "Reserved Field 1: " + this.reserve_1 + "\n\t";
        string = string + "Reserve Field 2: " + this.reserve_2 + "\n\t";
        string = string + "Reserve Field 3: " + this.reserve_3 + "\n\t";
        string = string + "Device Name: " + this.deviceName + "\n\t";
        string = string + "tty Flags : " + this.ttyFlags + "\n\t";
        string = string + "Count Value : " + this.countVal + "\n\t";
        string = string + "Service Command Line : " + this.serviceCmdLine + "\n\t";
        string = string + "Timeout Value : " + this.timeoutVal + "\n\t";
        string = string + "tty label : " + this.ttyLabel + "\n\t";
        string = string + "Modules : " + this.modules + "\n\t";
        string = string + "Prompt : " + this.prompt + "\n\t";
        string = string + "Disable : " + this.disable + "\n\t";
        string = string + "Terminal type : " + this.terminalType + "\n\t";
        string = string + "Software Carrier : " + this.softwareCarrier + "\n\t";
        string = string + "Comment: " + this.comment + "\n";
        return string;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

