/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.OCFClientSocket;
import com.sun.smartcard.OCFDecoder;
import com.sun.smartcard.OCFEncoder;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.SignatureCardService;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.TimeoutSpec;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import java.util.Vector;
import sun.misc.BASE64Decoder;

public class KeyImportCardService {
    OCFClientSocket server = new OCFClientSocket();
    Card card;

    public KeyImportCardService(Card card) throws SmartcardException {
        this.card = card;
    }

    public void importPrivateKey(String string, byte[] byArray) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        vector.add(byArray);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("CardService", "KeyImportCardService", "importPrivateKey", string2);
        OCFDecoder.decode(string3);
    }

    public void importCertificate(String string, byte[] byArray) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        vector.add(byArray);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("CardService", "KeyImportCardService", "importCertificate", string2);
        OCFDecoder.decode(string3);
    }

    public Enumeration readCertificates() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("CardService", "KeyImportCardService", "readCertificates", string);
        Vector vector2 = OCFDecoder.decode(string2);
        if (vector2 == null || vector2.size() == 0) {
            throw new SmartcardException("Unknown results");
        }
        Vector vector3 = (Vector)vector2.elementAt(0);
        Enumeration enumeration = vector3.elements();
        Vector<byte[]> vector4 = new Vector<byte[]>();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            vector4.add(SignatureCardService.parseHexString(string3));
        }
        return vector4.elements();
    }

    private static byte[] readCertFromFile(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string2 = bufferedReader.readLine();
        int n = string2.compareTo("-----BEGIN CERTIFICATE-----");
        if (n == 0) {
            while ((string2 = bufferedReader.readLine()).compareTo("-----END CERTIFICATE-----") != 0) {
                stringBuffer.append(string2);
            }
        } else {
            do {
                stringBuffer.append(string2);
            } while ((n = (string2 = bufferedReader.readLine()) != null ? string2.compareTo("-----END CERTIFICATE-----") : 0) != 0);
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = bASE64Decoder.decodeBuffer(stringBuffer.toString());
        ((InputStream)fileInputStream).close();
        bufferedReader.close();
        return byArray;
    }

    public static void main(String[] stringArray) {
        Smartcard smartcard = null;
        try {
            smartcard = new Smartcard("client1", "1");
            Card card = smartcard.waitForCardInserted(new CardSpec(), new ReaderSpec(), new AIDSpec(), new TimeoutSpec());
            System.out.println("Card inserted: " + card);
            KeyImportCardService keyImportCardService = (KeyImportCardService)card.getCardService("com.sun.smartcard.KeyImportCardService");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(512);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
            keyImportCardService.importPrivateKey("testalias", rSAPrivateKey.getEncoded());
            byte[] byArray = KeyImportCardService.readCertFromFile("/tmp/certfile");
            keyImportCardService.importCertificate("testcert", byArray);
            Enumeration enumeration = keyImportCardService.readCertificates();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (smartcard != null) {
            smartcard.cleanup();
        }
    }
}

