/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.DigestException;
import java.security.InvalidKeyException;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;

public abstract class JSSMessageDigest {
    public abstract void initHMAC(SymmetricKey var1) throws DigestException, InvalidKeyException;

    public void update(byte by) throws DigestException {
        byte[] byArray = new byte[]{by};
        this.update(byArray, 0, 1);
    }

    public abstract void update(byte[] var1, int var2, int var3) throws DigestException;

    public void update(byte[] byArray) throws DigestException {
        this.update(byArray, 0, byArray.length);
    }

    public byte[] digest() throws DigestException {
        byte[] byArray = new byte[this.getOutputSize()];
        this.digest(byArray, 0, byArray.length);
        return byArray;
    }

    public abstract int digest(byte[] var1, int var2, int var3) throws DigestException;

    public byte[] digest(byte[] byArray) throws DigestException {
        this.update(byArray);
        return this.digest();
    }

    public abstract void reset() throws DigestException;

    public abstract DigestAlgorithm getAlgorithm();

    public int getOutputSize() {
        return this.getAlgorithm().getOutputSize();
    }
}

