/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.TokenProxy;

public class JSSKeyStoreSpi
extends KeyStoreSpi {
    protected TokenProxy proxy;
    private CertificateFactory certFactory = null;

    public JSSKeyStoreSpi() {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            throw new RuntimeException(certificateException.getMessage());
        }
        CryptoToken cryptoToken = TokenSupplierManager.getTokenSupplier().getThreadToken();
        PK11Token pK11Token = (PK11Token)cryptoToken;
        this.proxy = pK11Token.getProxy();
    }

    private native HashSet getRawAliases();

    public Enumeration engineAliases() {
        return new IteratorEnumeration(this.getRawAliases().iterator());
    }

    public boolean engineContainsAlias(String string) {
        return this.getRawAliases().contains(string);
    }

    public native void engineDeleteEntry(String var1);

    public Certificate engineGetCertificate(String string) {
        byte[] byArray = this.getDERCert(string);
        if (byArray == null) {
            return null;
        }
        try {
            return this.certFactory.generateCertificate(new ByteArrayInputStream(byArray));
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            return null;
        }
    }

    private native byte[] getDERCert(String var1);

    private native X509Certificate getCertObject(String var1);

    public String engineGetCertificateAlias(Certificate certificate) {
        try {
            return this.getCertNickname(certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
    }

    private native String getCertNickname(byte[] var1);

    public Certificate[] engineGetCertificateChain(String string) {
        try {
            X509Certificate x509Certificate = this.getCertObject(string);
            if (x509Certificate == null) {
                return null;
            }
            CryptoManager cryptoManager = CryptoManager.getInstance();
            X509Certificate[] x509CertificateArray = cryptoManager.buildCertificateChain(x509Certificate);
            Certificate[] certificateArray = new Certificate[x509CertificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                certificateArray[i] = this.certFactory.generateCertificate(new ByteArrayInputStream(x509CertificateArray[i].getEncoded()));
            }
            return certificateArray;
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.toString());
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            throw new RuntimeException("CryptoManager not initialized");
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            return null;
        }
    }

    public Date engineGetCreationDate(String string) {
        return null;
    }

    public Key engineGetKey(String string, char[] cArray) {
        Object object = this.engineGetKeyNative(string, cArray);
        if (object instanceof SymmetricKey) {
            return new SecretKeyFacade((SymmetricKey)object);
        }
        return (Key)object;
    }

    public native Object engineGetKeyNative(String var1, char[] var2);

    public native boolean engineIsCertificateEntry(String var1);

    public boolean engineIsKeyEntry(String string) {
        return this.engineGetKey(string, null) != null;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        throw new KeyStoreException("Storing trusted certificate entries to a JSS KeyStore is not supported.");
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Storing plaintext keys is not supported.Store the key as a handle instead.");
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (key instanceof SecretKeyFacade) {
            SecretKeyFacade secretKeyFacade = (SecretKeyFacade)key;
            this.engineSetKeyEntryNative(string, secretKeyFacade.key, cArray, certificateArray);
        } else {
            this.engineSetKeyEntryNative(string, key, cArray, certificateArray);
        }
    }

    private native void engineSetKeyEntryNative(String var1, Object var2, char[] var3, Certificate[] var4) throws KeyStoreException;

    public int engineSize() {
        return this.getRawAliases().size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
    }

    private static class IteratorEnumeration
    implements Enumeration {
        private Iterator iter;

        public IteratorEnumeration(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }
}

