/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.TestCertApprovalCallback;
import org.mozilla.jss.ssl.TestClientCertificateSelectionCallback;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class JSS_FileUploadClient {
    private String clientCertNick = null;
    private String serverHost = null;
    private boolean TestCertCallBack = false;
    private boolean success = true;
    private int fCipher = -1;
    private int port = 29755;
    private String EOF = "test";
    private boolean handshakeCompleted = false;
    private CryptoManager cm = null;
    private CryptoToken tok = null;
    private PasswordCallback cb = null;
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private String fUploadFile = "foo.in";

    public void setCipher(int n) {
        this.fCipher = n;
    }

    public void setHostName(String string) {
        this.serverHost = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setPasswordFile(String string) {
        this.fPasswordFile = string;
    }

    public void setCertDbPath(String string) {
        this.fCertDbPath = string;
    }

    public void setUploadFile(String string) {
        this.fUploadFile = string;
    }

    public void setTestCertCallback(boolean bl) {
        this.TestCertCallBack = bl;
    }

    public void setClientCertNick(String string) {
        this.clientCertNick = string;
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeCompleted;
    }

    public void setHandshakeCompleted() {
        this.handshakeCompleted = true;
    }

    public void clearHandshakeCompleted() {
        this.handshakeCompleted = false;
    }

    public void setEOF(String string) {
        this.EOF = string;
    }

    public void doIt() throws Exception {
        try {
            CryptoManager.initialize(this.fCertDbPath);
            this.cm = CryptoManager.getInstance();
            this.tok = this.cm.getInternalKeyStorageToken();
            this.cb = new FilePasswordCallback(this.fPasswordFile);
            this.tok.login(this.cb);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = InetAddress.getByName(this.serverHost).getHostAddress();
        TestCertApprovalCallback testCertApprovalCallback = new TestCertApprovalCallback();
        TestClientCertificateSelectionCallback testClientCertificateSelectionCallback = new TestClientCertificateSelectionCallback();
        SSLSocket sSLSocket = null;
        sSLSocket = this.TestCertCallBack ? new SSLSocket(InetAddress.getByName(string), this.port, null, 0, (SSLCertificateApprovalCallback)new TestCertApprovalCallback(), null) : new SSLSocket(InetAddress.getByName(string), this.port);
        sSLSocket.setClientCertNickname(this.clientCertNick);
        if (this.fCipher != -1) {
            sSLSocket.setCipherPreference(this.fCipher, true);
        }
        sSLSocket.addHandshakeCompletedListener(new HandshakeListener("client", this));
        sSLSocket.forceHandshake();
        readWriteThread readWriteThread2 = new readWriteThread(sSLSocket, 0);
        readWriteThread2.start();
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static void main(String[] stringArray) {
        String string = "JSSCATestCert";
        String string2 = "1";
        String string3 = "localhost";
        int n = 29755;
        int n2 = 1;
        String string4 = null;
        String string5 = null;
        String string6 = "foo.in";
        String string7 = "\nUSAGE:\njava org.mozilla.jss.tests.JSS_FileUploadClient [# sockets] [JSS cipher integer]\n[certdb path] [password file] [upload test file]  [server host] [server port]";
        try {
            if (stringArray.length <= 0 || stringArray[0].toLowerCase().equals("-h")) {
                System.out.println(string7);
                System.exit(1);
            } else {
                n2 = new Integer(stringArray[0]);
                System.out.println("Socket Counter = " + n2);
            }
            string2 = stringArray[1];
            System.out.println("Test Cipher    = " + string2);
            if (stringArray.length >= 3) {
                string4 = stringArray[2];
                string5 = stringArray[3];
            }
            if (stringArray.length >= 5) {
                string6 = stringArray[4];
                string3 = stringArray[5];
                n = new Integer(stringArray[6]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Client connecting to server ...");
        for (int i = 0; i < n2; ++i) {
            JSS_FileUploadClient jSS_FileUploadClient = new JSS_FileUploadClient();
            try {
                if (!string3.equals("localhost")) {
                    jSS_FileUploadClient.setHostName(string3);
                }
                if (n != 29755) {
                    jSS_FileUploadClient.setPort(n);
                }
                jSS_FileUploadClient.setTestCertCallback(true);
                jSS_FileUploadClient.setClientCertNick(string);
                if (string4 != null) {
                    jSS_FileUploadClient.setCertDbPath(string4);
                }
                if (string5 != null) {
                    jSS_FileUploadClient.setPasswordFile(string5);
                }
                if (!string6.equals("foo.in")) {
                    jSS_FileUploadClient.setUploadFile(string6);
                }
                if (string2 == null) continue;
                try {
                    jSS_FileUploadClient.setCipher(new Integer(string2));
                    jSS_FileUploadClient.setEOF(string2);
                    jSS_FileUploadClient.doIt();
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
                System.exit(1);
            }
        }
        System.out.println("All " + n2 + " sockets created. Exiting");
        try {
            Thread.currentThread();
            Thread.sleep(300000L);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_FileUploadClient boss;

        public HandshakeListener(String string, JSS_FileUploadClient jSS_FileUploadClient2) {
            this.who = string;
            this.boss = jSS_FileUploadClient2;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
            JSS_FileUploadClient.this.setHandshakeCompleted();
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket clientSock = null;
        private int socketCntr = 0;

        public readWriteThread(SSLSocket sSLSocket, int n) {
            this.clientSock = sSLSocket;
            this.socketCntr = n;
        }

        public void run() {
            try {
                Object var1_1 = null;
                Object var2_3 = null;
                boolean bl = false;
                String string = null;
                OutputStream outputStream = this.clientSock.getOutputStream();
                System.out.println("Reading file foo.in");
                BufferedReader bufferedReader = new BufferedReader(new FileReader(JSS_FileUploadClient.this.fUploadFile));
                System.out.println("Successfully got a handle to " + JSS_FileUploadClient.this.fUploadFile);
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println("Read:" + string);
                    printWriter.println(string);
                    printWriter.flush();
                }
                bufferedReader.close();
                printWriter.close();
            }
            catch (Exception exception) {
                System.out.println("Exception caught" + exception.getMessage());
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

