/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.FilePasswordCallback;

public class JSS_SSLServer {
    private static Vector jssSupportedCiphers = new Vector();
    private static SSLServerSocket serverSock = null;
    private static SSLSocket sock = null;
    private String serverCertNick = null;
    private String serverHost = "localhost";
    private boolean TestInetAddress = false;
    private boolean success = true;
    private boolean bTestFipsMode = false;
    public int port = 29750;
    public static String usage = "USAGE: java JSS_SSLServer <cert db path> <passwords> <server_name> <servercertnick> [ true | false ] [ portNumber ] [ bypass ]";

    public static void main(String[] stringArray) throws Exception {
        try {
            new JSS_SSLServer().doIt(stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.currentThread();
            Thread.sleep(3500L);
            sock.close();
            serverSock.close();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Thread Interrupted, exiting normally ...\n");
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }

    public void doIt(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length < 4) {
            System.out.println(usage);
            System.exit(1);
        }
        CryptoManager.initialize(stringArray[0]);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
        FilePasswordCallback filePasswordCallback = new FilePasswordCallback(stringArray[1]);
        try {
            cryptoToken.login(filePasswordCallback);
        }
        catch (Exception exception) {
            System.out.println("unable to log into the token");
            exception.printStackTrace();
            System.exit(1);
        }
        this.serverHost = stringArray[2];
        this.serverCertNick = stringArray[3];
        if (stringArray.length >= 5 && stringArray[4].equalsIgnoreCase("true")) {
            this.TestInetAddress = true;
            System.out.println("testing Inet Address");
        }
        if (stringArray.length >= 6) {
            this.port = new Integer(stringArray[5]);
            System.out.println("using port: " + this.port);
        }
        if (stringArray.length >= 7 && stringArray[6].equalsIgnoreCase("bypass")) {
            SSLSocket.bypassPKCS11Default(true);
            System.out.println("enabled bypassPKCS11 mode for all sockets");
        }
        if (stringArray.length == 8 && stringArray[7].equalsIgnoreCase("fips")) {
            this.bTestFipsMode = true;
            System.out.println("testing in FIPS mode bypass must be off");
            SSLSocket.bypassPKCS11Default(false);
        }
        SSLServerSocket.configServerSessionIDCache(10, 100, 100, null);
        int[] nArray = SSLSocket.getImplementedCipherSuites();
        for (n = 0; n < nArray.length; ++n) {
            try {
                SSLSocket.setCipherPreferenceDefault(nArray[n], true);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
        SSLSocket.enableSSL2Default(false);
        if (this.bTestFipsMode) {
            SSLSocket.enableSSL3Default(false);
        }
        serverSock = this.TestInetAddress ? new SSLServerSocket(this.port, 5, InetAddress.getByName(this.serverHost), null, true) : new SSLServerSocket(this.port, 5, null, null, true);
        serverSock.setSoTimeout(120000);
        serverSock.requireClientAuth(21);
        serverSock.setServerCertNickname(this.serverCertNick);
        n = 1;
        while (n != 0) {
            try {
                sock = (SSLSocket)serverSock.accept();
            }
            catch (IOException iOException) {
                n = 0;
                System.out.println("Timeout occurred on the serversocket");
                break;
            }
            sock.addHandshakeCompletedListener(new HandshakeListener("server", this));
            InputStream inputStream = sock.getInputStream();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                if (string.equals("null")) {
                    n = 0;
                } else if (string != null) {
                    jssSupportedCiphers.add(string);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                n = 0;
            }
            sock.close();
        }
        serverSock.close();
        System.out.println("Server exiting");
        System.out.println("---------------------------------------------------------");
        System.out.println("Summary of JSSE client to JSS server communication test :");
        System.out.println("---------------------------------------------------------");
        for (int i = 0; i < jssSupportedCiphers.size(); ++i) {
            System.out.println("[" + i + "]\t" + jssSupportedCiphers.elementAt(i));
        }
        System.out.println("---------------------------------------------------------");
        System.out.println("Please note that in JDK 5.0 the same set of ");
        System.out.println("ciphers are exercised for SSLv3 and TLS.");
        System.out.println("---------------------------------------------------------");
        System.out.flush();
        if (this.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SSLServer boss;

        public HandshakeListener(String string, JSS_SSLServer jSS_SSLServer) {
            this.who = string;
            this.boss = jSS_SSLServer;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
        }
    }
}

