/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.server.repository.VRegistry;
import java.util.Date;
import java.util.Properties;

public class ServiceInfoImpl
extends LibInfoImpl
implements ServiceInfo,
Cloneable {
    private static final long serialVersionUID = -3162847516320098460L;
    private String[] interfaces = null;
    private String classname = null;
    private int implType = 0;
    private String helpBase = null;
    private String APIversion = "0.0";
    private boolean bSingle = true;
    private String[] scopeList = null;
    private String[] parameterList = null;
    private String[] dependency = null;
    private Date editDate = null;
    private LibInfoImpl[] attachments = null;
    public static final String PROPERTY_CONFIG_TOOL = "config-tool";
    public static final String PROPERTY_IS_DAEMON = "is-daemon";

    public ServiceInfoImpl(ServiceInfo serviceInfo) {
        super((ComponentInfo)serviceInfo);
        if (serviceInfo != null) {
            this.interfaces = serviceInfo.getInterfaces();
            this.classname = serviceInfo.getClassName();
            this.implType = serviceInfo.getImplType();
            this.helpBase = serviceInfo.getHelpBaseName();
            this.APIversion = serviceInfo.getAPIVersion();
            this.parameterList = serviceInfo.getParameterList();
            this.scopeList = serviceInfo.getSupportedScopes();
            this.bSingle = serviceInfo.isSingleton();
            this.dependency = serviceInfo.getLoadDependencies();
            if (serviceInfo instanceof ServiceInfoImpl) {
                this.editDate = ((ServiceInfoImpl)serviceInfo).getEditDate();
                this.attachments = ((ServiceInfoImpl)serviceInfo).getAttachments();
            }
            if (this.attachments == null) {
                this.attachments = new LibInfoImpl[0];
            }
            if (this.editDate == null) {
                this.editDate = new Date();
            }
            if (this.getJarName() == null) {
                this.setJarName(VRegistry.toJarName(1, this.classname));
            }
        }
    }

    public ServiceInfoImpl(String string, int n, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2, Properties properties, boolean bl, String[] stringArray3, String[] stringArray4, String string6) {
        super(string4, string2, properties, string6);
        this.classname = string;
        this.implType = n;
        this.interfaces = stringArray;
        this.helpBase = string3;
        this.APIversion = string5;
        this.parameterList = stringArray2;
        this.scopeList = stringArray3;
        this.bSingle = bl;
        this.dependency = stringArray4;
        this.setJarName(VRegistry.toJarName(2, this.classname));
        this.setComponentType(2);
        this.attachments = new LibInfoImpl[0];
        this.editDate = new Date();
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public String getClassName() {
        return this.classname;
    }

    public int getImplType() {
        return this.implType;
    }

    public String getHelpBaseName() {
        return this.helpBase;
    }

    public String getConfigToolName() {
        return this.getProperty(PROPERTY_CONFIG_TOOL);
    }

    public String getAPIVersion() {
        return this.APIversion;
    }

    public boolean isSingleton() {
        return this.bSingle;
    }

    public boolean isDaemon() {
        String string = this.getProperty(PROPERTY_IS_DAEMON);
        return string != null && string.trim().equalsIgnoreCase("true");
    }

    public String[] getLoadDependencies() {
        return this.dependency;
    }

    public String[] getParameterList() {
        return this.parameterList;
    }

    public String[] getSupportedScopes() {
        return this.scopeList;
    }

    public Date getEditDate() {
        return this.editDate;
    }

    public LibInfoImpl[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(LibInfoImpl[] libInfoImplArray) {
        this.attachments = libInfoImplArray != null ? libInfoImplArray : new LibInfoImpl[]{};
        this.editDate = new Date();
    }

    public String[] getJarPaths() {
        String[] stringArray = new String[1 + this.attachments.length];
        stringArray[0] = this.getJarPath();
        int n = 0;
        while (n < this.attachments.length) {
            stringArray[1 + n] = this.attachments[n].getJarPath();
            ++n;
        }
        return stringArray;
    }

    public synchronized Object clone() {
        return new ServiceInfoImpl(this);
    }

    public String toString() {
        return "Service info:\n\timpl-class=" + this.getClassName() + "\n\timpl-type=" + (this.implType == 0 ? "proxy" : "provider") + "\n\tinterfaces=" + this.printArray(this.getInterfaces()) + "\n\thelp-base=" + this.getHelpBaseName() + "\n\tapi-version=" + this.getAPIVersion() + "\n\tis-singleton=" + this.isSingleton() + "\n\tis-daemon=" + this.isDaemon() + "\n\tconfig-tool=" + this.getConfigToolName() + "\n\tdependencies=" + this.printArray(this.getLoadDependencies()) + "\n\tparam-list=" + this.printArray(this.getParameterList()) + "\n\tsupported-scopes=" + this.printArray(this.getSupportedScopes()) + "\n" + "\n\tlast-modified=" + this.getEditDate() + "\n\tattachments=" + this.printArray(this.getAttachments()) + "\n" + super.toString();
    }
}

