/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.connector.HttpRequestFacade;
import org.apache.catalina.connector.RequestBase;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;

public class HttpRequestBase
extends RequestBase
implements HttpRequest,
HttpServletRequest {
    protected String authType = null;
    protected String contextPath = "";
    protected ArrayList cookies = new ArrayList();
    protected static ArrayList empty = new ArrayList();
    protected SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected HttpRequestFacade facade = new HttpRequestFacade(this);
    protected HashMap headers = new HashMap();
    protected static final String info = "org.apache.catalina.connector.HttpRequestBase/1.0";
    protected String method = null;
    protected ParameterMap parameters = null;
    protected boolean parsed = false;
    protected String pathInfo = null;
    protected String queryString = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected String requestURI = null;
    protected boolean secure = false;
    protected String servletPath = null;
    protected Session session = null;
    protected Principal userPrincipal = null;

    public void addCookie(Cookie cookie) {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.add(cookie);
        }
    }

    public void addHeader(String name, String value) {
        name = name.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList<String> values = (ArrayList<String>)this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
        }
    }

    public void addParameter(String name, String[] values) {
        ParameterMap parameterMap = this.parameters;
        synchronized (parameterMap) {
            this.parameters.put(name, values);
        }
    }

    public void clearCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.clear();
        }
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
        if (this.parameters != null) {
            this.parameters.setLocked(false);
            this.parameters.clear();
        } else {
            this.parameters = new ParameterMap();
        }
    }

    private HttpSession doGetSession(boolean create) {
        if (this.context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session.getSession();
        }
        Manager manager = null;
        if (this.context != null) {
            manager = this.context.getManager();
        }
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            try {
                this.session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException iOException) {
                this.session = null;
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                return this.session.getSession();
            }
        }
        if (!create) {
            return null;
        }
        if (this.context != null && this.response != null && this.context.getCookies() && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(RequestBase.sm.getString("httpRequestBase.createCommitted"));
        }
        this.session = manager.createSession();
        if (this.session != null) {
            return this.session.getSession();
        }
        return null;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            if (this.cookies.size() < 1) {
                Cookie[] cookieArray = null;
                Object var3_4 = null;
                return cookieArray;
            }
            Cookie[] results = new Cookie[this.cookies.size()];
            Cookie[] cookieArray = this.cookies.toArray(results);
            Object var3_5 = null;
            return cookieArray;
        }
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        value = String.valueOf(value) + " ";
        int i = 0;
        while (i < this.formats.length) {
            try {
                Date date = this.formats[i].parse(value);
                return date.getTime();
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        name = name.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList values = (ArrayList)this.headers.get(name);
            if (values != null) {
                String string = (String)values.get(0);
                Object var4_6 = null;
                return string;
            }
            String string = null;
            Object var4_7 = null;
            return string;
        }
    }

    public Enumeration getHeaderNames() {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            Enumerator enumerator = new Enumerator(this.headers.keySet());
            Object var3_3 = null;
            return enumerator;
        }
    }

    public Enumeration getHeaders(String name) {
        name = name.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList values = (ArrayList)this.headers.get(name);
            if (values != null) {
                Enumerator enumerator = new Enumerator(values);
                Object var4_6 = null;
                return enumerator;
            }
            Enumerator enumerator = new Enumerator(empty);
            Object var4_7 = null;
            return enumerator;
        }
    }

    public String getInfo() {
        return info;
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String name) {
        this.parseParameters();
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        this.parseParameters();
        return new Enumerator(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        this.parseParameters();
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values;
        }
        return null;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.context == null) {
            return null;
        }
        if (this.pathInfo == null) {
            return null;
        }
        return this.context.getServletContext().getRealPath(this.pathInfo);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public ServletRequest getRequest() {
        return this.facade;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.context == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        int pos = servletPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? RequestUtil.normalize(String.valueOf(servletPath.substring(0, pos + 1)) + path) : RequestUtil.normalize(String.valueOf(servletPath) + path);
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (System.getSecurityManager() != null) {
            PrivilegedGetSession dp = new PrivilegedGetSession(create);
            return (HttpSession)AccessController.doPrivileged(dp);
        }
        return this.doGetSession(create);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionCookie;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionURL;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return false;
        }
        Session session = null;
        try {
            session = manager.findSession(this.requestedSessionId);
        }
        catch (IOException iOException) {
            session = null;
        }
        return session != null && session.isValid();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isUserInRole(String role) {
        String realRole;
        if (this.userPrincipal == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        if (this.wrapper != null && (realRole = this.wrapper.findSecurityReference(role)) != null && realm.hasRole(this.userPrincipal, realRole)) {
            return true;
        }
        return realm.hasRole(this.userPrincipal, role);
    }

    protected void parseParameters() {
        int semicolon;
        if (this.parsed) {
            return;
        }
        ParameterMap results = this.parameters;
        if (results == null) {
            results = new ParameterMap();
        }
        results.setLocked(false);
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        String queryString = this.getQueryString();
        try {
            RequestUtil.parseParameters((Map)results, queryString, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim();
        if ("POST".equals(this.getMethod()) && this.getContentLength() > 0 && this.stream == null && "application/x-www-form-urlencoded".equals(contentType)) {
            try {
                int max = this.getContentLength();
                int len = 0;
                byte[] buf = new byte[this.getContentLength()];
                ServletInputStream is = this.getInputStream();
                while (len < max) {
                    int next = is.read(buf, len, max - len);
                    if (next < 0) break;
                    len += next;
                }
                is.close();
                if (len < max) {
                    throw new RuntimeException(RequestBase.sm.getString("httpRequestBase.contentLengthMismatch"));
                }
                RequestUtil.parseParameters((Map)results, buf, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException e) {
                throw new RuntimeException(String.valueOf(RequestBase.sm.getString("httpRequestBase.contentReadFail")) + e.getMessage());
            }
        }
        results.setLocked(true);
        this.parsed = true;
        this.parameters = results;
    }

    public void recycle() {
        super.recycle();
        this.authType = null;
        this.contextPath = "";
        this.cookies.clear();
        this.headers.clear();
        this.method = null;
        if (this.parameters != null) {
            this.parameters.setLocked(false);
            this.parameters.clear();
        }
        this.parsed = false;
        this.pathInfo = null;
        this.queryString = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionURL = false;
        this.requestURI = null;
        this.secure = false;
        this.servletPath = null;
        this.session = null;
        this.userPrincipal = null;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setContextPath(String path) {
        this.contextPath = path == null ? "" : path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPathInfo(String path) {
        this.pathInfo = path;
    }

    public void setQueryString(String query) {
        this.queryString = query;
    }

    public void setRequestURI(String uri) {
        this.requestURI = uri;
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    public void setRequestedSessionId(String id) {
        this.requestedSessionId = id;
    }

    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServletPath(String path) {
        this.servletPath = path;
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    protected class PrivilegedGetSession
    implements PrivilegedAction {
        private boolean create;

        PrivilegedGetSession(boolean create) {
            this.create = create;
        }

        public Object run() {
            return HttpRequestBase.this.doGetSession(this.create);
        }
    }
}

