/*
 * Decompiled with CFR 0.152.
 */
package com.sun.audit;

import java.io.Serializable;
import java.util.Stack;

public class AuditSession
implements Serializable {
    private static boolean library_loaded = false;
    private byte[] sh;
    private Stack stateStack = new Stack();
    boolean AuditIsOn = true;
    boolean ValidSession = true;
    public static final int ADT_NEW = 0;
    public static final int ADT_UPDATE = 1;
    public static final int ADT_USER = 2;

    private native boolean bsmAuditOn();

    private native byte[] startSession(byte[] var1, long var2) throws Error;

    private native byte[] dupSession(byte[] var1) throws Error;

    private native void endSession(byte[] var1) throws Error;

    private native String getSessionId(byte[] var1) throws Error;

    private native byte[] exportSessionData(byte[] var1) throws Error;

    private native void sessionAttr(byte[] var1, int var2, int var3, int var4, int var5, String var6, int var7) throws Error;

    public AuditSession(byte[] byArray) {
        if (!library_loaded) {
            this.ValidSession = false;
            this.AuditIsOn = false;
            this.sh = new byte[8];
            return;
        }
        this.AuditIsOn = this.bsmAuditOn();
        try {
            this.sh = this.startSession(byArray, 0L);
        }
        catch (Exception exception) {
            this.ValidSession = false;
            this.sh = new byte[8];
        }
        catch (Error error) {
            this.ValidSession = false;
            this.sh = new byte[8];
            throw error;
        }
    }

    byte[] getSession() {
        return this.sh;
    }

    public String getSessionId() throws Exception {
        String string;
        if (this.ValidSession) {
            try {
                string = this.getSessionId(this.sh);
            }
            catch (Exception exception) {
                Object var1_2 = null;
                throw exception;
            }
            catch (Error error) {
                Object var1_3 = null;
                throw error;
            }
        } else {
            string = null;
        }
        return string;
    }

    public boolean auditOn() {
        return this.ValidSession;
    }

    public void finalize() {
        while (!this.stateStack.empty()) {
            byte[] byArray = (byte[])this.stateStack.pop();
            this.endSession(byArray);
        }
        this.endSession(this.sh);
    }

    public byte[] exportSession() throws Exception {
        byte[] byArray;
        if (this.ValidSession) {
            byArray = this.exportSessionData(this.sh);
        } else {
            byArray = null;
        }
        return byArray;
    }

    public void setUser(int n, int n2, int n3, int n4, String string, int n5) {
        if (this.ValidSession) {
            this.sessionAttr(this.sh, n, n2, n3, n4, string, n5);
        }
    }

    public void pushState() throws Exception {
        byte[] byArray = this.dupSession(this.sh);
        this.stateStack.push(this.sh);
        this.sh = byArray;
    }

    public void popState() throws Exception {
        this.endSession(this.sh);
        this.sh = (byte[])this.stateStack.pop();
    }

    public void setLabel(String string) throws Exception {
    }

    static {
        try {
            System.loadLibrary("adt_jni");
            library_loaded = true;
        }
        catch (Exception exception) {
            library_loaded = false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            library_loaded = false;
        }
    }
}

