/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.MOFFormatter;

public class CIMQualifier
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private CIMValue value;
    private Vector flavors = new Vector();

    public CIMValue getValue() {
        return this.value;
    }

    public void setValue(CIMValue cIMValue) {
        this.value = cIMValue;
    }

    public void setDefaults(CIMQualifierType cIMQualifierType) {
        if (!this.hasValue() && cIMQualifierType.hasDefaultValue()) {
            CIMValue cIMValue = cIMQualifierType.getDefaultValue();
            this.value = cIMValue.getType() == null && cIMQualifierType.getType() != null ? new CIMValue(cIMValue.getValue(), cIMQualifierType.getType()) : cIMValue;
        }
        if (this.flavors == null || this.flavors.size() == 0) {
            this.flavors = (Vector)cIMQualifierType.getFlavor().clone();
        }
    }

    public boolean hasFlavor(CIMFlavor cIMFlavor) {
        if (this.flavors == null) {
            return false;
        }
        Enumeration enumeration = this.flavors.elements();
        while (enumeration.hasMoreElements()) {
            if (!((CIMFlavor)enumeration.nextElement()).equals(cIMFlavor)) continue;
            return true;
        }
        return false;
    }

    public void addFlavor(CIMFlavor cIMFlavor) {
        if (!this.hasFlavor(cIMFlavor)) {
            this.flavors.addElement(cIMFlavor);
        }
    }

    public CIMQualifier() {
        super("");
    }

    public CIMQualifier(String string) {
        super(string);
        this.value = null;
        this.flavors = new Vector();
    }

    public CIMQualifier(String string, CIMQualifierType cIMQualifierType) {
        this(string);
        this.setDefaults(cIMQualifierType);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CIMQualifier)) {
            return false;
        }
        return super.equals(object);
    }

    public synchronized Object clone() {
        CIMQualifier cIMQualifier = new CIMQualifier();
        cIMQualifier.name = this.name;
        cIMQualifier.identifier = this.identifier;
        cIMQualifier.value = this.value;
        cIMQualifier.flavors = (Vector)this.flavors.clone();
        return cIMQualifier;
    }

    public Vector getFlavor() {
        return this.flavors;
    }
}

