/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.query;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.StringCharacterIterator;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.query.DateTimeExp;
import javax.wbem.query.NumericValue;
import javax.wbem.query.QueryExp;
import javax.wbem.query.StringValueExp;
import javax.wbem.query.ValueExp;

public class BinaryRelQueryExp
extends QueryExp {
    private int relOp;
    private ValueExp expOne;
    private ValueExp expTwo;

    public BinaryRelQueryExp(int n, ValueExp valueExp, ValueExp valueExp2) {
        this.relOp = n;
        this.expOne = valueExp;
        this.expTwo = valueExp2;
    }

    public BinaryRelQueryExp() {
    }

    public int getOperator() {
        return this.relOp;
    }

    public ValueExp getLeftValue() {
        return this.expOne;
    }

    public ValueExp getRightValue() {
        return this.expTwo;
    }

    public boolean apply(CIMElement cIMElement) throws CIMException {
        return this.doApply(this.expOne.apply(cIMElement), this.expTwo.apply(cIMElement));
    }

    private boolean doApply(Object object, Object object2) throws CIMException {
        Serializable serializable;
        Serializable serializable2;
        boolean bl = object instanceof NumericValue;
        if (object == null || object2 == null) {
            return false;
        }
        if (bl) {
            serializable2 = new BigDecimal(object.toString());
            serializable = new BigDecimal(object2.toString());
            switch (this.relOp) {
                case 0: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) > 0;
                }
                case 1: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) < 0;
                }
                case 2: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) >= 0;
                }
                case 3: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) <= 0;
                }
                case 4: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) == 0;
                }
                case 5: {
                    return ((BigDecimal)serializable2).compareTo((BigDecimal)serializable) != 0;
                }
            }
        }
        if (object instanceof DateTimeExp || object2 instanceof DateTimeExp) {
            if (!(object instanceof DateTimeExp)) {
                try {
                    object = new DateTimeExp(((StringValueExp)object).getValue());
                }
                catch (Exception exception) {
                    throw new CIMException("CIM_ERR_FAILED", object.toString());
                }
            }
            serializable2 = ((DateTimeExp)object).getValue();
            if (!(object2 instanceof DateTimeExp)) {
                try {
                    object2 = new DateTimeExp(((StringValueExp)object2).getValue());
                }
                catch (Exception exception) {
                    throw new CIMException("CIM_ERR_FAILED", object2.toString());
                }
            }
            serializable = ((DateTimeExp)object2).getValue();
            switch (this.relOp) {
                case 0: {
                    return ((CIMDateTime)serializable2).after((CIMDateTime)serializable);
                }
                case 1: {
                    return ((CIMDateTime)serializable2).before((CIMDateTime)serializable);
                }
                case 2: {
                    return ((CIMDateTime)serializable2).after((CIMDateTime)serializable) || ((CIMDateTime)serializable2).equals(serializable);
                }
                case 3: {
                    return ((CIMDateTime)serializable2).before((CIMDateTime)serializable) || ((CIMDateTime)serializable2).equals(serializable);
                }
                case 4: {
                    return ((CIMDateTime)serializable2).equals(serializable);
                }
                case 5: {
                    return !((CIMDateTime)serializable2).equals(serializable);
                }
            }
        } else {
            String string = ((StringValueExp)object).getValue();
            String string2 = ((StringValueExp)object2).getValue();
            switch (this.relOp) {
                case 0: {
                    return string.compareTo(string2) > 0;
                }
                case 1: {
                    return string.compareTo(string2) < 0;
                }
                case 2: {
                    return string.compareTo(string2) >= 0;
                }
                case 3: {
                    return string.compareTo(string2) <= 0;
                }
                case 4: {
                    return string.compareTo(string2) == 0;
                }
                case 5: {
                    return string.compareTo(string2) != 0;
                }
                case 6: {
                    return this.like(string, string2);
                }
                case 7: {
                    return !this.like(string, string2);
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.expOne + " " + this.relOpString() + " " + this.expTwo;
    }

    private String relOpString() {
        switch (this.relOp) {
            case 0: {
                return ">";
            }
            case 1: {
                return "<";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "=";
            }
            case 5: {
                return "<>";
            }
            case 6: {
                return "LIKE";
            }
            case 7: {
                return "NOT LIKE";
            }
            case 8: {
                return "ISA";
            }
            case 9: {
                return "NOT ISA";
            }
        }
        return "=";
    }

    private String trimPercent(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 65535;
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c != '%' || n != 37) {
                stringBuffer.append(c);
            }
            n = c;
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    private boolean like(String string, String string2) {
        int n = -1;
        int n2 = 0;
        int n3 = -1;
        char c = '\uffff';
        int n4 = string.length();
        string2 = this.trimPercent(string2);
        int n5 = string2.length() - 1;
        int n6 = 0;
        while (n6 < n4) {
            char c2;
            if (n2 > n5) {
                return false;
            }
            char c3 = string2.charAt(n2);
            if (c3 == '%') {
                n = n2;
                if (n2 == n5) {
                    return true;
                }
                c2 = string.charAt(n6);
                if (c2 == string2.charAt(n2 + 1)) {
                    n2 += 2;
                    c = c2;
                    n3 = -1;
                }
            } else {
                c2 = string.charAt(n6);
                if (n3 == -1 && c2 == c) {
                    n3 = n6;
                }
                if (c2 != c3) {
                    if (n == -1) {
                        return false;
                    }
                    n2 = n;
                    if (n3 != -1) {
                        n6 = n3 - 1;
                        n3 = -1;
                    }
                } else {
                    ++n2;
                }
            }
            ++n6;
        }
        return n2 > n5 || n2 == n5 && string2.charAt(n5) == '%';
    }
}

