/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.BadPaddingException;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.util.Assert;

public abstract class Cipher {
    public abstract void initEncrypt(SymmetricKey var1) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException;

    public abstract void initDecrypt(SymmetricKey var1) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException;

    public abstract void initEncrypt(SymmetricKey var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException;

    public abstract void initDecrypt(SymmetricKey var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException;

    public abstract byte[] update(byte[] var1) throws IllegalStateException, TokenException;

    public abstract byte[] update(byte[] var1, int var2, int var3) throws IllegalStateException, TokenException;

    public abstract byte[] doFinal(byte[] var1) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException;

    public abstract byte[] doFinal(byte[] var1, int var2, int var3) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException;

    public abstract byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException;

    public static byte[] pad(byte[] byArray, int n) {
        Assert._assert(n > 0);
        byte by = (byte)(n - byArray.length % n);
        byte[] byArray2 = new byte[byArray.length + by];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (int i = byArray.length; i < byArray2.length; ++i) {
            byArray2[i] = by;
        }
        return byArray2;
    }

    public static byte[] unPad(byte[] byArray, int n) throws BadPaddingException {
        if (byArray.length == 0) {
            return new byte[0];
        }
        if (byArray.length < n) {
            throw new BadPaddingException("Length of padded array is less than one block");
        }
        byte by = byArray[byArray.length - 1];
        if (by > n) {
            throw new BadPaddingException("Padding octet (" + by + ") is " + "larger than block size (" + n + ")");
        }
        if (by < 1) {
            throw new BadPaddingException("Padding octet is less than 1");
        }
        byte[] byArray2 = new byte[byArray.length - by];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static byte[] unPad(byte[] byArray) throws BadPaddingException {
        if (byArray.length == 0) {
            return new byte[0];
        }
        byte by = byArray[byArray.length - 1];
        if (by < 1) {
            throw new BadPaddingException("Padding octet is less than 1");
        }
        if (by >= byArray.length) {
            throw new BadPaddingException("Padding is larger than entire array");
        }
        byte[] byArray2 = new byte[byArray.length - by];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

