/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.TeletexString;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.asn1.UniversalString;
import org.mozilla.jss.util.Assert;

public class DirectoryString
implements ASN1Value {
    private CharacterString asn1String;
    private static final Template templateInstance = new Template();

    private DirectoryString() {
    }

    public DirectoryString(String string) throws CharConversionException {
        try {
            try {
                this.asn1String = new PrintableString(string);
            }
            catch (CharConversionException charConversionException) {
                this.asn1String = new TeletexString(string);
            }
        }
        catch (CharConversionException charConversionException) {
            this.asn1String = new UniversalString(string);
        }
    }

    public DirectoryString(CharacterString characterString) {
        if (!(characterString instanceof PrintableString || characterString instanceof BMPString || characterString instanceof UTF8String || characterString instanceof TeletexString || characterString instanceof UniversalString)) {
            throw new IllegalArgumentException("DirectoryString must be TeletexString, PrintableString, UniversalString, UTF8STring, or BMPString");
        }
        this.asn1String = characterString;
    }

    public String toString() {
        return this.asn1String.toString();
    }

    public Tag getTag() {
        return this.asn1String.getTag();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.asn1String.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.asn1String.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(PrintableString.getTemplate());
            this.choicet.addElement(BMPString.getTemplate());
            this.choicet.addElement(UTF8String.getTemplate());
            this.choicet.addElement(TeletexString.getTemplate());
            this.choicet.addElement(UniversalString.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            CHOICE cHOICE = (CHOICE)this.choicet.decode(inputStream);
            return new DirectoryString((CharacterString)cHOICE.getValue());
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            Assert._assert(this.tagMatch(tag));
            return this.decode(inputStream);
        }
    }
}

