/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.security;

import org.apache.java.lang.Bytes;
import org.apache.java.security.MessageDigest;

public final class MD5
extends MessageDigest {
    private long counter;
    private int reminder;
    private byte[] buffer;
    private int[] state;
    private int[] x;
    static byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static String[] messages = new String[]{"", "a", "abc", "message digest", "abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "12345678901234567890123456789012345678901234567890123456789012345678901234567890"};
    private static String[] digests = new String[]{"d41d8cd98f00b204e9800998ecf8427e", "0cc175b9c0f1b6a831c399e269772661", "900150983cd24fb0d6963f7d28e17f72", "f96b697d7cb7938d525a2f31aaf161d0", "c3fcd3d76192e4007dfb496cca67e13b", "d174ab98d277d9f5a5611c2c9f419d9f", "57edf4a22be3c955ac49da2e2107b67a"};

    public void reset() {
        this.buffer = new byte[64];
        this.state = new int[4];
        this.x = new int[16];
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.counter = 0L;
        this.reminder = 64;
    }

    public void append(byte[] byArray, int n, int n2) {
        while (n2 >= this.reminder) {
            System.arraycopy(byArray, n, this.buffer, (int)(this.counter & 0x3FL), this.reminder);
            this.transform(this.buffer);
            this.counter += (long)this.reminder;
            n += this.reminder;
            n2 -= this.reminder;
            this.reminder = 64;
        }
        System.arraycopy(byArray, n, this.buffer, (int)(this.counter & 0x3FL), n2);
        this.counter += (long)n2;
        this.reminder -= n2;
    }

    public byte[] digest(byte[] byArray, int n, int n2) {
        this.append(byArray, n, n2);
        byte[] byArray2 = MD5.toBytes(this.counter << 3);
        byte[] byArray3 = new byte[16];
        if (this.reminder > 8) {
            this.append(padding, 0, this.reminder - 8);
        } else {
            this.append(padding, 0, 64 + (this.reminder - 8));
        }
        this.append(byArray2, 0, 8);
        MD5.int2byte(this.state, byArray3);
        this.reset();
        return byArray3;
    }

    private static void byte2int(byte[] byArray, int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 16) {
            nArray[n2] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
            ++n2;
        }
    }

    private static void int2byte(int[] nArray, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n < 4) {
            byArray[n2++] = (byte)(nArray[n] & 0xFF);
            byArray[n2++] = (byte)(nArray[n] >>> 8 & 0xFF);
            byArray[n2++] = (byte)(nArray[n] >>> 16 & 0xFF);
            byArray[n2++] = (byte)(nArray[n] >>> 24 & 0xFF);
            ++n;
        }
    }

    public static byte[] toBytes(long l) {
        byte[] byArray = new byte[]{(byte)l, (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8), (byte)(l >>>= 8)};
        return byArray;
    }

    private static int F(int n, int n2, int n3) {
        return n3 ^ n & (n2 ^ n3);
    }

    private static int G(int n, int n2, int n3) {
        return n2 ^ n3 & (n ^ n2);
    }

    private static int H(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private static int I(int n, int n2, int n3) {
        return n2 ^ (n | ~n3);
    }

    private static int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += n5 + n7 + MD5.F(n2, n3, n4);
        n = n << n6 | n >>> -n6;
        return n + n2;
    }

    private static int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += n5 + n7 + MD5.G(n2, n3, n4);
        n = n << n6 | n >>> -n6;
        return n + n2;
    }

    private static int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += n5 + n7 + MD5.H(n2, n3, n4);
        n = n << n6 | n >>> -n6;
        return n + n2;
    }

    private static int II(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += n5 + n7 + MD5.I(n2, n3, n4);
        n = n << n6 | n >>> -n6;
        return n + n2;
    }

    private void transform(byte[] byArray) {
        MD5.byte2int(byArray, this.x);
        int n = this.state[0];
        int n2 = this.state[1];
        int n3 = this.state[2];
        int n4 = this.state[3];
        n = MD5.FF(n, n2, n3, n4, this.x[0], 7, -680876936);
        n4 = MD5.FF(n4, n, n2, n3, this.x[1], 12, -389564586);
        n3 = MD5.FF(n3, n4, n, n2, this.x[2], 17, 606105819);
        n2 = MD5.FF(n2, n3, n4, n, this.x[3], 22, -1044525330);
        n = MD5.FF(n, n2, n3, n4, this.x[4], 7, -176418897);
        n4 = MD5.FF(n4, n, n2, n3, this.x[5], 12, 1200080426);
        n3 = MD5.FF(n3, n4, n, n2, this.x[6], 17, -1473231341);
        n2 = MD5.FF(n2, n3, n4, n, this.x[7], 22, -45705983);
        n = MD5.FF(n, n2, n3, n4, this.x[8], 7, 1770035416);
        n4 = MD5.FF(n4, n, n2, n3, this.x[9], 12, -1958414417);
        n3 = MD5.FF(n3, n4, n, n2, this.x[10], 17, -42063);
        n2 = MD5.FF(n2, n3, n4, n, this.x[11], 22, -1990404162);
        n = MD5.FF(n, n2, n3, n4, this.x[12], 7, 1804603682);
        n4 = MD5.FF(n4, n, n2, n3, this.x[13], 12, -40341101);
        n3 = MD5.FF(n3, n4, n, n2, this.x[14], 17, -1502002290);
        n2 = MD5.FF(n2, n3, n4, n, this.x[15], 22, 1236535329);
        n = MD5.GG(n, n2, n3, n4, this.x[1], 5, -165796510);
        n4 = MD5.GG(n4, n, n2, n3, this.x[6], 9, -1069501632);
        n3 = MD5.GG(n3, n4, n, n2, this.x[11], 14, 643717713);
        n2 = MD5.GG(n2, n3, n4, n, this.x[0], 20, -373897302);
        n = MD5.GG(n, n2, n3, n4, this.x[5], 5, -701558691);
        n4 = MD5.GG(n4, n, n2, n3, this.x[10], 9, 38016083);
        n3 = MD5.GG(n3, n4, n, n2, this.x[15], 14, -660478335);
        n2 = MD5.GG(n2, n3, n4, n, this.x[4], 20, -405537848);
        n = MD5.GG(n, n2, n3, n4, this.x[9], 5, 568446438);
        n4 = MD5.GG(n4, n, n2, n3, this.x[14], 9, -1019803690);
        n3 = MD5.GG(n3, n4, n, n2, this.x[3], 14, -187363961);
        n2 = MD5.GG(n2, n3, n4, n, this.x[8], 20, 1163531501);
        n = MD5.GG(n, n2, n3, n4, this.x[13], 5, -1444681467);
        n4 = MD5.GG(n4, n, n2, n3, this.x[2], 9, -51403784);
        n3 = MD5.GG(n3, n4, n, n2, this.x[7], 14, 1735328473);
        n2 = MD5.GG(n2, n3, n4, n, this.x[12], 20, -1926607734);
        n = MD5.HH(n, n2, n3, n4, this.x[5], 4, -378558);
        n4 = MD5.HH(n4, n, n2, n3, this.x[8], 11, -2022574463);
        n3 = MD5.HH(n3, n4, n, n2, this.x[11], 16, 1839030562);
        n2 = MD5.HH(n2, n3, n4, n, this.x[14], 23, -35309556);
        n = MD5.HH(n, n2, n3, n4, this.x[1], 4, -1530992060);
        n4 = MD5.HH(n4, n, n2, n3, this.x[4], 11, 1272893353);
        n3 = MD5.HH(n3, n4, n, n2, this.x[7], 16, -155497632);
        n2 = MD5.HH(n2, n3, n4, n, this.x[10], 23, -1094730640);
        n = MD5.HH(n, n2, n3, n4, this.x[13], 4, 681279174);
        n4 = MD5.HH(n4, n, n2, n3, this.x[0], 11, -358537222);
        n3 = MD5.HH(n3, n4, n, n2, this.x[3], 16, -722521979);
        n2 = MD5.HH(n2, n3, n4, n, this.x[6], 23, 76029189);
        n = MD5.HH(n, n2, n3, n4, this.x[9], 4, -640364487);
        n4 = MD5.HH(n4, n, n2, n3, this.x[12], 11, -421815835);
        n3 = MD5.HH(n3, n4, n, n2, this.x[15], 16, 530742520);
        n2 = MD5.HH(n2, n3, n4, n, this.x[2], 23, -995338651);
        n = MD5.II(n, n2, n3, n4, this.x[0], 6, -198630844);
        n4 = MD5.II(n4, n, n2, n3, this.x[7], 10, 1126891415);
        n3 = MD5.II(n3, n4, n, n2, this.x[14], 15, -1416354905);
        n2 = MD5.II(n2, n3, n4, n, this.x[5], 21, -57434055);
        n = MD5.II(n, n2, n3, n4, this.x[12], 6, 1700485571);
        n4 = MD5.II(n4, n, n2, n3, this.x[3], 10, -1894986606);
        n3 = MD5.II(n3, n4, n, n2, this.x[10], 15, -1051523);
        n2 = MD5.II(n2, n3, n4, n, this.x[1], 21, -2054922799);
        n = MD5.II(n, n2, n3, n4, this.x[8], 6, 1873313359);
        n4 = MD5.II(n4, n, n2, n3, this.x[15], 10, -30611744);
        n3 = MD5.II(n3, n4, n, n2, this.x[6], 15, -1560198380);
        n2 = MD5.II(n2, n3, n4, n, this.x[13], 21, 1309151649);
        n = MD5.II(n, n2, n3, n4, this.x[4], 6, -145523070);
        n4 = MD5.II(n4, n, n2, n3, this.x[11], 10, -1120210379);
        n3 = MD5.II(n3, n4, n, n2, this.x[2], 15, 718787259);
        n2 = MD5.II(n2, n3, n4, n, this.x[9], 21, -343485551);
        this.state[0] = this.state[0] + n;
        this.state[1] = this.state[1] + n2;
        this.state[2] = this.state[2] + n3;
        this.state[3] = this.state[3] + n4;
    }

    public static final void main(String[] stringArray) {
        MD5 mD5 = new MD5();
        int n = 0;
        while (n < messages.length) {
            String string = Bytes.toString(mD5.digest(messages[n].getBytes()));
            System.out.println("Computed: " + string);
            System.out.println("Correct: " + digests[n]);
            if (string.equalsIgnoreCase(digests[n])) {
                System.out.println("Test " + n + " passed.");
            } else {
                System.out.println("Test " + n + " failed.");
            }
            ++n;
        }
    }
}

