/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.Def;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Hashtable;

public abstract class Generator
implements Serializable {
    protected ASTMib mib;
    protected String packageName = "";
    protected String prefix = "";
    protected String targetDir = "";
    protected File targetFile;
    protected RandomAccessFile out;
    ResourceManager manager;
    private String defaultOidPrefix = "oid_";

    public Generator(ResourceManager resourceManager, String string, String string2, String string3) {
        this.packageName = string;
        this.prefix = string2;
        this.manager = resourceManager;
        this.targetDir = string3;
    }

    public void setMib(ASTMib aSTMib) {
        this.mib = aSTMib;
    }

    protected RandomAccessFile openFile(String string) throws IOException {
        File file = this.checkFile(string);
        return new RandomAccessFile(file, "rw");
    }

    protected synchronized void write(String string) throws IOException {
        try {
            this.out.writeBytes(string);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
    }

    protected void writePkg() throws IOException {
        if (this.packageName.length() != 0) {
            this.write(Def.PACKAGE + this.packageName + Def.SEMICOLON);
        }
        this.write("\n//\n// " + MessageHandler.getMessage("generate.version", this.mib.getModuleName()) + "\n//\n\n");
    }

    protected String translateOid(String string) {
        if (this.prefix.length() == 0) {
            return this.defaultOidPrefix + string.replace('.', '_');
        }
        return string.replace('.', '_');
    }

    private File checkFile(String string) throws IOException {
        File file = this.targetDir.length() != 0 ? new File(this.targetDir, string) : new File(string);
        if (file.exists()) {
            String string2 = new String(string + "~");
            File file2 = new File(this.targetDir, string2);
            if (file2.exists()) {
                file2.delete();
            }
            if (!file.renameTo(file2)) {
                Trace.error(MessageHandler.getMessage("compile.error.noWritePermission", file.getName()));
                throw new IOException("The file " + file.getName() + " belongs to another user");
            }
        }
        return file;
    }

    protected String getClassName(String string) {
        Hashtable hashtable = this.mib.oidTranslation;
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            string2 = this.translateOid(string);
        }
        String string3 = string2.trim();
        string3 = string3.replace('-', '_');
        string3 = string3.replace('.', '_');
        string3 = string3.replace(',', '_');
        string3 = string3.replace(',', '_');
        string3 = string3.replace(' ', '_');
        return Character.toUpperCase(string3.charAt(0)) + string3.substring(1, string3.length());
    }

    protected void closeIO() throws IOException {
        this.out.close();
    }
}

