/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mofc;

import com.sun.wbem.compiler.mofc.I18N;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;

public class LogFile {
    public static final int DEVELOPMENT = 4;
    public static final int DEBUG = 3;
    public static final int INFORMATIONAL = 2;
    public static final int WARNING = 1;
    public static final int CRITICAL = 0;
    private static final String newLine = "\n";
    private static boolean started = false;
    private static int logLevel = 1;
    private static DataOutputStream fStream;
    private static String fileName;
    private static boolean verbose;

    public static void add(int n, String string) {
        if (logLevel >= n) {
            LogFile.addInfo(I18N.loadString(string));
        }
    }

    public static void add(int n, String string, Object[] objectArray) {
        if (logLevel >= n) {
            MessageFormat messageFormat = new MessageFormat(I18N.loadString(string));
            messageFormat.setLocale(I18N.locale);
            int n2 = 0;
            while (n2 < objectArray.length) {
                objectArray[n2] = objectArray[n2].toString();
                ++n2;
            }
            LogFile.addInfo(messageFormat.format(objectArray));
        }
    }

    public static void add(int n, String string, Object object, Object object2, Object object3) {
        LogFile.add(n, string, new Object[]{object, object2, object3});
    }

    public static void add(int n, String string, Object object, Object object2) {
        LogFile.add(n, string, new Object[]{object, object2});
    }

    public static void add(int n, String string, Object object) {
        LogFile.add(n, string, new Object[]{object});
    }

    public static void add(int n, InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new DataInputStream(inputStream)));
        String string = new String();
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (logLevel < n) continue;
                LogFile.addInfo(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void methodEntry(String string) {
        LogFile.add(4, "METHOD_ENTRY", string);
    }

    public static void methodReturn(String string) {
        LogFile.add(4, "METHOD_RETURN", string);
    }

    private static void addInfo(String string) {
        if (started) {
            try {
                if (verbose) {
                    System.out.println(string);
                    System.out.println(newLine);
                }
                fStream.writeBytes(string);
                fStream.writeBytes(newLine);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getFileName() {
        return fileName;
    }

    public static int getLevel() {
        return logLevel;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static void setFileName(String string) {
        fileName = string;
    }

    public static void setLevel(int n) {
        logLevel = n;
    }

    public static void start() {
        LogFile.start(fileName);
    }

    public static void start(String string) {
        fileName = string;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                File file2 = new File(fileName + ".bak");
                if (file2.exists()) {
                    if (file2.delete()) {
                        file.renameTo(file2);
                    } else {
                        file.delete();
                    }
                } else {
                    file.renameTo(file2);
                }
            }
            fStream = new DataOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            System.out.println("LogFile:" + iOException);
            System.exit(1);
        }
        started = true;
        LogFile.writeHeader();
    }

    public static void stop() {
        LogFile.writeFooter();
        try {
            fStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeFooter() {
        try {
            fStream.writeBytes("Completed: " + DateFormat.getDateTimeInstance(0, 0, I18N.locale).format(new Date()) + newLine);
            fStream.writeBytes(newLine);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeHeader() {
        String[] stringArray = new String[]{"CRITICAL", "WARNING", "INFORMATION", "DEBUG", "DEVELOPMENT"};
        try {
            fStream.writeBytes("Started:" + DateFormat.getDateTimeInstance(0, 0, I18N.locale).format(new Date()) + newLine);
            fStream.writeBytes("Log Level: " + stringArray[logLevel] + newLine);
            fStream.writeBytes(newLine);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        fileName = "logfile.log";
        verbose = false;
    }
}

