/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.util;

import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.XmlInstance;
import com.sun.xml.tree.XmlDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConvertCIMComSunToJavax {
    private static CIMXml xmlImpl = CIMXmlFactory.getCIMXmlImpl();

    public static synchronized Node makeNode(String string) throws CIMException {
        try {
            InputSource inputSource = new InputSource(new ByteArrayInputStream(string.getBytes()));
            XmlDocument xmlDocument = XmlDocument.createXmlDocument((InputSource)inputSource, (boolean)false);
            return xmlDocument.getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new CIMException("CIM_ERR_INVALID_CLASS", (Object)sAXException);
        }
        catch (IOException iOException) {
            throw new CIMException("CIM_ERR_FAILED", (Object)iOException);
        }
    }

    public static javax.wbem.cim.CIMQualifierType convertCIMQualifierType(CIMQualifierType cIMQualifierType) throws CIMException {
        if (cIMQualifierType == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInstance = new XmlInstance();
        if (!xmlInstance.getIncludeClassOrigin()) {
            xmlInstance.setIncludeClassOrigin(true);
        }
        String string = xmlInstance.qualifierDeclaration(cIMQualifierType);
        Node node = ConvertCIMComSunToJavax.makeNode(string);
        return xmlImpl.getCIMQualifierType(node);
    }

    public static CIMClass convertCIMClass(com.sun.wbem.cim.CIMClass cIMClass) throws CIMException {
        if (cIMClass == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInstance = new XmlInstance();
        if (!xmlInstance.getIncludeClassOrigin()) {
            xmlInstance.setIncludeClassOrigin(true);
        }
        xmlInstance.setIncludeOverridenProperties(true);
        String string = xmlInstance.cimClass(cIMClass);
        Node node = ConvertCIMComSunToJavax.makeNode(string);
        CIMClass cIMClass2 = xmlImpl.getCIMClass(node);
        Vector<javax.wbem.cim.CIMProperty> vector = new Vector<javax.wbem.cim.CIMProperty>();
        Vector vector2 = cIMClass.getAllProperties();
        if (vector2 != null && vector2.size() != 0) {
            Iterator iterator = vector2.iterator();
            while (iterator.hasNext()) {
                CIMProperty cIMProperty = (CIMProperty)iterator.next();
                javax.wbem.cim.CIMProperty cIMProperty2 = cIMClass2.getProperty(cIMProperty.getName(), cIMProperty.getOriginClass());
                if (cIMProperty2 != null) {
                    cIMProperty2.setOverridingProperty(cIMProperty.getOverridingProperty());
                }
                vector.addElement(cIMProperty2);
            }
        }
        cIMClass2.setProperties(vector);
        return cIMClass2;
    }

    public static javax.wbem.cim.CIMInstance convertCIMInstance(CIMInstance cIMInstance) throws CIMException {
        if (cIMInstance == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInstance = new XmlInstance();
        if (!xmlInstance.getIncludeClassOrigin()) {
            xmlInstance.setIncludeClassOrigin(true);
        }
        String string = xmlInstance.instance(cIMInstance);
        Node node = ConvertCIMComSunToJavax.makeNode(string);
        javax.wbem.cim.CIMInstance cIMInstance2 = xmlImpl.getCIMInstance(node);
        ConvertCIMComSunToJavax.fixCIMInstance(cIMInstance2, cIMInstance);
        return cIMInstance2;
    }

    public static javax.wbem.cim.CIMNameSpace convertCIMNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        if (cIMNameSpace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return new javax.wbem.cim.CIMNameSpace(cIMNameSpace.getHost(), cIMNameSpace.getNameSpace());
    }

    public static javax.wbem.cim.CIMValue convertCIMValue(CIMValue cIMValue) throws CIMException {
        if (cIMValue == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInstance = new XmlInstance();
        if (!xmlInstance.getIncludeClassOrigin()) {
            xmlInstance.setIncludeClassOrigin(true);
        }
        String string = xmlInstance.value(cIMValue);
        Node node = ConvertCIMComSunToJavax.makeNode(string);
        com.sun.wbem.cim.CIMDataType cIMDataType = null;
        com.sun.wbem.cim.CIMDataType cIMDataType2 = cIMValue.getType();
        if (cIMDataType2 != null && cIMDataType2.isArrayType()) {
            int n = cIMDataType2.getType();
            int n2 = com.sun.wbem.cim.CIMDataType.findSimpleType((int)n);
            cIMDataType = com.sun.wbem.cim.CIMDataType.getPredefinedType((int)n2);
        } else {
            cIMDataType = cIMDataType2;
        }
        return xmlImpl.getCIMValue(node, cIMDataType == null ? null : cIMDataType.toString());
    }

    public static CIMObjectPath convertCIMObjectPath(com.sun.wbem.cim.CIMObjectPath cIMObjectPath) throws CIMException {
        if (cIMObjectPath == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInstance = new XmlInstance();
        if (!xmlInstance.getIncludeClassOrigin()) {
            xmlInstance.setIncludeClassOrigin(true);
        }
        String string = xmlInstance.objectPath(cIMObjectPath);
        Node node = ConvertCIMComSunToJavax.makeNode(string);
        CIMObjectPath cIMObjectPath2 = xmlImpl.getCIMObjectPath(node);
        ConvertCIMComSunToJavax.fixCIMObjectPath(cIMObjectPath2, cIMObjectPath);
        return cIMObjectPath2;
    }

    public static SecurityMessage convertSecurityMessage(com.sun.wbem.security.SecurityMessage securityMessage) {
        SecurityMessage securityMessage2 = null;
        byte[] byArray = securityMessage.getChallenge();
        byte[] byArray2 = securityMessage.getResponse();
        byte[] byArray3 = securityMessage.getChecksum();
        byte[] byArray4 = securityMessage.getSessionId();
        PublicKey publicKey = securityMessage.getPublicKey();
        if (securityMessage.isHello()) {
            byte[] byArray5 = securityMessage.getNameSpace();
            byte[] byArray6 = securityMessage.getUserDigest();
            securityMessage2 = SecurityMessage.hello((byte[])byArray, (byte[])byArray6, (byte[])byArray5, (byte[])byArray3);
        } else if (securityMessage.isResponse()) {
            securityMessage2 = SecurityMessage.response((byte[])byArray2, (PublicKey)publicKey, (byte[])byArray4, (byte[])byArray3);
        } else if (securityMessage.isChallenge()) {
            byte[] byArray7 = securityMessage.getSalt();
            securityMessage2 = SecurityMessage.challenge((byte[])byArray, (byte[])byArray7, (byte[])byArray4, (byte[])byArray3);
        } else if (securityMessage.isResult()) {
            securityMessage2 = SecurityMessage.result((byte[])byArray4, (PublicKey)publicKey, (byte[])byArray2, (byte[])byArray3);
        } else if (securityMessage.isError()) {
            String string = securityMessage.getMessage();
            securityMessage2 = SecurityMessage.error((String)string);
        }
        return securityMessage2;
    }

    public static SecurityToken convertSecurityToken(com.sun.wbem.security.SecurityToken securityToken) {
        SecurityToken securityToken2 = new SecurityToken();
        byte[] byArray = securityToken.getChecksum();
        byte[] byArray2 = securityToken.getSignature();
        byte[] byArray3 = securityToken.getSessionId();
        securityToken2.setChecksum(byArray);
        securityToken2.setSignature(byArray2);
        securityToken2.setSessionId(byArray3);
        return securityToken2;
    }

    private static void fixCIMInstance(javax.wbem.cim.CIMInstance cIMInstance, CIMInstance cIMInstance2) throws CIMException {
        if (cIMInstance == null || cIMInstance2 == null) {
            return;
        }
        Vector vector = cIMInstance.getProperties();
        if (vector == null || vector.size() == 0) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            javax.wbem.cim.CIMValue cIMValue;
            CIMDataType cIMDataType;
            javax.wbem.cim.CIMProperty cIMProperty = (javax.wbem.cim.CIMProperty)iterator.next();
            if (cIMProperty == null || (cIMDataType = cIMProperty.getType()) == null || (cIMValue = cIMProperty.getValue()) == null || !cIMDataType.isReferenceType()) continue;
            CIMProperty cIMProperty2 = cIMInstance2.getProperty(cIMProperty.getName());
            ConvertCIMComSunToJavax.fixCIMObjectPath((CIMObjectPath)cIMValue.getValue(), (com.sun.wbem.cim.CIMObjectPath)cIMProperty2.getValue().getValue());
        }
    }

    private static void fixCIMObjectPath(CIMObjectPath cIMObjectPath, com.sun.wbem.cim.CIMObjectPath cIMObjectPath2) {
        if (cIMObjectPath == null || cIMObjectPath2 == null) {
            return;
        }
        Vector vector = cIMObjectPath.getKeys();
        if (vector == null || vector.size() == 0) {
            return;
        }
        javax.wbem.cim.CIMProperty[] cIMPropertyArray = new javax.wbem.cim.CIMProperty[vector.size()];
        vector.toArray(cIMPropertyArray);
        vector = cIMObjectPath2.getKeys();
        if (vector == null || vector.size() == 0) {
            return;
        }
        CIMProperty[] cIMPropertyArray2 = new CIMProperty[vector.size()];
        vector.toArray(cIMPropertyArray2);
        int n = 0;
        while (n < cIMPropertyArray.length) {
            ConvertCIMComSunToJavax.fixInstancekeyProperty(cIMPropertyArray[n], cIMPropertyArray2);
            ++n;
        }
    }

    private static void fixInstancekeyProperty(javax.wbem.cim.CIMProperty cIMProperty, CIMProperty[] cIMPropertyArray) {
        String string = cIMProperty.getName();
        int n = 0;
        while (n < cIMPropertyArray.length) {
            if (cIMProperty.getName().equals(cIMPropertyArray[n].getName())) {
                if (cIMPropertyArray[n].getType().isReferenceType()) {
                    ConvertCIMComSunToJavax.fixCIMObjectPath((CIMObjectPath)cIMProperty.getValue().getValue(), (com.sun.wbem.cim.CIMObjectPath)cIMPropertyArray[n].getValue().getValue());
                } else {
                    ConvertCIMComSunToJavax.convertType(cIMProperty, cIMPropertyArray[n].getType());
                }
            }
            ++n;
        }
    }

    private static void convertType(javax.wbem.cim.CIMProperty cIMProperty, com.sun.wbem.cim.CIMDataType cIMDataType) {
        Object object;
        if (cIMProperty == null) {
            return;
        }
        String string = cIMDataType.toString();
        if (cIMProperty != null && cIMProperty.getValue() != null && (object = cIMProperty.getValue().getValue()) instanceof String) {
            String string2 = (String)object;
            Object object2 = ConvertCIMComSunToJavax.valueObject(string2, string);
            cIMProperty.setValue(new javax.wbem.cim.CIMValue(object2));
            cIMProperty.setType(new CIMDataType(cIMDataType.getType()));
        }
    }

    private static Object valueObject(String string, String string2) {
        Object object = null;
        string2 = string2.length() > 0 ? string2 : "string";
        int n = 10;
        if (string2.startsWith("sint") && (string.startsWith("0x") || string.startsWith("+0x") || string.startsWith("-0x") || string.startsWith("0X") || string.startsWith("+0X") || string.startsWith("-0X")) || string2.startsWith("uint") && (string.startsWith("0x") || string.startsWith("0X"))) {
            n = 16;
            int n2 = (string.indexOf("x") > 0 ? string.indexOf("x") : string.indexOf("X")) + 1;
            String string3 = string = string.startsWith("-") ? "-" + string.substring(n2) : string.substring(n2);
        }
        if (string2.equals("boolean")) {
            object = Boolean.valueOf(string);
        } else if (string2.equals("char16")) {
            object = new Character(string.charAt(0));
        } else if (string2.equals("datetime")) {
            object = new CIMDateTime(string);
        } else if (string2.equals("real32")) {
            object = new Float(string);
        } else if (string2.equals("real64")) {
            object = new Double(string);
        } else if (string2.equals("sint16")) {
            object = Short.valueOf(string, n);
        } else if (string2.equals("sint32")) {
            object = Integer.valueOf(string, n);
        } else if (string2.equals("sint64")) {
            object = Long.valueOf(string, n);
        } else if (string2.equals("sint8")) {
            object = Byte.valueOf(string, n);
        } else if (string2.equals("string")) {
            object = string == null ? "" : new String(string);
        } else if (string2.equals("uint16")) {
            object = new UnsignedInt16(Integer.valueOf(string, n).intValue());
        } else if (string2.equals("uint32")) {
            object = new UnsignedInt32(Long.valueOf(string, n).longValue());
        } else if (string2.equals("uint64")) {
            object = new UnsignedInt64(new BigInteger(string, n));
        } else if (string2.equals("uint8")) {
            object = new UnsignedInt8(Short.valueOf(string, n).shortValue());
        } else if (string.indexOf("e") > 0 || string.indexOf("E") > 0) {
            object = new Double(string);
        } else if (string.startsWith("+") || string.startsWith("-")) {
            object = new Long(string);
        }
        return object;
    }
}

