/*
 * Decompiled with CFR 0.152.
 */
package tyrex.server;

import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationID;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.SystemException;
import tyrex.conf.Resources;
import tyrex.recovery.LogWriter;
import tyrex.recovery.RecoveryManager;
import tyrex.resource.ResourceLimits;
import tyrex.server.Configure;
import tyrex.server.RemoteTransactionServer;
import tyrex.tm.TransactionDomain;
import tyrex.tm.TyrexPermission;
import tyrex.util.Logger;
import tyrex.util.Messages;

public final class TransactionServer
extends Activatable
implements RemoteTransactionServer {
    public static final String DefaultDomain = "Default";
    private static TransactionServer _instance;
    private static Configure _config;
    private static int _status;
    private static Hashtable _txDomains;

    static {
        _status = 0;
        _txDomains = new Hashtable();
    }

    private TransactionServer() throws Exception {
        super(null, 0);
    }

    public TransactionServer(ActivationID activationID, MarshalledObject marshalledObject) throws RemoteException {
        super(activationID, 0);
        if (_instance == null) {
            _instance = this;
            Configure configure = null;
            try {
                if (marshalledObject != null) {
                    configure = (Configure)marshalledObject.get();
                }
            }
            catch (Exception exception) {}
            TransactionServer.start(configure);
        }
    }

    public byte[] createRemoteTransaction() throws SystemException, RemoteException {
        TransactionDomain transactionDomain = TransactionServer.getTransactionDomain(DefaultDomain, true);
        return transactionDomain.createRemoteTransaction();
    }

    private static TransactionDomain createTransactionDomain(String string) {
        TransactionDomain transactionDomain = new TransactionDomain(string, new ResourceLimits());
        _txDomains.put(string, transactionDomain);
        return transactionDomain;
    }

    static Configure getConfigure() {
        return _config;
    }

    public static synchronized TransactionServer getInstance() {
        if (_instance == null) {
            try {
                TransactionServer.start(new Configure());
            }
            catch (Exception exception) {
                Logger.getSystemLogger().println(Messages.format("tyrex.server.failedInitialize", exception));
                throw new RuntimeException(Messages.format("tyrex.server.failedInitialize", exception));
            }
        }
        return _instance;
    }

    public static synchronized TransactionDomain getTransactionDomain(String string, boolean bl) {
        TransactionDomain transactionDomain = (TransactionDomain)_txDomains.get(string);
        if (transactionDomain == null) {
            transactionDomain = bl ? TransactionServer.createTransactionDomain(string) : TransactionServer.getTransactionDomain(DefaultDomain, true);
        }
        return transactionDomain;
    }

    static void logMessage(String string) {
        if (_config.getLogWriter() != null) {
            _config.getLogWriter().println(string);
        }
    }

    static void shutdown(Configure configure) {
        AccessController.checkPermission(TyrexPermission.Server.Shutdown);
        if (configure == null) {
            throw new NullPointerException("Argument 'config' is null");
        }
        if (_instance == null) {
            return;
        }
        TransactionServer transactionServer = _instance;
        synchronized (transactionServer) {
            if (configure != _config) {
                Logger.getSystemLogger().println(Messages.message("tyrex.server.serverNotSameConfig"));
                throw new SecurityException(Messages.message("tyrex.server.serverNotSameConfig"));
            }
            if (_status != 1) {
                Object var3_2 = null;
                return;
            }
            _status = 3;
            Logger.getSystemLogger().println(Messages.message("tyrex.server.serverShutdown"));
            Enumeration enumeration = _txDomains.elements();
            while (enumeration.hasMoreElements()) {
                ((TransactionDomain)enumeration.nextElement()).shutdown();
            }
            _status = 1;
        }
        Logger.getSystemLogger().println(Messages.message("tyrex.server.serverStopped"));
    }

    static synchronized void start(Configure configure) {
        AccessController.checkPermission(TyrexPermission.Server.Start);
        if (configure == null) {
            throw new NullPointerException("Argument 'config' is null");
        }
        if (_instance == null) {
            try {
                _instance = new TransactionServer();
            }
            catch (Exception exception) {
                Logger.getSystemLogger().println(Messages.format("tyrex.server.failedInitialize", exception));
                exception.printStackTrace(Logger.getSystemLogger());
                throw new RuntimeException(Messages.format("tyrex.server.failedInitialize", exception));
            }
        }
        TransactionServer transactionServer = _instance;
        synchronized (transactionServer) {
            if (_status == 0) {
                if (_config != null && _config != configure) {
                    Logger.getSystemLogger().println(Messages.message("tyrex.server.serverNotSameConfig"));
                    throw new SecurityException(Messages.message("tyrex.server.serverNotSameConfig"));
                }
                _status = 2;
                _config = configure;
                Logger.getSystemLogger().println(Messages.message("tyrex.server.serverStart"));
                Package package_ = _instance.getClass().getPackage();
                if (package_ != null) {
                    Logger.getSystemLogger().println(String.valueOf(package_.getImplementationTitle()) + "  Version " + package_.getImplementationVersion());
                    Logger.getSystemLogger().println(package_.getImplementationVendor());
                }
                TransactionServer.getTransactionDomain(DefaultDomain, true);
                LogWriter.newWriter(configure.getLogDirectory(), configure.getORB(), configure.isLogActivated(), configure.isRecoveryActivated());
                if (configure.isLogActivated()) {
                    Logger.getSystemLogger().println(Messages.message("tyrex.recovery.enable"));
                } else {
                    Logger.getSystemLogger().println(Messages.message("tyrex.recovery.disable"));
                }
                RecoveryManager.newRecoveryManager(configure.getLogDirectory(), configure.getORB());
                if (configure.isRecoveryActivated()) {
                    RecoveryManager.manager.recover_transactions();
                    LogWriter.out.recovery_completed();
                }
            } else if (_status == 1) {
                if (_config != configure) {
                    Logger.getSystemLogger().println(Messages.message("tyrex.server.serverNotSameConfig"));
                    throw new SecurityException(Messages.message("tyrex.server.serverNotSameConfig"));
                }
                _status = 2;
                Logger.getSystemLogger().println(Messages.message("tyrex.server.serverRestart"));
            }
            Resources.reloadResources();
            _status = 1;
            _instance.notifyAll();
        }
        Logger.getSystemLogger().println(Messages.message("tyrex.server.serverStarted"));
    }

    static int status() {
        return _status;
    }
}

