/*
 * Decompiled with CFR 0.152.
 */
package tyrex.util;

import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class HashIntTable {
    private Entry[] table = null;
    private int defaultValue;
    private int numberOfEntries = 0;
    private int modificationCount = 0;

    public HashIntTable() {
        this(101, 0);
    }

    public HashIntTable(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("The argument 'size' is not greater than 0.");
        }
        this.table = new Entry[n];
        this.defaultValue = n2;
    }

    public int get(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The arguments 'key' is null.");
        }
        int n = object.hashCode();
        Entry entry = this.table[(n & Integer.MAX_VALUE) % this.table.length];
        while (entry != null) {
            if (entry.hashCode == n && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return this.defaultValue;
    }

    public int increment(Object object, int n) {
        class Tyrex_util_HashIntTable$2 {
            /* synthetic */ Tyrex_util_HashIntTable$2() {
            }
        }
        if (object == null) {
            throw new IllegalArgumentException("The arguments 'key' is null.");
        }
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % this.table.length;
        Entry entry = this.table[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hashCode == n2 && entry.key.equals(object)) {
                Entry entry3 = entry;
                entry3.value = entry3.value + n;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        int n4 = this.defaultValue + n;
        if (entry2 == null) {
            this.table[n3] = new Entry(null, object, n2, n4);
        } else {
            entry2.next = new Entry(null, object, n2, n4);
        }
        ++this.numberOfEntries;
        ++this.modificationCount;
        return n4;
    }

    public Enumeration keys() {
        return new KeysEnumeration(null, this.modificationCount);
    }

    public static void main(String[] stringArray) {
        HashIntTable hashIntTable = new HashIntTable();
        Object[] objectArray = new Object[4];
        int n = objectArray.length;
        while (--n >= 0) {
            final String string = "Key" + n;
            objectArray[n] = new Object(){

                public String toString() {
                    return string;
                }
            };
        }
        System.out.println("size " + hashIntTable.size());
        System.out.println("get " + objectArray[0]);
        System.out.println("= " + hashIntTable.get(objectArray[0]));
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            hashIntTable.put(objectArray[n2], n2);
        }
        System.out.println("size " + hashIntTable.size());
        int n3 = objectArray.length;
        while (--n3 >= 0) {
            System.out.println("get " + objectArray[n3]);
            System.out.println("= " + hashIntTable.get(objectArray[n3]));
        }
        int n4 = objectArray.length;
        while (--n4 >= 0) {
            hashIntTable.increment(objectArray[n4], 100);
        }
        System.out.println("size " + hashIntTable.size());
        int n5 = objectArray.length;
        while (--n5 >= 0) {
            System.out.println("get " + objectArray[n5]);
            System.out.println("= " + hashIntTable.get(objectArray[n5]));
        }
        int n6 = objectArray.length;
        while (--n6 >= 0) {
            System.out.println("remove " + objectArray[n6]);
            System.out.println("= " + hashIntTable.remove(objectArray[n6]));
        }
        System.out.println("size " + hashIntTable.size());
        int n7 = objectArray.length;
        while (--n7 >= 0) {
            System.out.println("get " + objectArray[n7]);
            System.out.println("= " + hashIntTable.get(objectArray[n7]));
        }
        int n8 = objectArray.length;
        while (--n8 >= 0) {
            System.out.println("remove " + objectArray[n8]);
            System.out.println("= " + hashIntTable.remove(objectArray[n8]));
        }
        System.out.println("size " + hashIntTable.size());
        int n9 = objectArray.length;
        while (--n9 >= 0) {
            System.out.println("get " + objectArray[n9]);
            System.out.println("= " + hashIntTable.get(objectArray[n9]));
        }
        int n10 = objectArray.length;
        while (--n10 >= 0) {
            hashIntTable.increment(objectArray[n10], 100);
        }
        System.out.println("size " + hashIntTable.size());
        int n11 = objectArray.length;
        while (--n11 >= 0) {
            System.out.println("get " + objectArray[n11]);
            System.out.println("= " + hashIntTable.get(objectArray[n11]));
        }
        int n12 = objectArray.length;
        while (--n12 >= 0) {
            hashIntTable.put(objectArray[n12], n12);
        }
        System.out.println("size " + hashIntTable.size());
        int n13 = objectArray.length;
        while (--n13 >= 0) {
            System.out.println("get " + objectArray[n13]);
            System.out.println("= " + hashIntTable.get(objectArray[n13]));
        }
        Enumeration enumeration = hashIntTable.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println("key " + enumeration.nextElement());
        }
    }

    public int put(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The arguments 'key' is null.");
        }
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % this.table.length;
        Entry entry = this.table[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hashCode == n2 && entry.key.equals(object)) {
                int n4 = entry.value;
                entry.value = n;
                return n4;
            }
            entry2 = entry;
            entry = entry.next;
        }
        if (entry2 == null) {
            this.table[n3] = new Entry(null, object, n2, n);
        } else {
            entry2.next = new Entry(null, object, n2, n);
        }
        ++this.numberOfEntries;
        ++this.modificationCount;
        return n;
    }

    public int remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The arguments 'key' is null.");
        }
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        Entry entry = this.table[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hashCode == n && entry.key.equals(object)) {
                if (entry2 == null) {
                    this.table[n2] = entry.next;
                } else {
                    entry2.next = entry.next;
                }
                --this.numberOfEntries;
                ++this.modificationCount;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return this.defaultValue;
    }

    public int size() {
        return this.numberOfEntries;
    }

    private class KeysEnumeration
    implements Enumeration {
        private final int expectedModificationCount;
        private int index = -1;
        private Entry entry = null;

        private KeysEnumeration(int n) {
            this.expectedModificationCount = n;
        }

        /* synthetic */ KeysEnumeration(2 var2_2, int n) {
            this(n);
        }

        public boolean hasMoreElements() {
            if (this.expectedModificationCount != HashIntTable.this.modificationCount) {
                throw new ConcurrentModificationException("The " + HashIntTable.this + " has been changed.");
            }
            if (this.entry == null) {
                while (++this.index < HashIntTable.this.table.length) {
                    this.entry = HashIntTable.this.table[this.index];
                    if (this.entry == null) continue;
                    return true;
                }
            }
            return this.entry != null;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more elements in exception.");
            }
            Object object = this.entry.key;
            this.entry = this.entry.next;
            return object;
        }
    }

    private class Entry {
        private final Object key;
        private final int hashCode;
        private int value;
        private Entry next = null;

        private Entry(Object object, int n, int n2) {
            this.key = object;
            this.hashCode = n;
            this.value = n2;
        }

        /* synthetic */ Entry(2 var2_2, Object object, int n, int n2) {
            this(object, n, n2);
        }
    }
}

