/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.MemberSelectorPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WholeNumField;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.SolGroupAttr;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SolGrpProps
extends UMgrPropsPanel {
    private boolean offerGroups = false;
    private WholeNumField gidField;
    private JComboBox primarycombo;
    private MemberSelectorPanel memberPanel;
    private String currentPriGr = null;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private ActionString actionString;
    private GenInfoPanel infoPanel;

    public SolGrpProps(VUserMgr vUserMgr, UserObj userObj, GenInfoPanel genInfoPanel) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.infoPanel = genInfoPanel;
        this.createGui(userObj);
        this.loadHelp();
    }

    private void createGui(UserObj userObj) {
        Vector vector = this.theApp.getAllGroupsCache();
        if (vector == null) {
            try {
                vector = this.theApp.getUserMgr().getAllGroups();
                this.theApp.setAllGroupsCache(vector);
                this.offerGroups = true;
            }
            catch (AdminException adminException) {
                this.offerGroups = false;
            }
        }
        this.offerGroups = vector != null && !vector.isEmpty();
        if (this.offerGroups) {
            this.createGuiWithAvailGroups(userObj, vector);
        } else {
            this.createGuiWithNoAvailGroups(userObj);
        }
    }

    private void createGuiWithAvailGroups(UserObj userObj, Vector vector) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"sol_grp_props_grpTitle"));
        jPanel.setBorder(titledBorder);
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_wiz_user_group"));
        this.actionString = new ActionString(this.bundle, "au_wiz_user_group");
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        Object[] objectArray = new String[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GroupObj groupObj = (GroupObj)enumeration.nextElement();
            objectArray[n] = new String(groupObj.getGroupName());
            ++n;
        }
        Sort.sort((String[])objectArray);
        this.primarycombo = new JComboBox<String>(objectArray);
        this.currentPriGr = "staff";
        if (solGroupAttr != null && solGroupAttr.getPrimaryGroup() != null) {
            this.currentPriGr = solGroupAttr.getPrimaryGroup();
        }
        this.primarycombo.setSelectedItem(this.currentPriGr);
        jLabel.setLabelFor(this.primarycombo);
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.primarycombo, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)1.0, (int)0, (int)16, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"sol_grp_props_addTitle"));
        jPanel2.setBorder(titledBorder2);
        Vector vector2 = AdminCommonTools.CMN_ArrayToVector((Object[])objectArray);
        int n2 = 1;
        if (solGroupAttr != null) {
            n2 = solGroupAttr.getNumberSecondaryGroups();
        }
        Vector<String> vector3 = new Vector<String>(n2);
        String[] stringArray = new String[n2];
        if (solGroupAttr != null) {
            if (solGroupAttr.getSecondaryGroups() != null) {
                stringArray = solGroupAttr.getSecondaryGroups();
            }
        } else {
            stringArray[0] = "";
            n2 = 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            vector3.insertElementAt(stringArray[n3], n3);
            if (vector2.contains(stringArray[n3])) {
                vector2.removeElement(stringArray[n3]);
            }
            ++n3;
        }
        ActionString actionString = new ActionString(this.bundle, "sol_grp_props_availGr");
        ActionString actionString2 = new ActionString(this.bundle, "sol_grp_props_memberOf");
        ActionString actionString3 = new ActionString(this.bundle, "mu_wiz_usernames_btn2");
        ActionString actionString4 = new ActionString(this.bundle, "sol_grp_props_remove");
        this.memberPanel = new MemberSelectorPanel(vector2, vector3, false);
        this.memberPanel.setLabels(actionString, actionString2, actionString3, actionString4);
        Constraints.constrain((Container)jPanel2, (Component)this.memberPanel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)1.0, (int)10, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this, (Component)jPanel, (int)0, (int)0, (int)2, (int)1, (int)1, (int)10, (double)0.0, (double)0.0, (int)20, (int)16, (int)0, (int)16);
        Constraints.constrain((Container)this, (Component)jPanel2, (int)0, (int)1, (int)2, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)0, (int)16, (int)12, (int)16);
    }

    private void createGuiWithNoAvailGroups(UserObj userObj) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"sol_grp_props_no_groups"));
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_wiz_user_group"));
        this.actionString = new ActionString(this.bundle, "au_wiz_user_group");
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        String string = null;
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        if (solGroupAttr != null && solGroupAttr.getPrimaryGroup() != null) {
            string = solGroupAttr.getPrimaryGroup();
        }
        int n = 10;
        if (string != null || !string.equals("")) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 10;
            }
        }
        this.gidField = new WholeNumField(n, 11, Integer.MAX_VALUE, true);
        jLabel.setLabelFor((Component)this.gidField);
        Constraints.constrain((Container)this, (Component)flowArea, (int)0, (int)0, (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)20, (int)24, (int)0, (int)0);
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)12, (int)24, (int)0, (int)0);
        Constraints.constrain((Container)this, (Component)this.gidField, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)12, (int)16, (int)0, (int)0);
    }

    public boolean checkNumberSecondaryGroups() {
        if (!this.offerGroups) {
            return true;
        }
        Vector vector = this.memberPanel.getOutItems();
        if (vector.size() > SolGroupAttr.getMaximumGroupNumber()) {
            String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"sol_grp_props_er_too_many_secondary_groups");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
            return false;
        }
        return true;
    }

    public UserObj updateGrpProps(UserObj userObj) {
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        if (solGroupAttr == null) {
            solGroupAttr = new SolGroupAttr();
        }
        if (!this.offerGroups) {
            int n = this.gidField.getValue();
            String string = String.valueOf(n);
            solGroupAttr.setPrimaryGroup(string);
            userObj.setSolGroupAttr(solGroupAttr);
            return userObj;
        }
        String string = null;
        string = (String)this.primarycombo.getSelectedItem();
        Vector vector = this.memberPanel.getOutItems();
        int n = vector.size();
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        solGroupAttr.setPrimaryGroup(string);
        solGroupAttr.setSecondaryGroups((String[])objectArray);
        solGroupAttr.setNumberSecondaryGroups(objectArray.length);
        userObj.setSolGroupAttr(solGroupAttr);
        return userObj;
    }

    private void loadHelp() {
        Object object;
        Vector vector = null;
        if (this.offerGroups) {
            vector = new Vector(4 + this.primarycombo.getItemCount());
            this.theApp.addHelpListener(this.primarycombo, new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uprop_groups_primary"));
            object = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uprop_groups_groups");
            this.memberPanel.setFocusListeners((FocusListener)object, (FocusListener)object, (FocusListener)object, (FocusListener)object, null, null);
            this.focusListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uprop_groups");
        } else {
            vector = new Vector(2);
            this.focusListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uprop_groups_no_groups");
        }
        object = new Thread(){

            public void run() {
                try {
                    ContextHelpListener.loadHelp((ContextHelpListener)((UMgrContextHelpListener)((Object)SolGrpProps.this.getFocusListener())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        object.start();
    }
}

