/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.io.EOFException;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import sun.awt.im.iiimp.AnnotationValue;
import sun.awt.im.iiimp.IIIMPInputStream;
import sun.awt.im.iiimp.IIIMPOutputStream;
import sun.awt.im.iiimp.IIIMProtocol;
import sun.awt.im.iiimp.Manager;

class ProtocolData
implements IIIMProtocol {
    int pos;
    int count;
    byte[] buf;
    private static final int DATA_BOUNDARY = 4;

    ProtocolData() {
        this.buf = new byte[32];
        this.count = 0;
        this.pos = 0;
    }

    ProtocolData(byte[] byArray, int n, int n2) {
        this.pos = 0;
        this.count = n2;
        if (n2 > 0) {
            this.buf = new byte[n2];
            System.arraycopy(byArray, n, this.buf, 0, n2);
        }
    }

    ProtocolData(byte[] byArray, int n) {
        this(byArray, 0, n);
    }

    ProtocolData(byte[] byArray) {
        this(byArray, byArray.length);
    }

    ProtocolData(ProtocolData protocolData) {
        int n = protocolData.count - protocolData.pos;
        if (n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(protocolData.buf, protocolData.pos, byArray, 0, n);
            this.buf = byArray;
        }
        this.count = n;
        this.pos = 0;
    }

    void write(int n) throws IOException {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count++] = (byte)(n & 0xFF);
    }

    void write2(int n) throws IOException {
        this.ensureCapacity(this.count + 2);
        this.buf[this.count++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.count++] = (byte)(n >>> 0 & 0xFF);
    }

    void write4(int n) throws IOException {
        this.ensureCapacity(this.count + 4);
        this.buf[this.count++] = (byte)(n >>> 24 & 0xFF);
        this.buf[this.count++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.count++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.count++] = (byte)(n >>> 0 & 0xFF);
    }

    void writeBytes(byte[] byArray) throws IOException {
        this.ensureCapacity(this.count + byArray.length);
        System.arraycopy(byArray, 0, this.buf, this.count, byArray.length);
        this.count += byArray.length;
    }

    void writeBytes(byte[] byArray, int n) throws IOException {
        this.ensureCapacity(this.count + n);
        System.arraycopy(byArray, 0, this.buf, this.count, n);
        this.count += n;
    }

    void writeString(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = n2 * 2;
        this.write2(n3);
        int n4 = ProtocolData.paddings(n3 + 2);
        this.ensureCapacity(this.count + n3 + n4);
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            this.buf[this.count++] = (byte)(c >> 8 & 0xFF);
            this.buf[this.count++] = (byte)(c >> 0 & 0xFF);
        }
        for (n = 0; n < n4; ++n) {
            this.buf[this.count++] = 0;
        }
    }

    int read() throws IOException {
        int n;
        if (this.pos >= this.count) {
            throw new EOFException();
        }
        if ((n = this.buf[this.pos++] & 0xFF) < 0) {
            throw new EOFException();
        }
        return n;
    }

    int read2() throws IOException {
        int n = this.read();
        int n2 = this.read();
        return (n << 8) + (n2 << 0);
    }

    int read4() throws IOException {
        int n = this.read();
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 <= 0) {
            return 0;
        }
        int n4 = this.read();
        if (n4 == -1) {
            return -1;
        }
        byArray[n] = (byte)n4;
        try {
            for (n3 = 1; n3 < n2 && (n4 = this.read()) != -1; ++n3) {
                if (byArray == null) continue;
                byArray[n + n3] = (byte)n4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n3;
    }

    String readString() throws IOException {
        int n;
        int n2;
        int n3 = this.read2();
        if (n3 == 0) {
            this.read2();
            return null;
        }
        int n4 = n3 / 2;
        char[] cArray = new char[n4];
        int n5 = 0;
        while (n5 < n4) {
            n2 = this.read();
            n = this.read();
            cArray[n5++] = (char)((n2 << 8) + (n << 0));
        }
        n2 = ProtocolData.paddings(n3 + 2);
        for (n = 0; n < n2; ++n) {
            this.read();
        }
        return new String(cArray, 0, n4);
    }

    AnnotationValue[] readStringAnnotationValues(AttributedCharacterIterator.Attribute attribute) throws IOException {
        int n;
        int n2 = this.read4();
        if (n2 < 12) {
            this.skipBytes(n2);
            return null;
        }
        HashSet<AnnotationValue> hashSet = new HashSet<AnnotationValue>();
        while (n2 > 0) {
            int n3 = this.read4();
            int n4 = this.read4();
            n = this.read4();
            String string = this.readString();
            this.pad();
            hashSet.add(new AnnotationValue(n3, n4, attribute, string));
        }
        Object[] objectArray = hashSet.toArray();
        AnnotationValue[] annotationValueArray = new AnnotationValue[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            annotationValueArray[n] = (AnnotationValue)objectArray[n];
        }
        return annotationValueArray;
    }

    AnnotationValue[] readTextAnnotationValues(AttributedCharacterIterator.Attribute attribute) throws IOException {
        int n;
        int n2 = this.read4();
        if (n2 < 12) {
            this.skipBytes(n2);
            return null;
        }
        HashSet<AnnotationValue> hashSet = new HashSet<AnnotationValue>();
        while (n2 > 0) {
            int n3 = this.read4();
            int n4 = this.read4();
            n = this.read4();
            int n5 = this.read4();
            StringBuffer stringBuffer = new StringBuffer();
            while (n5 > 0) {
                stringBuffer.append(this.read2());
                int n6 = this.read2();
                this.skipBytes(n6);
            }
            String string = stringBuffer.toString();
            this.pad();
            hashSet.add(new AnnotationValue(n3, n4, attribute, string));
        }
        Object[] objectArray = hashSet.toArray();
        AnnotationValue[] annotationValueArray = new AnnotationValue[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            annotationValueArray[n] = (AnnotationValue)objectArray[n];
        }
        return annotationValueArray;
    }

    void ensureCapacity(int n) {
        int n2 = this.buf.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }

    static final int paddings(int n) {
        return (4 - n % 4) % 4;
    }

    void pad() throws IOException {
        int n = ProtocolData.paddings(this.count);
        int n2 = this.count + n;
        for (int i = this.count; i < n2; ++i) {
            this.write(0);
        }
    }

    void skipBytes(int n) {
        int n2 = this.count < this.pos + n ? this.count - this.pos : n;
        this.pos += n2;
    }

    int available() {
        return this.count > this.pos ? this.count - this.pos : 0;
    }

    void read(IIIMPInputStream iIIMPInputStream, int n) {
        try {
            this.pos = 0;
            this.count = n;
            this.buf = new byte[n];
            iIIMPInputStream.readFully(this.buf);
        }
        catch (IOException iOException) {
            this.debug("e = " + iOException);
        }
    }

    void write(IIIMPOutputStream iIIMPOutputStream) {
        try {
            iIIMPOutputStream.write(this.buf, 0, this.count);
        }
        catch (IOException iOException) {
            this.debug("e = " + iOException);
        }
    }

    private void debug(String string) {
        if (Manager.DEBUG) {
            System.err.println(string);
        }
    }
}

