/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.Socket;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;

public abstract class SSLImplementation {
    private static final String PureTLSImplementationClass = "org.apache.tomcat.util.net.PureTLSImplementation";
    private static final String JSSEImplementationClass = "org.apache.tomcat.util.net.JSSEImplementation";
    private static final String[] implementations;

    public static SSLImplementation getInstance() throws ClassNotFoundException {
        int i = 0;
        while (i < implementations.length) {
            try {
                SSLImplementation impl = SSLImplementation.getInstance(implementations[i]);
                return impl;
            }
            catch (Exception exception) {
                ++i;
            }
        }
        throw new ClassNotFoundException("Can't find any SSL implementation");
    }

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return SSLImplementation.getInstance();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (SSLImplementation)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Error loading SSL Implementation " + className + " :" + e.toString());
        }
    }

    public abstract String getImplementationName();

    public abstract ServerSocketFactory getServerSocketFactory();

    public abstract SSLSupport getSSLSupport(Socket var1);

    static {
        PureTLSImplementationClass = PureTLSImplementationClass;
        JSSEImplementationClass = JSSEImplementationClass;
        implementations = new String[]{PureTLSImplementationClass, JSSEImplementationClass};
    }
}

