/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.JMenuPlus;
import com.sun.admin.hostmgr.client.ApplicationContext;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.ContentEvent;
import com.sun.admin.hostmgr.client.ContentListener;
import com.sun.admin.hostmgr.client.HostActionsListener;
import com.sun.admin.hostmgr.client.HostContent;
import com.sun.admin.hostmgr.client.NavigationSelectionListener;
import com.sun.admin.hostmgr.client.NetworkContent;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MainMenuBar
extends JMenuBar {
    private JMenuItem miAdd;
    private JMenuItem miPopupAdd;
    private JMenuItem miOpen;
    private JMenuItem miPopupOpen;
    private JMenuItem miPopupProperties;
    private JMenuItem miRename;
    private JMenuItem miPopupRename;
    private JMenuItem miPopupDelete;
    private JMenuItem miShowAll;
    private JMenuItem miColumnsDisplay;
    private JMenuItem miShowNetworks;
    private JMenuItem miAbout;
    private JMenuPlus actionsMenu;
    private JMenuPlus viewMenu;
    private JMenuPlus helpMenu;
    private JMenuPlus popupMenu;
    private ContentListener contentListener;
    private Content content = null;
    private VHostMgr theApp;

    public MainMenuBar(VHostMgr vHostMgr) {
        HostActionsListener hostActionsListener;
        this.theApp = vHostMgr;
        ResourceBundle resourceBundle = vHostMgr.getResourceBundle();
        HostActionsListener hostActionsListener2 = hostActionsListener = new HostActionsListener(vHostMgr);
        ActionString actionString = new ActionString(resourceBundle, "ActionsMenu");
        this.actionsMenu = new JMenuPlus(actionString.getString());
        this.actionsMenu.setMnemonic(actionString.getMnemonic());
        this.actionsMenu.setActionCommand("VMenuID.ACTION");
        actionString = new ActionString(resourceBundle, "ActionsOpen");
        this.miOpen = new JMenuItem(actionString.getString());
        this.actionsMenu.add(this.miOpen);
        this.miOpen.setMnemonic(actionString.getMnemonic());
        this.miOpen.setActionCommand("Open");
        this.miOpen.addActionListener(hostActionsListener);
        actionString = new ActionString(resourceBundle, "ActionsAddNetwork");
        this.miAdd = new JMenuItem(actionString.getString());
        this.actionsMenu.add(this.miAdd);
        this.miAdd.setMnemonic(actionString.getMnemonic());
        this.miAdd.setActionCommand("New");
        this.miAdd.addActionListener(hostActionsListener);
        actionString = new ActionString(resourceBundle, "ActionsRename");
        this.miRename = new JMenuItem(actionString.getString());
        this.actionsMenu.add(this.miRename);
        this.miRename.setMnemonic(actionString.getMnemonic());
        this.miRename.setActionCommand("Rename");
        this.miRename.addActionListener(hostActionsListener);
        this.add((JMenu)this.actionsMenu);
        actionString = new ActionString(resourceBundle, "ViewMenu");
        this.viewMenu = new JMenuPlus(actionString.getString());
        this.viewMenu.setMnemonic(actionString.getMnemonic());
        this.viewMenu.setActionCommand("VMenuID.VIEW");
        actionString = new ActionString(resourceBundle, "ViewAllHosts");
        this.miShowAll = new JMenuItem(actionString.getString());
        this.viewMenu.add(this.miShowAll);
        this.miShowAll.setMnemonic(actionString.getMnemonic());
        this.miShowAll.setActionCommand("ShowAll");
        this.miShowAll.addActionListener(hostActionsListener);
        this.miShowAll.setSelected(true);
        actionString = new ActionString(resourceBundle, "ViewShowNetworks");
        this.miShowNetworks = new JMenuItem(actionString.getString());
        this.viewMenu.add(this.miShowNetworks);
        this.miShowNetworks.setMnemonic(actionString.getMnemonic());
        this.miShowNetworks.setActionCommand("ShowByType");
        this.miShowNetworks.addActionListener(hostActionsListener);
        this.add((JMenu)this.viewMenu);
        actionString = new ActionString(resourceBundle, "HelpMenu");
        this.helpMenu = new JMenuPlus(actionString.getString());
        this.helpMenu.setMnemonic(actionString.getMnemonic());
        this.helpMenu.setActionCommand("VMenuID.HELP");
        actionString = new ActionString(resourceBundle, "HelpAbout");
        this.miAbout = new JMenuItem(actionString.getString());
        this.helpMenu.add(this.miAbout);
        this.miAbout.setMnemonic(actionString.getMnemonic());
        this.miAbout.setActionCommand("About");
        this.miAbout.addActionListener(hostActionsListener);
        this.add((JMenu)this.helpMenu);
        actionString = new ActionString(resourceBundle, "ActionsMenu");
        this.popupMenu = new JMenuPlus(actionString.getString());
        this.popupMenu.setMnemonic(actionString.getMnemonic());
        actionString = new ActionString(resourceBundle, "ActionsOpen");
        this.miPopupOpen = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupOpen);
        this.miPopupOpen.setMnemonic(actionString.getMnemonic());
        this.miPopupOpen.setActionCommand("Open");
        this.miPopupOpen.addActionListener(hostActionsListener);
        actionString = new ActionString(resourceBundle, "ActionsAddNetwork");
        this.miPopupAdd = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupAdd);
        this.miPopupAdd.setMnemonic(actionString.getMnemonic());
        this.miPopupAdd.setActionCommand("New");
        this.miPopupAdd.addActionListener(hostActionsListener);
        actionString = new ActionString(resourceBundle, "ActionsDelete");
        this.miPopupDelete = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupDelete);
        this.miPopupDelete.setMnemonic(actionString.getMnemonic());
        this.miPopupDelete.setActionCommand("Delete");
        this.miPopupDelete.addActionListener(hostActionsListener);
        actionString = new ActionString(resourceBundle, "ActionsRename");
        this.miPopupRename = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupRename);
        this.miPopupRename.setMnemonic(actionString.getMnemonic());
        this.miPopupRename.setActionCommand("Rename");
        this.miPopupRename.addActionListener(hostActionsListener);
        actionString = new ActionString(resourceBundle, "ActionsProperties");
        this.miPopupProperties = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupProperties);
        this.miPopupProperties.setMnemonic(actionString.getMnemonic());
        this.miPopupProperties.setActionCommand("ViewProps");
        this.miPopupProperties.addActionListener(hostActionsListener);
        this.setMinimumSize(this.getPreferredSize());
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                MainMenuBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        vHostMgr.addNavigationSelectionListener(new NavigationSelectionListener(){

            public void valueChanged(VScopeNode vScopeNode) {
                if (MainMenuBar.this.content != null) {
                    MainMenuBar.this.content.removeContentListener(MainMenuBar.this.contentListener);
                }
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                MainMenuBar.this.content = treeNodeData.getContent();
                MainMenuBar.this.content.addContentListener(MainMenuBar.this.contentListener);
                MainMenuBar.this.configureForContent();
                MainMenuBar.this.notifySelectionChange(MainMenuBar.this.content.getNumSelections());
            }

            public void toolStopped() {
            }

            public void toolDestroyed() {
            }
        });
    }

    private void configureForContent() {
        ActionString actionString;
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        ApplicationContext applicationContext = this.theApp.getApplicationContext();
        this.miShowAll.setEnabled(this.content.isFilteringSupported());
        this.miShowNetworks.setEnabled(this.content.isShowByTypeSupported());
        this.miAdd.setEnabled(true);
        this.miPopupAdd.setEnabled(true);
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        if (this.content instanceof NetworkContent) {
            this.miRename.setEnabled(false);
            this.miOpen.setEnabled(true);
            this.miPopupRename.setEnabled(false);
            this.miPopupOpen.setEnabled(true);
            actionString = this.content.whatAmI().equals("networks") ? new ActionString(resourceBundle, "ActionsAddNetwork") : new ActionString(resourceBundle, "ActionsAddSubnetwork");
            if (!applicationContext.isNetworksSupported()) {
                this.miShowNetworks.setEnabled(false);
                this.miAdd.setEnabled(false);
                this.miPopupAdd.setEnabled(false);
            }
        } else {
            this.miRename.setEnabled(true);
            this.miOpen.setEnabled(false);
            this.miPopupRename.setEnabled(true);
            this.miPopupOpen.setEnabled(false);
            actionString = new ActionString(resourceBundle, "ActionsAddHost");
        }
        this.miAdd.setText(actionString.getString());
        this.miAdd.setMnemonic(actionString.getMnemonic());
        this.miPopupAdd.setText(actionString.getString());
        this.miPopupAdd.setMnemonic(actionString.getMnemonic());
        if (!this.theApp.getHostMgr().hasWriteAuthorization()) {
            this.miAdd.setEnabled(false);
            vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
            this.miPopupDelete.setEnabled(false);
            this.miRename.setEnabled(false);
        }
    }

    private void notifySelectionChange(int n) {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        if (n == 1) {
            this.miPopupProperties.setEnabled(true);
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "true");
        } else {
            this.miPopupProperties.setEnabled(false);
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "false");
        }
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        vConsoleProperties.setProperty("vconsole.deleteenabled", bl ? "true" : "false");
        this.miPopupDelete.setEnabled(bl);
        if (this.content instanceof HostContent) {
            if (n == 1) {
                this.miRename.setEnabled(true);
                this.miPopupRename.setEnabled(true);
            } else {
                this.miRename.setEnabled(false);
                this.miPopupRename.setEnabled(false);
            }
        }
        if (this.content instanceof NetworkContent) {
            if (n == 1) {
                this.miOpen.setEnabled(true);
                this.miPopupOpen.setEnabled(true);
            } else {
                this.miOpen.setEnabled(false);
                this.miPopupOpen.setEnabled(false);
            }
        }
        if (!this.theApp.getHostMgr().hasWriteAuthorization()) {
            this.miAdd.setEnabled(false);
            this.miPopupAdd.setEnabled(false);
            vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
            this.miPopupDelete.setEnabled(false);
            this.miRename.setEnabled(false);
            this.miPopupRename.setEnabled(false);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu.getPopupMenu();
    }
}

