/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

public class Ascii {
    private static final byte[] toUpper;
    private static final byte[] toLower;
    private static final boolean[] isAlpha;
    private static final boolean[] isUpper;
    private static final boolean[] isLower;
    private static final boolean[] isWhite;
    private static final boolean[] isDigit;

    public static int toUpper(int n) {
        return toUpper[n & 0xFF] & 0xFF;
    }

    public static int toLower(int n) {
        return toLower[n & 0xFF] & 0xFF;
    }

    public static boolean isAlpha(int n) {
        return isAlpha[n & 0xFF];
    }

    public static boolean isUpper(int n) {
        return isUpper[n & 0xFF];
    }

    public static boolean isLower(int n) {
        return isLower[n & 0xFF];
    }

    public static boolean isWhite(int n) {
        return isWhite[n & 0xFF];
    }

    public static boolean isDigit(int n) {
        return isDigit[n & 0xFF];
    }

    public static int parseInt(byte[] byArray, int n, int n2) throws NumberFormatException {
        byte by;
        if (byArray == null || n2 <= 0 || !Ascii.isDigit(by = byArray[n++])) {
            throw new NumberFormatException();
        }
        int n3 = by - 48;
        while (--n2 > 0) {
            if (!Ascii.isDigit(by = byArray[n++])) {
                throw new NumberFormatException();
            }
            n3 = n3 * 10 + by - 48;
        }
        return n3;
    }

    static {
        int n;
        toUpper = new byte[256];
        toLower = new byte[256];
        isAlpha = new boolean[256];
        isUpper = new boolean[256];
        isLower = new boolean[256];
        isWhite = new boolean[256];
        isDigit = new boolean[256];
        for (n = 0; n < 256; ++n) {
            Ascii.toUpper[n] = (byte)n;
            Ascii.toLower[n] = (byte)n;
        }
        for (n = 97; n <= 122; ++n) {
            int n2 = n + 65 - 97;
            Ascii.toUpper[n] = (byte)n2;
            Ascii.toLower[n2] = (byte)n;
            Ascii.isAlpha[n] = true;
            Ascii.isAlpha[n2] = true;
            Ascii.isLower[n] = true;
            Ascii.isUpper[n2] = true;
        }
        Ascii.isWhite[32] = true;
        Ascii.isWhite[9] = true;
        Ascii.isWhite[13] = true;
        Ascii.isWhite[10] = true;
        Ascii.isWhite[12] = true;
        Ascii.isWhite[8] = true;
        for (n = 48; n <= 57; ++n) {
            Ascii.isDigit[n] = true;
        }
    }
}

