/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.MimeHeaderField;
import com.sun.web.util.MimeHeadersEnumerator;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;

public class MimeHeaders {
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private byte[] buf;

    public MimeHeaders(int n) {
        this.buf = new byte[n];
    }

    public MimeHeaders() {
        this(512);
    }

    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.headers[i].reset();
        }
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public Enumeration names() {
        return new MimeHeadersEnumerator(this);
    }

    public void putHeader(String string, String string2) {
        this.putHeader(string).setValue(string2);
    }

    public void putIntHeader(String string, int n) {
        this.putHeader(string).setIntValue(n);
    }

    public void putDateHeader(String string, long l) {
        this.putHeader(string).setDateValue(l);
    }

    public void putDateHeader(String string) {
        this.putHeader(string).setDateValue();
    }

    public String getHeader(String string) {
        MimeHeaderField mimeHeaderField = this.find(string);
        return mimeHeaderField != null ? mimeHeaderField.getValue() : null;
    }

    public String[] getHeaders(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        for (n = 0; n < this.count; ++n) {
            if (!this.headers[n].nameEquals(string)) continue;
            vector.addElement(this.headers[n].getValue());
        }
        if (vector.size() > 0) {
            stringArray = new String[vector.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
        }
        return stringArray;
    }

    public int getIntHeader(String string) throws NumberFormatException {
        MimeHeaderField mimeHeaderField = this.find(string);
        return mimeHeaderField != null ? mimeHeaderField.getIntValue() : -1;
    }

    public long getDateHeader(String string) throws IllegalArgumentException {
        MimeHeaderField mimeHeaderField = this.find(string);
        return mimeHeaderField != null ? mimeHeaderField.getDateValue() : -1L;
    }

    public String getHeaderName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public String getHeader(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public MimeHeaderField getField(int n) {
        return n >= 0 && n < this.count ? this.headers[n] : null;
    }

    public int getFieldCount(String string) {
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].nameEquals(string)) continue;
            ++n;
        }
        return n;
    }

    protected MimeHeaderField find(String string) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].nameEquals(string)) continue;
            return this.headers[i];
        }
        return null;
    }

    public void removeHeader(String string) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].nameEquals(string)) continue;
            MimeHeaderField mimeHeaderField = this.headers[i];
            mimeHeaderField.reset();
            this.headers[i] = this.headers[--this.count];
            this.headers[this.count] = mimeHeaderField;
            return;
        }
    }

    public boolean containsHeader(String string) {
        return this.find(string) != null;
    }

    public void read(ServletInputStream servletInputStream) throws IOException {
        byte[] byArray = this.count == 0 ? this.buf : new byte[this.buf.length];
        int n = 0;
        while (true) {
            int n2 = n;
            while (true) {
                int n3;
                if ((n3 = byArray.length - n) > 0 && (n3 = servletInputStream.readLine(byArray, n, n3)) == -1) {
                    throw new IOException("Connection reset.");
                }
                if (n3 == 0 || byArray[(n += n3) - 1] == 10) break;
                byte[] byArray2 = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            if (--n > n2 && byArray[n - 1] == 13) {
                --n;
            }
            if (n == n2) break;
            this.putHeader().parse(byArray, n2, n - n2);
        }
    }

    public void write(ServletOutputStream servletOutputStream) throws IOException {
        for (int i = 0; i < this.count; ++i) {
            this.headers[i].write(servletOutputStream);
        }
        servletOutputStream.println();
    }

    protected MimeHeaderField putHeader(String string) {
        MimeHeaderField mimeHeaderField = this.find(string);
        if (mimeHeaderField == null) {
            mimeHeaderField = this.putHeader();
            mimeHeaderField.setName(string);
        }
        return mimeHeaderField;
    }

    public void appendHeader(String string, String string2) {
        MimeHeaderField mimeHeaderField = this.putHeader();
        mimeHeaderField.setName(string);
        mimeHeaderField.setValue(string2);
    }

    protected MimeHeaderField putHeader() {
        MimeHeaderField mimeHeaderField;
        int n = this.headers.length;
        if (this.count >= n) {
            MimeHeaderField[] mimeHeaderFieldArray = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, mimeHeaderFieldArray, 0, n);
            this.headers = mimeHeaderFieldArray;
        }
        if ((mimeHeaderField = this.headers[this.count]) == null) {
            this.headers[this.count] = mimeHeaderField = new MimeHeaderField();
        }
        ++this.count;
        return mimeHeaderField;
    }

    public int getAll(byte[] byArray, int n) {
        int n2 = n;
        for (int i = 0; i < this.count; ++i) {
            n += this.headers[i].getBytes(byArray, n);
        }
        return n - n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append("{");
            stringBuffer.append(this.headers[i].toString());
            stringBuffer.append("}");
            if (i >= this.count - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void dump(PrintStream printStream) {
        for (int i = 0; i < this.count; ++i) {
            printStream.println(this.headers[i]);
        }
    }
}

