/*
 * Copyright (c) 1997-1998 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _TODMOSTEK_H
#define	_TODMOSTEK_H

#pragma ident	"@(#)todmostek.h	1.3	98/01/06 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

extern caddr_t v_eeprom_addr;
extern caddr_t v_timecheck_addr;

#define	V_TOD_OFFSET		0x1FF0
#define	V_TODCLKADDR		(v_eeprom_addr+V_TOD_OFFSET)
#define	V_TIMECHECKADDR		(v_timecheck_addr+V_TOD_OFFSET)

/*
 * Definitions for the Mostek 48T59 clock chip. We use this chip as
 * our TOD clock. Clock interrupts are generated by a separate timer
 * circuit.
 */

#define	YRBASE		68	/* 1968 - what year 0 in chip represents */

#ifndef _ASM
struct mostek48T59 {
	volatile uchar_t clk_flags;	/* flags register */
	volatile uchar_t clk_unused;	/* unused */
	volatile uchar_t clk_alm_secs;	/* alarm - seconds 0-59 */
	volatile uchar_t clk_alm_mins;	/* alarm - minutes 0-59 */
	volatile uchar_t clk_alm_hours;	/* alarm - hours 0-23 */
	volatile uchar_t clk_alm_day;	/* alarm - day 1-31 */
	volatile uchar_t clk_interrupts; /* interrupts register */
	volatile uchar_t clk_watchdog;	/* watchdog register */
	volatile uchar_t clk_ctrl;	/* ctrl register */
	volatile uchar_t clk_sec;	/* counter - seconds 0-59 */
	volatile uchar_t clk_min;	/* counter - minutes 0-59 */
	volatile uchar_t clk_hour;	/* counter - hours 0-23 */
	volatile uchar_t clk_weekday;	/* counter - weekday 1-7 */
	volatile uchar_t clk_day;	/* counter - day 1-31 */
	volatile uchar_t clk_month;	/* counter - month 1-12 */
	volatile uchar_t clk_year;	/* counter - year 0-99 */
};

#define	CLOCK ((struct mostek48T59 *)(V_TODCLKADDR))
#define	TIMECHECK_CLOCK ((struct mostek48T59 *)(V_TIMECHECKADDR))

#endif	/* _ASM */

/*
 * Bit masks for various operations and register limits.
 */
#define	CLK_CTRL_WRITE		0x80
#define	CLK_CTRL_READ		0x40
#define	CLK_CTRL_SIGN		0x20

#define	CLK_STOP		0x80
#define	CLK_KICK		0x80
#define	CLK_FREQT		0x40

#define	CLK_MONTH_MASK		0x1f
#define	CLK_DAY_MASK		0x3f
#define	CLK_WEEKDAY_MASK	0x07
#define	CLK_HOUR_MASK		0x3f
#define	CLK_MIN_MASK		0x7f
#define	CLK_SEC_MASK		0x7f

#define	CLK_ALARM_ENABLE	0xa0

/*
 * If the passed in time is non-zero, enable the watchdog and set the scale
 * to seconds
 */
#define	CLK_WATCHDOG_ENABLE	0x80
#define	CLK_WATCHDOG_1SEC	0x02
#define	CLK_WATCHDOG_TMASK	0x1f
#define	CLK_WATCHDOG_BITS(n)	(((n) & CLK_WATCHDOG_TMASK) ? \
				((((n) & CLK_WATCHDOG_TMASK) << 2) | \
				CLK_WATCHDOG_ENABLE | CLK_WATCHDOG_1SEC) : 0)

#ifdef	__cplusplus
}
#endif

#endif	/* !_TODMOSTEK_H */
