/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.AssertionException;

public class ANY
implements ASN1Value {
    private byte[] encoded;
    private Tag tag;
    private ASN1Header header = null;
    private byte[] contents = null;
    private static Template templateInstance = new Template();

    private ANY() {
    }

    public ANY(Tag tag, byte[] byArray) {
        this.encoded = byArray;
        this.tag = tag;
    }

    public ANY(byte[] byArray) throws InvalidBERException {
        try {
            this.encoded = byArray;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1Header aSN1Header = new ASN1Header(byteArrayInputStream);
            this.tag = aSN1Header.getTag();
        }
        catch (IOException iOException) {
            throw new AssertionException("IOException while creating ANY: " + iOException);
        }
    }

    public ASN1Value decodeWith(ASN1Template aSN1Template) throws InvalidBERException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
            return aSN1Template.decode(byteArrayInputStream);
        }
        catch (IOException iOException) {
            Assert.notReached("IOException while reading from byte array input stream");
            return null;
        }
    }

    public ASN1Value decodeWith(Tag tag, ASN1Template aSN1Template) throws IOException, InvalidBERException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
        return aSN1Template.decode(tag, byteArrayInputStream);
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encoded);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        if (!tag.equals(this.tag)) {
            Assert.notReached("No implicit tags allowed for ANY");
        }
        outputStream.write(this.encoded);
    }

    public void encodeWithAlternateTag(Tag tag, OutputStream outputStream) throws IOException, InvalidBERException {
        ASN1Header aSN1Header;
        byte[] byArray = this.getContents();
        Assert.assert((long)byArray.length == (aSN1Header = this.getHeader()).getContentLength());
        ASN1Header aSN1Header2 = new ASN1Header(tag, aSN1Header.getForm(), byArray.length);
        aSN1Header2.encode(outputStream);
        outputStream.write(byArray);
    }

    public byte[] getContents() throws InvalidBERException {
        try {
            if (this.contents == null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
                this.header = new ASN1Header(byteArrayInputStream);
                this.contents = new byte[byteArrayInputStream.available()];
                if ((long)this.contents.length != this.header.getContentLength() && this.header.getContentLength() != -1L) {
                    throw new InvalidBERException("Length of contents was not the same as the header predicted");
                }
                ASN1Util.readFully(this.contents, byteArrayInputStream);
            }
            return this.contents;
        }
        catch (IOException iOException) {
            Assert.notReached("IOException reading from byte array");
            return null;
        }
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public ASN1Header getHeader() throws InvalidBERException, IOException {
        if (this.header == null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
            this.header = new ASN1Header(byteArrayInputStream);
        }
        return this.header;
    }

    public Tag getTag() {
        return this.tag;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            try {
                ASN1Header aSN1Header = ASN1Header.lookAhead(inputStream);
                if (aSN1Header.getContentLength() == -1L) {
                    ANY aNY;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    aSN1Header = new ASN1Header(inputStream);
                    byteArrayOutputStream.write(aSN1Header.encode());
                    Template template = new Template();
                    boolean bl = false;
                    do {
                        aNY = (ANY)template.decode(inputStream);
                        byteArrayOutputStream.write(aNY.getEncoded());
                    } while (!aNY.getTag().equals(Tag.EOC));
                    return new ANY(aSN1Header.getTag(), byteArrayOutputStream.toByteArray());
                }
                byte[] byArray = new byte[(int)aSN1Header.getTotalLength()];
                ASN1Util.readFully(byArray, inputStream);
                return new ANY(aSN1Header.getTag(), byArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ANY");
            }
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            throw new InvalidBERException("Implicit tag on ANY");
        }

        public boolean tagMatch(Tag tag) {
            return true;
        }
    }
}

