/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmc.PendInfo;
import org.mozilla.jss.util.Assert;

public class OtherInfo
implements ASN1Value {
    public static final int BAD_ALG = 0;
    public static final int BAD_MESSAGE_CHECK = 1;
    public static final int BAD_REQUEST = 2;
    public static final int BAD_TIME = 3;
    public static final int BAD_CERT_ID = 4;
    public static final int UNSUPORTED_EXT = 5;
    public static final int MUST_ARCHIVE_KEYS = 6;
    public static final int BAD_IDENTITY = 7;
    public static final int POP_REQUIRED = 8;
    public static final int POP_FAILED = 9;
    public static final int NO_KEY_REUSE = 10;
    public static final int INTERNAL_CA_ERROR = 11;
    public static final int TRY_LATER = 12;
    public static final String[] FAIL_INFO = new String[]{"bad algorithm", "bad message check", "bad request", "bad time", "bad certificate id", "unsupported extensions", "must archive keys", "bad identity", "POP required", "POP failed", "no key reuse", "internal ca error", "try later"};
    public static Type FAIL = Type.FAIL;
    public static Type PEND = Type.PEND;
    private Type type;
    private INTEGER failInfo;
    private PendInfo pendInfo;
    private static final Template templateInstance = new Template();

    public OtherInfo() {
    }

    public OtherInfo(Type type, INTEGER iNTEGER, PendInfo pendInfo) {
        this.type = type;
        this.failInfo = iNTEGER;
        this.pendInfo = pendInfo;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.type == FAIL) {
            this.failInfo.encode(outputStream);
        } else {
            Assert.assert(this.type == PEND);
            this.pendInfo.encode(outputStream);
        }
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.encode(outputStream);
    }

    public INTEGER getFailInfo() {
        return this.failInfo;
    }

    public PendInfo getPendInfo() {
        return this.pendInfo;
    }

    public Tag getTag() {
        if (this.type == FAIL) {
            return INTEGER.TAG;
        }
        Assert.assert(this.type == PEND);
        return PendInfo.TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public Type getType() {
        return this.type;
    }

    public static class Type {
        static Type FAIL = new Type();
        static Type PEND = new Type();

        private Type() {
        }
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(INTEGER.getTemplate());
            this.choicet.addElement(PendInfo.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            CHOICE cHOICE = (CHOICE)this.choicet.decode(inputStream);
            if (cHOICE.getTag().equals(INTEGER.TAG)) {
                return new OtherInfo(FAIL, (INTEGER)cHOICE.getValue(), null);
            }
            Assert.assert(cHOICE.getTag().equals(PendInfo.TAG));
            return new OtherInfo(PEND, null, (PendInfo)cHOICE.getValue());
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(inputStream);
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }
    }
}

