/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cms.DigestedData;
import org.mozilla.jss.pkix.cms.EncryptedData;
import org.mozilla.jss.pkix.cms.EnvelopedData;
import org.mozilla.jss.pkix.cms.SignedAndEnvelopedData;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.util.Assert;

public class ContentInfo
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    public static OBJECT_IDENTIFIER DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 1L});
    public static OBJECT_IDENTIFIER SIGNED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 2L});
    public static OBJECT_IDENTIFIER ENVELOPED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 3L});
    public static OBJECT_IDENTIFIER SIGNED_AND_ENVELOPED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 4L});
    public static OBJECT_IDENTIFIER DIGESTED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 5L});
    public static OBJECT_IDENTIFIER ENCRYPTED_DATA = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 6L});
    private OBJECT_IDENTIFIER contentType;
    private ANY content;
    private SEQUENCE sequence = new SEQUENCE();
    private static Template templateInstance = new Template();

    private ContentInfo() {
    }

    public ContentInfo(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value) {
        this.contentType = oBJECT_IDENTIFIER;
        this.sequence.addElement(oBJECT_IDENTIFIER);
        if (aSN1Value != null) {
            if (aSN1Value instanceof ANY) {
                this.content = (ANY)aSN1Value;
            } else {
                try {
                    this.content = (ANY)ASN1Util.decode(ANY.getTemplate(), ASN1Util.encode(aSN1Value));
                }
                catch (InvalidBERException invalidBERException) {
                    Assert.notReached("InvalidBERException while convertingASN1Value to ANY");
                }
            }
            this.sequence.addElement(new EXPLICIT(new Tag(0L), aSN1Value));
        }
    }

    public ContentInfo(DigestedData digestedData) {
        this(DIGESTED_DATA, digestedData);
    }

    public ContentInfo(EncryptedData encryptedData) {
        this(ENCRYPTED_DATA, encryptedData);
    }

    public ContentInfo(EnvelopedData envelopedData) {
        this(ENVELOPED_DATA, envelopedData);
    }

    public ContentInfo(SignedAndEnvelopedData signedAndEnvelopedData) {
        this(SIGNED_AND_ENVELOPED_DATA, signedAndEnvelopedData);
    }

    public ContentInfo(SignedData signedData) {
        this(SIGNED_DATA, signedData);
    }

    public ContentInfo(byte[] byArray) {
        this(DATA, new OCTET_STRING(byArray));
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public ANY getContent() {
        return this.content;
    }

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public ASN1Value getInterpretedContent() throws InvalidBERException {
        if (this.contentType.equals(DATA)) {
            return this.content.decodeWith(new OCTET_STRING.Template());
        }
        if (this.contentType.equals(SIGNED_DATA)) {
            return this.content.decodeWith(new SignedData.Template());
        }
        if (this.contentType.equals(ENVELOPED_DATA)) {
            return this.content.decodeWith(new EnvelopedData.Template());
        }
        if (this.contentType.equals(SIGNED_AND_ENVELOPED_DATA)) {
            return this.content.decodeWith(new SignedAndEnvelopedData.Template());
        }
        if (this.contentType.equals(DIGESTED_DATA)) {
            return this.content.decodeWith(new DigestedData.Template());
        }
        if (this.contentType.equals(ENCRYPTED_DATA)) {
            return this.content.decodeWith(new EncryptedData.Template());
        }
        return this.content;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new OBJECT_IDENTIFIER.Template());
            this.seqt.addOptionalElement(new EXPLICIT.Template(new Tag(0L), new ANY.Template()));
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert.assert(sEQUENCE.size() == 2);
            ASN1Value aSN1Value = sEQUENCE.elementAt(1) == null ? null : ((EXPLICIT)sEQUENCE.elementAt(1)).getContent();
            return new ContentInfo((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), aSN1Value);
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }
    }
}

