/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.ug;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.ug.CertImportDialog;
import com.netscape.admin.certsrv.ug.CertViewDialog;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class CertManagementDialog
extends JDialog
implements ActionListener,
MouseListener {
    private String PREFIX = "CERTMANAGEMENTDIALOG";
    private JFrame mParentFrame;
    private AdminConnection mConnection;
    private ResourceBundle mResource;
    protected DefaultListModel mDataModel;
    protected Vector mPPData;
    protected String mUID;
    protected CertViewDialog mViewDialog;
    protected CertImportDialog mCertDialog;
    private JScrollPane mScrollPane;
    private JList mList;
    private JButton mOK;
    private JButton mCancel;
    private JButton mAdd;
    private JButton mDelete;
    private JButton mView;
    private JButton mHelp;
    private static final String HELPINDEX = "usersgroups-certsrv-manage-usercert-dbox-help";
    static /* synthetic */ Class class$com$netscape$admin$certsrv$CMSAdminResources;

    public CertManagementDialog(JFrame parent, AdminConnection conn) {
        super((Frame)parent, true);
        this.mParentFrame = parent;
        this.mConnection = conn;
        this.mResource = ResourceBundle.getBundle((class$com$netscape$admin$certsrv$CMSAdminResources != null ? class$com$netscape$admin$certsrv$CMSAdminResources : (class$com$netscape$admin$certsrv$CMSAdminResources = CertManagementDialog.class$("com.netscape.admin.certsrv.CMSAdminResources"))).getName());
        this.mDataModel = new DefaultListModel();
        this.mPPData = new Vector();
        ((Component)((Object)this)).setSize(800, 216);
        ((Dialog)((Object)this)).setTitle(this.mResource.getString(String.valueOf(this.PREFIX) + "_TITLE"));
        this.setLocationRelativeTo((Component)parent);
        this.getRootPane().setDoubleBuffered(true);
        this.setDisplay();
    }

    public void showDialog(String uid) {
        this.mUID = uid;
        if (!this.refresh()) {
            return;
        }
        this.setButtons();
        ((Dialog)((Object)this)).show();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.mOK)) {
            ((Window)((Object)this)).dispose();
        }
        if (evt.getSource().equals(this.mCancel)) {
            ((Window)((Object)this)).dispose();
        }
        if (evt.getSource().equals(this.mAdd)) {
            if (this.mCertDialog == null) {
                this.mCertDialog = new CertImportDialog(this.mParentFrame);
            }
            this.mCertDialog.showDialog();
            if (!this.mCertDialog.isOK()) {
                return;
            }
            this.addCert(this.mCertDialog.getB64E());
            this.refresh();
        }
        if (evt.getSource().equals(this.mDelete)) {
            this.deleteCert();
            this.refresh();
        }
        if (evt.getSource().equals(this.mView)) {
            if (this.mViewDialog == null) {
                this.mViewDialog = new CertViewDialog(this.mParentFrame);
            }
            String id = ((JLabel)this.mDataModel.elementAt(this.mList.getSelectedIndex())).getText();
            this.mViewDialog.showDialog(id, (String)this.mPPData.elementAt(this.mList.getSelectedIndex()));
        }
        if (evt.getSource().equals(this.mHelp)) {
            CMSAdminUtil.help((String)HELPINDEX);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.setButtons();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.setButtons();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.setButtons();
    }

    private void setDisplay() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel center = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        center.setLayout(gb);
        JPanel content = this.makeContentPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)content, gbc);
        center.add((Component)content);
        JPanel action = this.makeActionPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gb.setConstraints((Component)action, gbc);
        center.add((Component)action);
        this.getContentPane().add("Center", (Component)center);
    }

    protected JPanel createUDButtonPanel() {
        this.mAdd = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"IMPORT", null, (ActionListener)this);
        this.mDelete = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"DELETE", null, (ActionListener)this);
        this.mView = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"VIEW", null, (ActionListener)this);
        JButton[] buttons = new JButton[]{this.mAdd, this.mDelete, this.mView};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonVPanel((JButton[])buttons);
    }

    private JPanel makeActionPane() {
        this.mOK = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"OK", null, (ActionListener)this);
        this.mCancel = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"CANCEL", null, (ActionListener)this);
        this.mHelp = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"HELP", null, (ActionListener)this);
        JButton[] buttons = new JButton[]{this.mOK, this.mHelp};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    private JPanel makeContentPane() {
        JPanel mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mListPanel.setLayout(gb);
        this.mList = CMSAdminUtil.makeJList((DefaultListModel)this.mDataModel, (int)10);
        this.mScrollPane = new JScrollPane((Component)this.mList, 22, 32);
        this.mList.setSelectionMode(0);
        this.mList.addMouseListener(this);
        this.mScrollPane.setBackground(Color.white);
        this.mScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 6, 0, 0);
        gb.setConstraints((Component)this.mScrollPane, gbc);
        mListPanel.add((Component)this.mScrollPane);
        JPanel buttonPanel = this.createUDButtonPanel();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(6, 0, 0, 6);
        gb.setConstraints((Component)buttonPanel, gbc);
        mListPanel.add((Component)buttonPanel);
        return mListPanel;
    }

    private void setButtons() {
        if (this.mList.getSelectedIndex() < 0) {
            this.mDelete.setEnabled(false);
            this.mView.setEnabled(false);
            return;
        }
        this.mDelete.setEnabled(true);
        this.mView.setEnabled(true);
    }

    private boolean refresh() {
        NameValuePairs response;
        this.mDataModel.clear();
        this.mPPData.removeAllElements();
        try {
            response = this.mConnection.read("ug", "certs", this.mUID, new NameValuePairs());
        }
        catch (EAdminException e) {
            CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.getMessage(), (int)0);
            return false;
        }
        String[] vals = new String[response.size()];
        int i = 0;
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            vals[i++] = ((String)e.nextElement()).trim();
        }
        CMSAdminUtil.bubbleSort((String[])vals);
        int y = 0;
        while (y < vals.length) {
            String str = this.reformat(vals[y]);
            this.mDataModel.addElement((Object)new JLabel(str, (Icon)CMSAdminUtil.getImage((String)"CertificateServer.gif"), 2));
            this.mPPData.addElement(response.getValue(vals[y]));
            ++y;
        }
        return true;
    }

    private String reformat(String val) {
        String name = "";
        StringTokenizer st = new StringTokenizer(val, ";", false);
        String version = null;
        String serial = null;
        String issuer = null;
        String subject = null;
        try {
            version = st.nextToken();
            serial = st.nextToken();
            issuer = st.nextToken();
            subject = st.nextToken();
        }
        catch (Exception exception) {}
        try {
            if (serial != null) {
                String hexserial = Integer.toHexString(Integer.parseInt(serial));
                name = String.valueOf(name) + "Serial:0x" + hexserial;
            }
        }
        catch (Exception exception) {}
        if (subject != null) {
            name = String.valueOf(name) + "     Subject:" + subject;
        }
        if (issuer != null) {
            name = String.valueOf(name) + "     Issuer:" + issuer;
        }
        return name;
    }

    private void addCert(String B64E) {
        NameValuePairs config = new NameValuePairs();
        config.add("cert", this.cleanupCertData(B64E));
        try {
            this.mConnection.add("ug", "certs", this.mUID, config);
        }
        catch (EAdminException e) {
            CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.getMessage(), (int)0);
            return;
        }
    }

    private String cleanupCertData(String data) {
        StringBuffer input = new StringBuffer(data);
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c != '\n' && c != '\r') {
                buff.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    private void deleteCert() {
        String dn = ((JLabel)this.mDataModel.elementAt(this.mList.getSelectedIndex())).getText();
        dn = this.reformat(dn);
        NameValuePairs config = new NameValuePairs();
        config.add("cert", dn);
        try {
            this.mConnection.modify("ug", "certs", this.mUID, config);
        }
        catch (EAdminException e) {
            CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.getMessage(), (int)0);
            return;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

